/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data;

import com.lovetropics.extras.NamedSupplier;
import com.lovetropics.extras.block.BoringEndRodBlock;
import com.lovetropics.extras.block.GirderBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class ModelGenUtil {
    public static void steelGirderBlockstate(DataGenContext<Block, GirderBlock> ctx, RegistrateBlockstateProvider prov) {
        ResourceLocation template = prov.modLoc("block/girder_straight");
        ModelBuilder model = prov.models().singleTexture(ctx.getName(), template, prov.modLoc("block/" + ctx.getName()));
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
        ((MultiPartBlockStateBuilder.PartBuilder)ModelGenUtil.addSteelGirderVariants((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)builder.part(), (ModelFile)model, 90, 90).addModel()).condition((Property)GirderBlock.PROPS.get(Direction.Axis.X), (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)ModelGenUtil.addSteelGirderVariants((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)builder.part(), (ModelFile)model, 0, 0).addModel()).condition((Property)GirderBlock.PROPS.get(Direction.Axis.Y), (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)ModelGenUtil.addSteelGirderVariants((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)builder.part(), (ModelFile)model, 90, 0).addModel()).condition((Property)GirderBlock.PROPS.get(Direction.Axis.Z), (Comparable[])new Boolean[]{true}).end();
        ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> allModels = ModelGenUtil.addSteelGirderVariants((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)builder.part(), (ModelFile)model, 90, 90);
        allModels = ModelGenUtil.addSteelGirderVariants(allModels, (ModelFile)model, 0, 0);
        allModels = ModelGenUtil.addSteelGirderVariants(allModels, (ModelFile)model, 90, 0);
        MultiPartBlockStateBuilder.PartBuilder allParts = (MultiPartBlockStateBuilder.PartBuilder)allModels.addModel();
        for (Direction.Axis a : Direction.Axis.values()) {
            allParts = allParts.condition((Property)GirderBlock.PROPS.get(a), (Comparable[])new Boolean[]{false});
        }
        allParts.end();
    }

    private static ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> addSteelGirderVariants(ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> builder, ModelFile model, int xRot, int yRot) {
        return builder.modelFile(model).rotationX(xRot).rotationY(yRot).weight(1).uvLock(true);
    }

    public static ConfiguredModel scaffoldingModel(DataGenContext<Block, ScaffoldingBlock> ctx, RegistrateBlockstateProvider prov, String suffix) {
        return new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + suffix, "scaffolding_" + suffix)).texture("bottom", prov.modLoc("block/metal_scaffolding_bottom"))).texture("top", prov.modLoc("block/metal_scaffolding_top"))).texture("side", prov.modLoc("block/metal_scaffolding_side"))).texture("particle", prov.modLoc("block/metal_scaffolding_top")));
    }

    public static void barsBlock(DataGenContext<Block, IronBarsBlock> ctx, RegistrateBlockstateProvider prov) {
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.getEntry());
        ModelFile cap = ModelGenUtil.barsModel(prov, ctx, "cap");
        ModelFile capAlt = ModelGenUtil.barsModel(prov, ctx, "cap_alt");
        ModelFile side = ModelGenUtil.barsModel(prov, ctx, "side");
        ModelFile sideAlt = ModelGenUtil.barsModel(prov, ctx, "side_alt");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(ModelGenUtil.barsModel(prov, ctx, "post_ends")).addModel()).end().part().modelFile(ModelGenUtil.barsModel(prov, ctx, "post")).addModel()).condition((Property)IronBarsBlock.f_52309_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52310_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52311_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52312_, (Comparable[])new Boolean[]{false}).end().part().modelFile(cap).addModel()).condition((Property)IronBarsBlock.f_52309_, (Comparable[])new Boolean[]{true}).condition((Property)IronBarsBlock.f_52310_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52311_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52312_, (Comparable[])new Boolean[]{false}).end().part().modelFile(cap).rotationY(90).addModel()).condition((Property)IronBarsBlock.f_52309_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52310_, (Comparable[])new Boolean[]{true}).condition((Property)IronBarsBlock.f_52311_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52312_, (Comparable[])new Boolean[]{false}).end().part().modelFile(capAlt).addModel()).condition((Property)IronBarsBlock.f_52309_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52310_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52311_, (Comparable[])new Boolean[]{true}).condition((Property)IronBarsBlock.f_52312_, (Comparable[])new Boolean[]{false}).end().part().modelFile(capAlt).rotationY(90).addModel()).condition((Property)IronBarsBlock.f_52309_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52310_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52311_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52312_, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).addModel()).condition((Property)IronBarsBlock.f_52309_, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(90).addModel()).condition((Property)IronBarsBlock.f_52310_, (Comparable[])new Boolean[]{true}).end().part().modelFile(sideAlt).addModel()).condition((Property)IronBarsBlock.f_52311_, (Comparable[])new Boolean[]{true}).end().part().modelFile(sideAlt).rotationY(90).addModel()).condition((Property)IronBarsBlock.f_52312_, (Comparable[])new Boolean[]{true}).end();
    }

    private static ModelFile barsModel(RegistrateBlockstateProvider prov, DataGenContext<Block, ?> ctx, String suffix) {
        ResourceLocation tex = prov.blockTexture((Block)ctx.getEntry());
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + suffix, "block/iron_bars_" + suffix)).texture("bars", tex)).texture("edge", tex)).texture("particle", tex);
    }

    private static ResourceLocation blockTexture(NamedSupplier<Block> block) {
        ResourceLocation base = block.getId();
        return new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
    }

    private static ResourceLocation blockTexture(NamedSupplier<Block> block, String suffix) {
        ResourceLocation base = ModelGenUtil.blockTexture(block);
        return new ResourceLocation(base.m_135827_(), base.m_135815_() + "_" + suffix);
    }

    public static ResourceLocation getMainTexture(NamedSupplier<Block> block, TextureType texture) {
        return texture.getSideTexture(block);
    }

    public static void rodBlock(DataGenContext<Block, BoringEndRodBlock> ctx, RegistrateBlockstateProvider prov) {
        ModelFile.ExistingModelFile model = prov.models().getExistingFile(prov.blockTexture(Blocks.f_50489_));
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.getEntry());
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(180).addModel()).condition((Property)RodBlock.f_52588_, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel()).condition((Property)RodBlock.f_52588_, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)model).rotationX(90).addModel()).condition((Property)RodBlock.f_52588_, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)model).rotationX(90).rotationY(180).addModel()).condition((Property)RodBlock.f_52588_, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)model).addModel()).condition((Property)RodBlock.f_52588_, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile((ModelFile)model).rotationX(90).rotationY(270).addModel()).condition((Property)RodBlock.f_52588_, (Comparable[])new Direction[]{Direction.WEST}).end();
    }

    public static <T extends StairBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> stairsBlock(NamedSupplier<Block> object, TextureType textureType) {
        return (ctx, prov) -> {
            ResourceLocation side = textureType.getSideTexture(object);
            ResourceLocation top = textureType.getTopTexture(object);
            prov.stairsBlock((StairBlock)ctx.getEntry(), side, top, top);
        };
    }

    public static <T extends SlabBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> slabBlock(NamedSupplier<Block> object, TextureType textureType) {
        return (ctx, prov) -> {
            ResourceLocation model = textureType.getModel(object);
            ResourceLocation side = textureType.getSideTexture(object);
            ResourceLocation top = textureType.getTopTexture(object);
            prov.slabBlock((SlabBlock)ctx.getEntry(), model, side, top, top);
        };
    }

    public static <T extends FenceBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> fenceBlock(NamedSupplier<Block> object, TextureType textureType) {
        return (ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.getEntry(), textureType.getTopTexture(object));
    }

    public static <T extends WallBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> wallBlock(NamedSupplier<Block> object, TextureType textureType) {
        return (ctx, prov) -> prov.wallBlock((WallBlock)ctx.getEntry(), textureType.getSideTexture(object));
    }

    public static interface TextureType {
        public static TextureType normal() {
            return TextureType.allTexture(ModelGenUtil::blockTexture);
        }

        public static TextureType sideTopSuffix() {
            return new TextureType(){

                @Override
                public ResourceLocation getModel(NamedSupplier<Block> block) {
                    return ModelGenUtil.blockTexture(block);
                }

                @Override
                public ResourceLocation getSideTexture(NamedSupplier<Block> block) {
                    return ModelGenUtil.blockTexture(block, "side");
                }

                @Override
                public ResourceLocation getTopTexture(NamedSupplier<Block> block) {
                    return ModelGenUtil.blockTexture(block, "top");
                }
            };
        }

        public static TextureType allTexture(ResourceLocation texture) {
            return TextureType.allTexture((NamedSupplier<Block> b) -> texture);
        }

        public static TextureType allTexture(Function<NamedSupplier<Block>, ResourceLocation> texture) {
            return TextureType.simple(ModelGenUtil::blockTexture, texture);
        }

        public static TextureType simple(final Function<NamedSupplier<Block>, ResourceLocation> model, final Function<NamedSupplier<Block>, ResourceLocation> texture) {
            return new TextureType(){

                @Override
                public ResourceLocation getModel(NamedSupplier<Block> block) {
                    return (ResourceLocation)model.apply(block);
                }

                @Override
                public ResourceLocation getSideTexture(NamedSupplier<Block> block) {
                    return (ResourceLocation)texture.apply(block);
                }

                @Override
                public ResourceLocation getTopTexture(NamedSupplier<Block> block) {
                    return (ResourceLocation)texture.apply(block);
                }
            };
        }

        public ResourceLocation getModel(NamedSupplier<Block> var1);

        public ResourceLocation getSideTexture(NamedSupplier<Block> var1);

        public ResourceLocation getTopTexture(NamedSupplier<Block> var1);
    }
}

