/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.poi;

import com.lovetropics.extras.data.poi.Poi;
import com.lovetropics.extras.network.ClientboundPoiPacket;
import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.lib.permission.PermissionsApi;
import com.lovetropics.lib.permission.role.RoleOverrideType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="ltextras")
public class MapPoiManager
extends SavedData {
    public static final BoundingBox MAP_BB = new BoundingBox(2013, 0, 1883, 2910, 0, 2799);
    private static final Codec<Map<String, Poi>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, Poi.CODEC);
    private static final String STORAGE_ID = "ltextras_map_poi";
    private final Map<String, Poi> pois;

    public MapPoiManager(Map<String, Poi> pois) {
        this.pois = pois;
    }

    public MapPoiManager() {
        this.pois = new HashMap<String, Poi>();
    }

    public static MapPoiManager get(MinecraftServer server) {
        return (MapPoiManager)server.m_129783_().m_8895_().m_164861_(MapPoiManager::load, MapPoiManager::new, STORAGE_ID);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128365_("map_pois", (Tag)Util.m_260975_((DataResult)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.pois), IllegalStateException::new));
        return tag;
    }

    private static MapPoiManager load(CompoundTag tag) {
        return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("map_pois")).result().map(result -> new MapPoiManager(new HashMap<String, Poi>((Map<String, Poi>)result))).orElseGet(MapPoiManager::new);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MapPoiManager poiManager = MapPoiManager.get(serverPlayer.m_20194_());
            poiManager.getVisiblePois(serverPlayer).forEach(e -> LTExtrasNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundPoiPacket((Poi)e, false)));
        }
    }

    public Collection<Poi> getAllPois() {
        return this.pois.values();
    }

    public Stream<Poi> getVisiblePois(ServerPlayer player) {
        Stream<Poi> stream = this.pois.values().stream();
        if (player.m_20310_(2)) {
            return stream;
        }
        return stream.filter(Poi::enabled);
    }

    public Set<Poi> getEnabledPois() {
        return this.pois.values().stream().filter(Poi::enabled).collect(Collectors.toSet());
    }

    private void removeFace(String name, UUID face) {
        Poi poi = this.pois.get(name);
        if (poi != null) {
            poi.removeFace(face);
            LTExtrasNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundPoiPacket(poi, false));
        }
        this.m_77762_();
    }

    public void addFace(String name, UUID face) {
        Poi poi = this.pois.get(name);
        if (poi != null) {
            this.getAllPois().stream().filter(p -> p != poi).filter(p -> p.faces().contains(face)).forEach(p -> this.removeFace(p.name(), face));
            poi.addFace(face);
            this.m_77762_();
            LTExtrasNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundPoiPacket(poi, false));
        }
    }

    public void clearFaces() {
        this.pois.values().stream().filter(Poi::hasFaces).map(Poi::clearFaces).forEach(p -> LTExtrasNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundPoiPacket((Poi)p, false)));
        this.m_77762_();
    }

    public Set<Poi> getDisabledPois() {
        return this.pois.values().stream().filter(Predicate.not(Poi::enabled)).collect(Collectors.toSet());
    }

    @Nullable
    public Poi getPoi(String name) {
        return this.pois.values().stream().filter(p -> p.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public void add(Poi poi) {
        this.m_77762_();
        this.pois.put(poi.name(), poi);
        this.updateClients(poi);
    }

    public boolean enable(String name) {
        return this.setPoiState(name, true);
    }

    public boolean disable(String name) {
        return this.setPoiState(name, false);
    }

    private boolean setPoiState(String name, boolean newState) {
        this.m_77762_();
        Poi poi = this.pois.get(name);
        if (poi != null) {
            poi.setEnabled(newState);
            this.m_77762_();
            this.updateClients(poi);
            return true;
        }
        return false;
    }

    private void updateClients(Poi poi) {
        LTExtrasNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundPoiPacket(poi, false));
    }

    public void remove(String name) {
        Poi poi = this.pois.remove(name);
        this.m_77762_();
        LTExtrasNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundPoiPacket(poi, true));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.getServer().m_129921_() % 20 != 0) {
            return;
        }
        MapPoiManager manager = MapPoiManager.get(event.getServer());
        Set<ServerPlayer> hosts = MapPoiManager.getHosts(event.getServer());
        if (hosts.isEmpty()) {
            manager.clearFaces();
            return;
        }
        MapPoiManager.addNewFacesToPois(manager, hosts);
        MapPoiManager.removeNoLongerHostingFaces(manager, hosts);
        MapPoiManager.removeFacesInWrongDimensions(manager, hosts);
    }

    private static void removeFacesInWrongDimensions(MapPoiManager manager, Set<ServerPlayer> hosts) {
        for (Poi poi : manager.getAllPois()) {
            for (ServerPlayer host : hosts) {
                if (!poi.faces().contains(host.m_20148_()) || poi.globalPos().m_122640_() == host.m_9236_().m_46472_()) continue;
                manager.removeFace(poi.name(), host.m_20148_());
            }
        }
    }

    private static Set<ServerPlayer> getHosts(MinecraftServer server) {
        return server.m_6846_().m_11314_().stream().filter(FacePredicate::shouldDrawFace).collect(Collectors.toSet());
    }

    private static void addNewFacesToPois(MapPoiManager manager, Set<ServerPlayer> hosts) {
        for (ServerPlayer host : hosts) {
            BlockPos hostPosition = host.m_20183_();
            manager.getEnabledPois().stream().filter(p -> p.globalPos().m_122640_() == host.m_9236_().m_46472_()).min(Comparator.comparingDouble(p -> p.globalPos().m_122646_().m_123331_((Vec3i)hostPosition))).filter(p -> !p.faces().contains(host.m_20148_())).ifPresent(p -> manager.addFace(p.name(), host.m_20148_()));
        }
    }

    private static void removeNoLongerHostingFaces(MapPoiManager manager, Set<ServerPlayer> currentHosts) {
        for (Poi poi : manager.getAllPois()) {
            for (UUID face : poi.faces()) {
                if (!currentHosts.stream().noneMatch(p -> p.m_20148_().equals(face))) continue;
                manager.removeFace(poi.name(), face);
            }
        }
    }

    private static class FacePredicate {
        private static final RoleOverrideType<Boolean> HOST_ROLE = RoleOverrideType.byId((String)"host");
        private static final Predicate<ServerPlayer> SPECIAL_RULE = p -> PermissionsApi.lookup().byPlayer((Player)p).overrides().test(HOST_ROLE);

        private FacePredicate() {
        }

        public static boolean shouldDrawFace(ServerPlayer player) {
            return SPECIAL_RULE.test(player);
        }
    }
}

