/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.poi;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public final class Poi {
    public static final Codec<Poi> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("name").forGetter(Poi::name), (App)ExtraCodecs.f_252442_.fieldOf("description").forGetter(Poi::description), (App)ResourceLocation.f_135803_.fieldOf("resourceLocation").forGetter(Poi::resourceLocation), (App)GlobalPos.f_122633_.fieldOf("blockPos").forGetter(Poi::globalPos), (App)Codec.BOOL.fieldOf("enabled").forGetter(Poi::enabled)).apply((Applicative)i, Poi::new));
    private final String name;
    private final Component description;
    private final ResourceLocation resourceLocation;
    private final GlobalPos globalPos;
    private boolean enabled;
    private List<UUID> faces;

    public Poi(String name, Component description, ResourceLocation resourceLocation, GlobalPos globalPos, boolean enabled, List<UUID> faces) {
        this.name = name;
        this.description = description;
        this.resourceLocation = resourceLocation;
        this.globalPos = globalPos;
        this.enabled = enabled;
        this.faces = new ArrayList<UUID>(faces);
    }

    public Poi(String name, Component description, ResourceLocation resourceLocation, GlobalPos globalPos, boolean enabled) {
        this.name = name;
        this.description = description;
        this.resourceLocation = resourceLocation;
        this.globalPos = globalPos;
        this.enabled = enabled;
        this.faces = new ArrayList<UUID>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Poi poi = (Poi)o;
        return Objects.equals(this.name, poi.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String name() {
        return this.name;
    }

    public Component description() {
        return this.description;
    }

    public ResourceLocation resourceLocation() {
        return this.resourceLocation;
    }

    public GlobalPos globalPos() {
        return this.globalPos;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public List<UUID> faces() {
        return List.copyOf(this.faces);
    }

    public boolean hasFaces() {
        return !this.faces.isEmpty();
    }

    public Poi clearFaces() {
        this.faces.clear();
        return this;
    }

    public void addFace(UUID face) {
        this.faces.add(face);
    }

    public String toString() {
        return "Poi[name=" + this.name + ", description=" + this.description + ", resourceLocation=" + this.resourceLocation + ", globalPos=" + this.globalPos + ", enabled=" + this.enabled + "]";
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void removeFace(UUID face) {
        this.faces.remove(face);
    }
}

