/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.spawnitems;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record SpawnItems(List<Stack> items, boolean canBeRestored, Optional<String> excludeTag) {
    public static final Codec<SpawnItems> CODEC = RecordCodecBuilder.create(in -> in.group((App)Stack.OR_ID.listOf().fieldOf("items").forGetter(SpawnItems::items), (App)Codec.BOOL.optionalFieldOf("can_be_restored", (Object)true).forGetter(SpawnItems::canBeRestored), (App)Codec.STRING.optionalFieldOf("exclude_tag").forGetter(SpawnItems::excludeTag)).apply((Applicative)in, SpawnItems::new));

    public boolean canApplyToPlayer(ServerPlayer player) {
        return this.excludeTag.map(tag -> !player.m_19880_().contains(tag)).orElse(true);
    }

    public record Stack(Item item, int count, Optional<CompoundTag> tag) {
        public static final Codec<Stack> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("id").forGetter(Stack::item), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(Stack::count), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(Stack::tag)).apply((Applicative)i, Stack::new));
        public static final Codec<Stack> OR_ID = Codec.either(CODEC, (Codec)ResourceLocation.f_135803_).xmap(e -> (Stack)e.map(Function.identity(), rl -> new Stack((Item)BuiltInRegistries.f_257033_.m_7745_(rl), 1, Optional.empty())), Either::left);

        public ItemStack build() {
            ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
            this.tag.ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
            return stack;
        }
    }
}

