/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.spawnitems;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.data.spawnitems.SpawnItems;
import com.lovetropics.extras.data.spawnitems.SpawnItemsReloadListener;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod.EventBusSubscriber
@AutoRegisterCapability
public final class SpawnItemsStore
implements ICapabilitySerializable<Tag> {
    public static final ResourceLocation ID = new ResourceLocation("ltextras", "spawn_items");
    private static final Codec<Map<ResourceLocation, List<SpawnItems.Stack>>> CODEC = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)SpawnItems.Stack.CODEC.listOf().xmap(ArrayList::new, Function.identity()));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ResourceLocation, List<SpawnItems.Stack>> receivedItems = new HashMap<ResourceLocation, List<SpawnItems.Stack>>();
    private final LazyOptional<SpawnItemsStore> instance = LazyOptional.of(() -> this);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return LTExtras.SPAWN_ITEMS_STORE.orEmpty(cap, this.instance);
    }

    public Tag serializeNBT() {
        return (Tag)Util.m_260975_((DataResult)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.receivedItems), IllegalStateException::new);
    }

    public void deserializeNBT(Tag nbt) {
        CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(Util.m_137489_((String)"Spawn Items: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(map -> {
            this.receivedItems.clear();
            this.receivedItems.putAll((Map<ResourceLocation, List<SpawnItems.Stack>>)map);
        });
    }

    @SubscribeEvent
    static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayer) {
            event.addCapability(ID, (ICapabilityProvider)new SpawnItemsStore());
        }
    }

    @SubscribeEvent
    static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SpawnItemsStore.sendItems(player2);
        }
    }

    private static void sendItems(ServerPlayer player) {
        SpawnItemsStore cap = SpawnItemsStore.getNullable((Player)player);
        if (cap == null) {
            return;
        }
        Map<ResourceLocation, List<SpawnItems.Stack>> diff = SpawnItemsStore.getDiff(player, cap.receivedItems);
        for (Map.Entry<ResourceLocation, List<SpawnItems.Stack>> entry : diff.entrySet()) {
            entry.getValue().forEach(stack -> {
                if (!player.m_36356_(stack.build())) {
                    player.m_9236_().m_7967_((Entity)player.m_7197_(stack.build(), true, true));
                }
            });
            cap.receivedItems.computeIfAbsent(entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        LOGGER.debug("Sent spawn items from {} sets to player {}: {}", new Object[]{diff.size(), player, diff.keySet()});
    }

    @SubscribeEvent
    static void onReloadResources(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            LOGGER.debug("Sending spawn items to all players after reload...");
            event.getPlayerList().m_11314_().forEach(SpawnItemsStore::sendItems);
        }
    }

    private static Map<ResourceLocation, List<SpawnItems.Stack>> getDiff(ServerPlayer player, Map<ResourceLocation, List<SpawnItems.Stack>> old) {
        HashMap<ResourceLocation, List<SpawnItems.Stack>> diff = new HashMap<ResourceLocation, List<SpawnItems.Stack>>();
        SpawnItemsReloadListener.REGISTRY.forEach((location, items) -> {
            List oldReceived = old.getOrDefault(location, List.of());
            if (items.canApplyToPlayer(player)) {
                diff.put((ResourceLocation)location, items.items().stream().filter(Predicate.not(oldReceived::contains)).toList());
            }
        });
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        if (event.isWasDeath() && !((GameRules.BooleanValue)oldPlayer.m_9236_().m_46469_().m_46170_(GameRules.f_46133_)).m_46223_()) {
            return;
        }
        oldPlayer.reviveCaps();
        try {
            SpawnItemsStore oldStore = SpawnItemsStore.getNullable(oldPlayer);
            SpawnItemsStore newStore = SpawnItemsStore.getNullable(event.getEntity());
            if (oldStore != null && newStore != null) {
                newStore.receivedItems.putAll(oldStore.receivedItems);
            }
        }
        finally {
            oldPlayer.invalidateCaps();
        }
    }

    @Nullable
    public static SpawnItemsStore getNullable(Player player) {
        return (SpawnItemsStore)player.getCapability(LTExtras.SPAWN_ITEMS_STORE).orElse(null);
    }
}

