/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.lovetropics.extras.item.CollectibleCompassItem;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class CollectibleEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String KEY_COLLECTIBLE = "collectible";
    private static final String KEY_PARTICLES = "particles";
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(CollectibleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> DATA_PARTICLES = SynchedEntityData.m_135353_(CollectibleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private Collectible collectible;

    public CollectibleEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public ItemStack getDisplayedItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM);
    }

    public void setCollectible(@Nullable Collectible collectible) {
        this.collectible = collectible;
        this.m_20088_().m_135381_(DATA_ITEM, (Object)(collectible != null ? collectible.createItemStack(Util.f_137441_) : ItemStack.f_41583_));
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_PARTICLES, (Object)true);
    }

    public void m_6123_(Player player) {
        if (!this.m_9236_().f_46443_ && this.collectible != null) {
            this.tryGiveCollectible(player, this.collectible);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.collectible == null) {
            return super.m_6096_(player, hand);
        }
        if (!this.m_9236_().f_46443_) {
            this.tryGiveCollectible(player, this.collectible);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7313_(Entity entity) {
        if (this.collectible != null && entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.m_9236_().f_46443_) {
                this.tryGiveCollectible(player, this.collectible);
            }
            return true;
        }
        return false;
    }

    private void tryGiveCollectible(Player player, Collectible collectible) {
        CollectibleStore collectibles = CollectibleStore.getNullable(player);
        if (collectibles != null && collectibles.give(collectible)) {
            this.recycleCollectibleCompass(player);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_() && this.shouldShowParticles()) {
            this.tickParticles();
        }
    }

    private void tickParticles() {
        double x = this.m_20185_() + this.f_19796_.m_188583_() * 0.2;
        double y = this.m_20186_() + this.f_19796_.m_188583_() * 0.1 + 0.1;
        double z = this.m_20189_() + this.f_19796_.m_188583_() * 0.2;
        double speedX = this.f_19796_.m_188583_() * 0.005;
        double speedY = this.f_19796_.m_188583_() * 0.005;
        double speedZ = this.f_19796_.m_188583_() * 0.005;
        this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123810_, false, x, y, z, speedX, speedY, speedZ);
    }

    private void setShowParticles(boolean particles) {
        this.m_20088_().m_135381_(DATA_PARTICLES, (Object)particles);
    }

    private boolean shouldShowParticles() {
        return (Boolean)this.m_20088_().m_135370_(DATA_PARTICLES);
    }

    private void recycleCollectibleCompass(Player player) {
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            CollectibleCompassItem.Target target = CollectibleCompassItem.getTarget(stack);
            if (target == null || !target.id().equals(this.m_20148_())) continue;
            inventory.m_8016_(i);
            int coinCount = CollectibleCompassItem.getCoinCount(stack);
            if (coinCount <= 0) continue;
            inventory.m_150079_(new ItemStack(ExtraItems.TROPICOIN, coinCount));
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_(KEY_COLLECTIBLE)) {
            Collectible.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(KEY_COLLECTIBLE)).resultOrPartial(Util.m_137489_((String)"Collectible: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(this::setCollectible);
        } else {
            this.setCollectible(null);
        }
        if (tag.m_128425_(KEY_PARTICLES, 1)) {
            this.setShowParticles(tag.m_128471_(KEY_PARTICLES));
        } else {
            this.setShowParticles(true);
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.collectible != null) {
            tag.m_128365_(KEY_COLLECTIBLE, (Tag)Util.m_260975_((DataResult)Collectible.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.collectible), IllegalStateException::new));
        }
        tag.m_128379_(KEY_PARTICLES, this.shouldShowParticles());
    }

    public Component m_5446_() {
        ItemStack displayedItem = this.getDisplayedItem();
        if (displayedItem != null && !this.m_8077_()) {
            return displayedItem.m_41786_();
        }
        return super.m_5446_();
    }

    public boolean m_6052_() {
        return this.m_5446_() != null || super.m_6052_();
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public Collectible getCollectible() {
        return this.collectible;
    }
}

