/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.extras.network.SetHologramTextPacket;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.StaticPreParser;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HologramEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(HologramEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FORWARD_X = SynchedEntityData.m_135353_(HologramEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FORWARD_Y = SynchedEntityData.m_135353_(HologramEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FORWARD_Z = SynchedEntityData.m_135353_(HologramEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_FULLBRIGHT = SynchedEntityData.m_135353_(HologramEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int UPDATE_INTERVAL = 20;
    private static final Vector3f GLOBAL_FORWARD = new Vector3f(0.0f, 0.0f, -1.0f);
    private static final NodeParser TEXT_PARSER = NodeParser.merge((NodeParser[])new NodeParser[]{TextParserV1.DEFAULT, Placeholders.DEFAULT_PLACEHOLDER_PARSER, StaticPreParser.INSTANCE});
    private String templateText = "";
    private TextNode parsedTemplate = TextNode.empty();
    private Component displayText = CommonComponents.f_237098_;
    @Nullable
    private DisplayInfo displayCache;
    private final Map<ServerPlayer, Component> trackingPlayers = new Reference2ObjectOpenHashMap();

    public HologramEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(0.0625f));
        this.f_19804_.m_135372_(DATA_FORWARD_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FORWARD_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FORWARD_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FULLBRIGHT, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (DATA_FORWARD_X.equals(key) || DATA_FORWARD_Y.equals(key) || DATA_FORWARD_Z.equals(key)) {
            this.displayCache = null;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.trackingPlayers.isEmpty() && this.f_19797_ % 20 == 0) {
            this.sendTextUpdatesToPlayers();
        }
    }

    private void sendTextUpdatesToPlayers() {
        for (Map.Entry<ServerPlayer, Component> entry : this.trackingPlayers.entrySet()) {
            ServerPlayer player = entry.getKey();
            Component text = this.resolveTextForPlayer(player);
            if (text.equals(entry.getValue())) continue;
            entry.setValue(text);
            this.sendTextToPlayer(player, text);
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        Component text = this.resolveTextForPlayer(player);
        this.trackingPlayers.put(player, text);
        this.sendTextToPlayer(player, text);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.trackingPlayers.remove(player);
    }

    private Component resolveTextForPlayer(ServerPlayer player) {
        PlaceholderContext context = PlaceholderContext.of((ServerPlayer)player);
        return this.parsedTemplate.toText(context);
    }

    private void sendTextToPlayer(ServerPlayer player, Component text) {
        LTExtrasNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetHologramTextPacket(this.m_19879_(), text));
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("text", 9)) {
            ListTag lines = tag.m_128437_("text", 8);
            this.setTemplateText(lines.stream().map(Tag::m_7916_).collect(Collectors.joining("<r>\n")));
        } else if (tag.m_128425_("text", 8)) {
            this.setTemplateText(tag.m_128461_("text"));
        }
        if (tag.m_128425_("scale", 5)) {
            this.setScale(tag.m_128457_("scale"));
        }
        if (tag.m_128425_("forward", 9)) {
            ListTag forward = tag.m_128437_("forward", 5);
            this.setForward(new Vector3f(forward.m_128775_(0), forward.m_128775_(1), forward.m_128775_(2)));
        }
        if (tag.m_128425_("fullbright", 1)) {
            this.setFullbright(tag.m_128471_("fullbright"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("text", this.templateText);
        tag.m_128350_("scale", this.scale());
        Vector3f forward = this.forward();
        if (forward != null) {
            ListTag forwardList = new ListTag();
            forwardList.add((Object)FloatTag.m_128566_((float)forward.x()));
            forwardList.add((Object)FloatTag.m_128566_((float)forward.y()));
            forwardList.add((Object)FloatTag.m_128566_((float)forward.z()));
            tag.m_128365_("forward", (Tag)forwardList);
        }
        tag.m_128379_("fullbright", this.fullbright());
    }

    public void setTemplateText(String templateText) {
        this.templateText = templateText;
        this.parsedTemplate = TEXT_PARSER.parseNode(templateText);
    }

    public void setDisplayText(Component text) {
        this.displayText = text;
        this.displayCache = null;
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    public float scale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public void setForward(@Nullable Vector3f forward) {
        if (forward != null) {
            this.f_19804_.m_135381_(DATA_FORWARD_X, (Object)Float.valueOf(forward.x()));
            this.f_19804_.m_135381_(DATA_FORWARD_Y, (Object)Float.valueOf(forward.y()));
            this.f_19804_.m_135381_(DATA_FORWARD_Z, (Object)Float.valueOf(forward.z()));
        } else {
            this.f_19804_.m_135381_(DATA_FORWARD_X, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(DATA_FORWARD_Y, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(DATA_FORWARD_Z, (Object)Float.valueOf(0.0f));
        }
        this.displayCache = null;
    }

    @Nullable
    public Vector3f forward() {
        float x = ((Float)this.f_19804_.m_135370_(DATA_FORWARD_X)).floatValue();
        float y = ((Float)this.f_19804_.m_135370_(DATA_FORWARD_Y)).floatValue();
        float z = ((Float)this.f_19804_.m_135370_(DATA_FORWARD_Z)).floatValue();
        if (Mth.m_14033_((float)x, (float)0.0f) && Mth.m_14033_((float)y, (float)0.0f) && Mth.m_14033_((float)z, (float)0.0f)) {
            return null;
        }
        return new Vector3f(x, y, z);
    }

    public void setFullbright(boolean fullbright) {
        this.f_19804_.m_135381_(DATA_FULLBRIGHT, (Object)fullbright);
    }

    public boolean fullbright() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FULLBRIGHT);
    }

    public DisplayInfo display(Function<Component, List<Line>> splitter) {
        DisplayInfo display = this.displayCache;
        if (display == null) {
            Vector3f forward = this.forward();
            this.displayCache = display = this.computeDisplay(splitter, forward);
        }
        return display;
    }

    private DisplayInfo computeDisplay(Function<Component, List<Line>> splitter, Vector3f forward) {
        return new DisplayInfo(forward != null ? new Quaternionf().rotationTo((Vector3fc)GLOBAL_FORWARD, (Vector3fc)forward) : null, splitter.apply(this.displayText));
    }

    public record DisplayInfo(@Nullable Quaternionf rotation, List<Line> lines) {
    }

    public record Line(FormattedCharSequence text, int width) {
    }
}

