/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.lovetropics.extras.entity.CollectibleEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CollectibleCompassItem
extends Item {
    private static final String TAG_TARGET = "target";
    private static final String COIN_COUNT = "coin_count";
    private static final String ENTITY_TAG_IGNORE = "compass_hidden";
    private static final int COOLDOWN_TICKS = 100;
    private static final double SEARCH_RANGE = 80.0;

    public CollectibleCompassItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static Target getTarget(ItemStack stack) {
        if (!stack.m_150930_((Item)ExtraItems.COLLECTIBLE_COMPASS.get())) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_TARGET)) {
            return Target.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_(TAG_TARGET)).result().orElse(null);
        }
        return null;
    }

    public static int getCoinCount(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 0;
        }
        return stack.m_41783_().m_128451_(COIN_COUNT);
    }

    private static void setTarget(ItemStack stack, Target target) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(TAG_TARGET, (Tag)Util.m_260975_((DataResult)Target.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)target), IllegalStateException::new));
    }

    private static boolean hasTarget(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(TAG_TARGET);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        player.m_36335_().m_41524_((Item)this, 100);
        if (CollectibleCompassItem.hasTarget(stack)) {
            player.m_213846_((Component)ExtraLangKeys.COLLECTIBLE_COMPASS_ALREADY_USED.get().m_130940_(ChatFormatting.RED));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        Target target = CollectibleCompassItem.tryLocateCollectible(level, player);
        if (target != null) {
            CollectibleCompassItem.setTarget(stack, target);
            player.m_213846_((Component)ExtraLangKeys.COLLECTIBLE_COMPASS_SUCCESS.get().m_130940_(ChatFormatting.GOLD));
        } else {
            player.m_213846_((Component)ExtraLangKeys.COLLECTIBLE_COMPASS_FAIL.get().m_130940_(ChatFormatting.RED));
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Nullable
    private static Target tryLocateCollectible(Level level, Player player) {
        CollectibleStore collectibles = CollectibleStore.getNullable(player);
        if (collectibles == null) {
            return null;
        }
        List candidates = level.m_6443_(CollectibleEntity.class, player.m_20191_().m_82400_(80.0), entity -> {
            if (entity.m_19880_().contains(ENTITY_TAG_IGNORE)) {
                return false;
            }
            Collectible collectible = entity.getCollectible();
            return collectible != null && !collectibles.contains(collectible);
        });
        return Util.m_214676_((List)candidates, (RandomSource)player.m_217043_()).map(entity -> new Target(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)entity.m_20183_()), entity.m_20148_())).orElse(null);
    }

    public boolean m_5812_(ItemStack stack) {
        return CollectibleCompassItem.hasTarget(stack);
    }

    public record Target(GlobalPos pos, UUID id) {
        public static final Codec<Target> CODEC = RecordCodecBuilder.create(i -> i.group((App)GlobalPos.f_122633_.fieldOf("pos").forGetter(Target::pos), (App)UUIDUtil.f_235867_.fieldOf("id").forGetter(Target::id)).apply((Applicative)i, Target::new));
    }
}

