/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;

public record ImageData(Optional<Component> name, ResourceLocation texture, float width, float height, float offsetX, float offsetY, List<TextElement> text) {
    public static final Codec<ImageData> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.f_252442_.optionalFieldOf("name").forGetter(ImageData::name), (App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(ImageData::texture), (App)Codec.FLOAT.fieldOf("width").forGetter(ImageData::width), (App)Codec.FLOAT.fieldOf("height").forGetter(ImageData::height), (App)Codec.FLOAT.optionalFieldOf("offset_x", (Object)Float.valueOf(0.0f)).forGetter(ImageData::offsetX), (App)Codec.FLOAT.optionalFieldOf("offset_y", (Object)Float.valueOf(0.0f)).forGetter(ImageData::offsetY), (App)TextElement.CODEC.listOf().optionalFieldOf("text", List.of()).forGetter(ImageData::text)).apply((Applicative)i, ImageData::new));
    private static final String TAG_IMAGE = "image";

    public ImageData(Component name, ResourceLocation texture, float width, float height, List<TextElement> text) {
        this(Optional.of(name), texture, width, height, 0.0f, 0.0f, text);
    }

    public ImageData(Component name, ResourceLocation texture, float width, float height) {
        this(Optional.of(name), texture, width, height, 0.0f, 0.0f, List.of());
    }

    public static Optional<ImageData> get(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_IMAGE)) {
            return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(TAG_IMAGE)).result();
        }
        return Optional.empty();
    }

    public static void set(ItemStack stack, ImageData data) {
        stack.m_41784_().m_128365_(TAG_IMAGE, (Tag)Util.m_260975_((DataResult)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)data), IllegalStateException::new));
    }

    public static TextElement text(Component text, float x, float y) {
        return new TextElement(text, x, y, Float.MAX_VALUE, 9.0f, Align.START, Align.START);
    }

    public record TextElement(Component text, float x, float y, float maxWidth, float lineSpacing, Align alignHorizontal, Align alignVertical) {
        private static final float DEFAULT_LINE_SPACING = 9.0f;
        public static final Codec<TextElement> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.f_252442_.fieldOf("text").forGetter(TextElement::text), (App)Codec.FLOAT.fieldOf("x").forGetter(TextElement::x), (App)Codec.FLOAT.fieldOf("y").forGetter(TextElement::y), (App)Codec.FLOAT.optionalFieldOf("max_width", (Object)Float.valueOf(Float.MAX_VALUE)).forGetter(TextElement::maxWidth), (App)Codec.FLOAT.optionalFieldOf("line_spacing", (Object)Float.valueOf(9.0f)).forGetter(TextElement::lineSpacing), (App)Align.CODEC.fieldOf("align_horizontal").forGetter(TextElement::alignHorizontal), (App)Align.CODEC.fieldOf("align_vertical").forGetter(TextElement::alignVertical)).apply((Applicative)i, TextElement::new));

        public TextElement align(Align horizontal, Align vertical) {
            return new TextElement(this.text, this.x, this.y, this.maxWidth, this.lineSpacing, horizontal, vertical);
        }

        public TextElement maxWidth(float maxWidth) {
            return new TextElement(this.text, this.x, this.y, maxWidth, this.lineSpacing, this.alignHorizontal, this.alignVertical);
        }

        public TextElement lineSpacing(float lineSpacing) {
            return new TextElement(this.text, this.x, this.y, this.maxWidth, lineSpacing, this.alignHorizontal, this.alignVertical);
        }
    }

    public static enum Align implements StringRepresentable
    {
        START("start"),
        CENTER("center"),
        END("end");

        public static final Codec<Align> CODEC;
        private final String name;

        private Align(String name) {
            this.name = name;
        }

        public float resolve(float min, float size) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case START -> min;
                case CENTER -> min - size / 2.0f;
                case END -> min - size;
            };
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Align::values);
        }
    }
}

