/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras")
public class ItemExtensions {
    private static final String TAG_UNDROPPABLE = "undroppable";
    private static final String TAG_COOLDOWN_OVERRIDE = "cooldown_override";
    private static final int NO_COOLDOWN_OVERRIDE = 0;

    public static boolean onItemToss(Player player, ItemEntity item) {
        ItemStack stack = item.m_32055_();
        if (ItemExtensions.isUndroppable(stack)) {
            player.m_36356_(stack);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().m_32055_();
        if (ItemExtensions.isUndroppable(stack)) {
            stack.m_41764_(0);
            event.getItem().m_146870_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        event.getDrops().removeIf(item -> ItemExtensions.isUndroppable(item.m_32055_()));
    }

    public static void onItemUsedOn(ServerPlayer player, ItemStack stack, UseOnContext context) {
        ItemExtensions.applyCooldownOverride(player, stack);
    }

    public static void onItemUsed(ServerPlayer player, ItemStack stack) {
        ItemExtensions.applyCooldownOverride(player, stack);
    }

    private static void applyCooldownOverride(ServerPlayer player, ItemStack stack) {
        if (player.m_6117_()) {
            return;
        }
        int cooldown = ItemExtensions.getCooldown(stack);
        if (cooldown != 0) {
            player.m_36335_().m_41524_(stack.m_41720_(), cooldown);
        }
    }

    @SubscribeEvent
    public static void onItemFinishedUsing(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            int cooldown = ItemExtensions.getCooldown(event.getItem());
            if (cooldown != 0) {
                player.m_36335_().m_41524_(event.getItem().m_41720_(), cooldown);
            }
        }
    }

    private static boolean isUndroppable(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_(TAG_UNDROPPABLE);
    }

    private static int getCooldown(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128451_(TAG_COOLDOWN_OVERRIDE);
        }
        return 0;
    }
}

