/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.client.perf;

import com.lovetropics.extras.perf.LossyLightCache;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/client/renderer/block/ModelBlockRenderer$Cache"})
public class BlockModelRendererCacheMixin {
    @Shadow
    private boolean f_111214_;
    @Unique
    private final LossyLightCache.Packed fastPackedLightCache = new LossyLightCache.Packed(128);
    @Unique
    private final LossyLightCache.Brightness fastBrightnessCache = new LossyLightCache.Brightness(128);

    @Inject(method={"disable()V"}, at={@At(value="RETURN")})
    private void disable(CallbackInfo ci) {
        this.fastPackedLightCache.clear();
        this.fastBrightnessCache.clear();
    }

    @Overwrite
    public int m_111221_(BlockState state, BlockAndTintGetter world, BlockPos pos) {
        if (!this.f_111214_) {
            return LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)pos);
        }
        LossyLightCache.Packed cache = this.fastPackedLightCache;
        long posKey = pos.m_121878_();
        int light = cache.get(posKey);
        if (light != Integer.MAX_VALUE) {
            return light;
        }
        light = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)pos);
        cache.put(posKey, light);
        return light;
    }

    @Overwrite
    public float m_111226_(BlockState state, BlockAndTintGetter world, BlockPos pos) {
        if (!this.f_111214_) {
            return state.m_60792_((BlockGetter)world, pos);
        }
        LossyLightCache.Brightness cache = this.fastBrightnessCache;
        long posKey = pos.m_121878_();
        float brightness = cache.get(posKey);
        if (!Float.isNaN(brightness)) {
            return brightness;
        }
        brightness = state.m_60792_((BlockGetter)world, pos);
        cache.put(posKey, brightness);
        return brightness;
    }
}

