/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.fix;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.settings.KeyMappingLookup;
import net.minecraftforge.client.settings.KeyModifier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={KeyMappingLookup.class}, remap=false)
public class KeyMappingLookupMixin {
    @Shadow(remap=false)
    @Final
    private static EnumMap<KeyModifier, Map<InputConstants.Key, Collection<KeyMapping>>> map;

    @Overwrite(remap=false)
    public List<KeyMapping> getAll(InputConstants.Key keyCode) {
        ArrayList<KeyMapping> matchingBindings = new ArrayList<KeyMapping>();
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (activeModifier == KeyModifier.NONE || activeModifier.matches(keyCode) || !matchingBindings.addAll(this.findKeybinds(keyCode, activeModifier))) {
            matchingBindings.addAll(this.findKeybinds(keyCode, KeyModifier.NONE));
        }
        return matchingBindings;
    }

    private List<KeyMapping> findKeybinds(InputConstants.Key keyCode, KeyModifier modifier) {
        Collection<KeyMapping> modifierBindings = map.get(modifier).get(keyCode);
        if (modifierBindings != null) {
            return modifierBindings.stream().filter(binding -> binding.isActiveAndMatches(keyCode)).toList();
        }
        return List.of();
    }
}

