/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.translation;

import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.translation.TranslatableChatMessage;
import com.lovetropics.extras.translation.TranslationBundle;
import com.lovetropics.extras.translation.TranslationOptions;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.FutureChain;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin {
    @Unique
    private static final Component TRANSLATED_MARKER = Component.m_237113_((String)" \ue041").m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)ExtraLangKeys.MESSAGE_TRANSLATED.get())));
    @Shadow
    @Final
    private MinecraftServer f_9745_;
    @Shadow
    public ServerPlayer f_9743_;
    @Shadow
    @Final
    private FutureChain f_241681_;

    @Shadow
    private static boolean m_215214_(String pMessage) {
        return false;
    }

    @Shadow
    public abstract void m_9942_(Component var1);

    @Shadow
    protected abstract Optional<LastSeenMessages> m_247189_(String var1, Instant var2, LastSeenMessages.Update var3);

    @Shadow
    protected abstract PlayerChatMessage m_247340_(ServerboundChatPacket var1, LastSeenMessages var2) throws SignedMessageChain.DecodeException;

    @Shadow
    protected abstract CompletableFuture<FilteredText> m_243132_(String var1);

    @Shadow
    protected abstract void m_246889_(SignedMessageChain.DecodeException var1);

    @Shadow
    protected abstract void m_243086_(PlayerChatMessage var1);

    @Overwrite
    public void m_7388_(ServerboundChatPacket packet) {
        if (ServerGamePacketListenerImplMixin.m_215214_(packet.f_133827_())) {
            this.m_9942_((Component)Component.m_237115_((String)"multiplayer.disconnect.illegal_characters"));
            return;
        }
        Optional<LastSeenMessages> lastSeen = this.m_247189_(packet.f_133827_(), packet.f_237950_(), packet.f_241662_());
        if (lastSeen.isPresent()) {
            this.f_9745_.m_18707_(() -> {
                PlayerChatMessage message;
                try {
                    message = this.m_247340_(packet, (LastSeenMessages)lastSeen.get());
                }
                catch (SignedMessageChain.DecodeException e) {
                    this.m_246889_(e);
                    return;
                }
                CompletableFuture<FilteredText> filteredText = this.m_243132_(message.m_245728_());
                CompletableFuture decoratedText = ForgeHooks.getServerChatSubmittedDecorator().m_236961_(this.f_9743_, message.m_245692_());
                CompletableFuture<TranslationBundle> translations = TranslationOptions.translate(this.f_9743_, message);
                this.f_241681_.m_241849_(executor -> CompletableFuture.allOf(filteredText, decoratedText, translations).thenAcceptAsync(unused -> {
                    Component decoratedContent = (Component)decoratedText.join();
                    if (decoratedContent == null) {
                        return;
                    }
                    PlayerChatMessage decoratedMessage = message.m_241956_(decoratedContent).m_243072_(((FilteredText)filteredText.join()).f_243010_());
                    ((TranslatableChatMessage)decoratedMessage).ltextras$addTranslations((TranslationBundle)translations.join());
                    this.m_243086_(decoratedMessage);
                }, executor));
            });
        }
    }

    @ModifyVariable(method={"sendPlayerChatMessage"}, at=@At(value="HEAD"), argsOnly=true)
    private ChatType.Bound modifyChatMessageType(ChatType.Bound chatType, PlayerChatMessage message) {
        if (!TranslationOptions.shouldTranslateIncoming(this.f_9743_)) {
            return chatType;
        }
        if (((TranslatableChatMessage)message).ltextras$hasTranslationFor(this.f_9743_.getLanguage())) {
            return new ChatType.Bound(chatType.f_240859_(), (Component)chatType.f_240886_().m_6881_().m_7220_(TRANSLATED_MARKER), chatType.f_240896_());
        }
        return chatType;
    }

    @ModifyVariable(method={"sendPlayerChatMessage"}, at=@At(value="HEAD"), argsOnly=true)
    private PlayerChatMessage modifyChatMessage(PlayerChatMessage message) {
        if (!TranslationOptions.shouldTranslateIncoming(this.f_9743_)) {
            return message;
        }
        return ((TranslatableChatMessage)message).ltextras$translate(this.f_9743_.getLanguage());
    }
}

