/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.network;

import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleStore;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record PickCollectibleItemPacket(Collectible collectible) {
    private static final int NOT_FOUND = -1;

    public PickCollectibleItemPacket(FriendlyByteBuf input) {
        this(new Collectible(input));
    }

    public void write(FriendlyByteBuf output) {
        this.collectible.write(output);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player == null || player.f_36096_ != player.f_36095_) {
            return;
        }
        CollectibleStore collectibles = CollectibleStore.getNullable((Player)player);
        if (collectibles == null || collectibles.isLocked() || !collectibles.contains(this.collectible)) {
            player.f_36095_.m_38946_();
            return;
        }
        Inventory inventory = player.m_150109_();
        int index = PickCollectibleItemPacket.findCollectibleInInventory(inventory, this.collectible);
        if (index == -1) {
            player.f_36095_.m_142503_(this.collectible.createItemStack(player.m_20148_()));
        } else {
            player.f_36095_.m_142503_(inventory.m_8016_(index));
        }
    }

    private static int findCollectibleInInventory(Inventory inventory, Collectible collectible) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!collectible.matches(inventory.m_8020_(i))) continue;
            return i;
        }
        return -1;
    }
}

