/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.network;

import com.lovetropics.extras.client.world_effect.SkyColorEffectHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record SetSkyColorPacket(int color, int fadeLength) {
    private static final int CLEAR = Integer.MIN_VALUE;

    public SetSkyColorPacket(FriendlyByteBuf input) {
        this(input.readInt(), input.m_130242_());
    }

    public static SetSkyColorPacket clear(int fadeLength) {
        return new SetSkyColorPacket(Integer.MIN_VALUE, fadeLength);
    }

    public void write(FriendlyByteBuf output) {
        output.writeInt(this.color);
        output.m_130130_(this.fadeLength);
    }

    public static void handle(SetSkyColorPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (packet.color == Integer.MIN_VALUE) {
            SkyColorEffectHandler.clear(packet.fadeLength);
        } else {
            SkyColorEffectHandler.apply(packet.color, packet.fadeLength);
        }
    }
}

