/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.network;

import com.lovetropics.extras.schedule.PlayerTimeZone;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record SetTimeZonePacket(ZoneId id) {
    private static final int MAX_LENGTH = 64;

    public static SetTimeZonePacket read(FriendlyByteBuf input) {
        try {
            return new SetTimeZonePacket(ZoneId.of(input.m_130136_(64)));
        }
        catch (DateTimeException e) {
            return new SetTimeZonePacket(ZoneOffset.UTC);
        }
    }

    public void write(FriendlyByteBuf output) {
        output.m_130070_(this.id.getId());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            PlayerTimeZone.set(player, this.id);
        }
    }
}

