/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.schedule;

import com.lovetropics.extras.LTExtras;
import java.time.ZoneId;
import java.time.ZoneOffset;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras")
public class PlayerTimeZone
implements ICapabilityProvider {
    public static final ResourceLocation ID = new ResourceLocation("ltextras", "time_zone");
    private final LazyOptional<PlayerTimeZone> instance = LazyOptional.of(() -> this);
    private ZoneId zoneId = ZoneOffset.UTC;

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayer) {
            event.addCapability(ID, (ICapabilityProvider)new PlayerTimeZone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.reviveCaps();
        try {
            PlayerTimeZone oldTimeZone = PlayerTimeZone.getOrNull(oldPlayer);
            PlayerTimeZone newTimeZone = PlayerTimeZone.getOrNull(event.getEntity());
            if (oldTimeZone != null && newTimeZone != null) {
                newTimeZone.zoneId = oldTimeZone.zoneId;
            }
        }
        finally {
            oldPlayer.invalidateCaps();
        }
    }

    public static void set(ServerPlayer player, ZoneId zone) {
        PlayerTimeZone capability = PlayerTimeZone.getOrNull((Player)player);
        if (capability != null) {
            capability.zoneId = zone;
        }
    }

    public static ZoneId get(ServerPlayer player) {
        PlayerTimeZone capability = PlayerTimeZone.getOrNull((Player)player);
        return capability != null ? capability.zoneId : ZoneOffset.UTC;
    }

    @Nullable
    private static PlayerTimeZone getOrNull(Player player) {
        return (PlayerTimeZone)player.getCapability(LTExtras.PLAYER_TIME_ZONE).orElse(null);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return LTExtras.PLAYER_TIME_ZONE.orEmpty(cap, this.instance);
    }
}

