/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.schedule;

import com.lovetropics.extras.schedule.PlayerTimeZone;
import com.lovetropics.extras.schedule.StreamSchedule;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras")
public class SchedulePlaceholders {
    private static final PlaceholderResult UNKNOWN = PlaceholderResult.value((String)"?");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE HH:mm");
    private static final Duration FETCH_INTERVAL = Duration.ofMinutes(5L);
    private static CompletableFuture<?> fetchFuture = CompletableFuture.completedFuture(null);
    @Nullable
    private static StreamSchedule schedule;
    private static Instant lastFetchTime;

    private static void registerForEntry(boolean next) {
        String prefix = next ? "next" : "current";
        SchedulePlaceholders.registerPlaceholder(prefix + "/short_description", next, (ctx, entry) -> PlaceholderResult.value((String)entry.shortDescription()));
        SchedulePlaceholders.registerPlaceholder(prefix + "/long_description", next, (ctx, entry) -> PlaceholderResult.value((String)entry.longDescription()));
        SchedulePlaceholders.registerPlaceholder(prefix + "/hosts", next, (ctx, entry) -> SchedulePlaceholders.formatHosts(entry));
        SchedulePlaceholders.registerPlaceholder(prefix + "/start", next, (ctx, entry) -> SchedulePlaceholders.formatLocalTime(ctx, entry.startTime()));
        SchedulePlaceholders.registerPlaceholder(prefix + "/end", next, (ctx, entry) -> SchedulePlaceholders.formatLocalTime(ctx, entry.endTime()));
        SchedulePlaceholders.registerPlaceholder(prefix + "/time_until", next, (ctx, entry) -> SchedulePlaceholders.formatTimeUntil(entry));
    }

    private static void registerPlaceholder(String id, boolean next, PlaceholderFunction function) {
        Placeholders.register((ResourceLocation)new ResourceLocation("ltextras", "schedule/" + id), (ctx, arg) -> {
            StreamSchedule.Entry entry;
            StreamSchedule schedule = schedule;
            if (schedule == null) {
                return UNKNOWN;
            }
            Instant time = Instant.now();
            StreamSchedule.Entry entry2 = entry = next ? schedule.nextAfter(time) : schedule.currentAt(time);
            if (entry != null) {
                return function.get(ctx, entry);
            }
            return UNKNOWN;
        });
    }

    private static PlaceholderResult formatHosts(StreamSchedule.Entry entry) {
        return PlaceholderResult.value((String)entry.hosts().stream().map(StreamSchedule.Host::name).collect(Collectors.joining(" + ")));
    }

    private static PlaceholderResult formatTimeUntil(StreamSchedule.Entry entry) {
        Duration duration = Duration.between(Instant.now(), entry.startTime());
        if (duration.isNegative()) {
            duration = Duration.ZERO;
        }
        return PlaceholderResult.value((String)(duration.toMinutes() + " minutes"));
    }

    private static PlaceholderResult formatLocalTime(PlaceholderContext ctx, Instant time) {
        LocalDateTime localTime = time.atZone(SchedulePlaceholders.getTimeZone(ctx)).toLocalDateTime();
        return PlaceholderResult.value((String)TIME_FORMATTER.format(localTime));
    }

    private static ZoneId getTimeZone(PlaceholderContext ctx) {
        ServerPlayer player = ctx.player();
        return player != null ? PlayerTimeZone.get(player) : ZoneOffset.UTC;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (!fetchFuture.isDone()) {
            return;
        }
        Instant time = Instant.now();
        if (Duration.between(lastFetchTime, time).compareTo(FETCH_INTERVAL) > 0) {
            fetchFuture = StreamSchedule.fetch().thenAccept(opt -> opt.ifPresent(s -> {
                schedule = s;
            }));
            lastFetchTime = time;
        }
    }

    static {
        lastFetchTime = Instant.EPOCH;
        SchedulePlaceholders.registerForEntry(false);
        SchedulePlaceholders.registerForEntry(true);
    }

    private static interface PlaceholderFunction {
        public PlaceholderResult get(PlaceholderContext var1, StreamSchedule.Entry var2);
    }
}

