/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.translation;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.translation.TranslationBundle;
import com.lovetropics.extras.translation.TranslationService;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras")
public class TranslationOptions
implements ICapabilityProvider {
    public static final ResourceLocation ID = new ResourceLocation("ltextras", "translation");
    private final LazyOptional<TranslationOptions> instance = LazyOptional.of(() -> this);
    private boolean translateIncoming = true;
    private boolean translateOutgoing = true;

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayer) {
            event.addCapability(ID, (ICapabilityProvider)new TranslationOptions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.reviveCaps();
        try {
            TranslationOptions oldOptions = TranslationOptions.getOrNull(oldPlayer);
            TranslationOptions newOptions = TranslationOptions.getOrNull(event.getEntity());
            if (oldOptions != null && newOptions != null) {
                newOptions.translateIncoming = oldOptions.translateIncoming;
                newOptions.translateOutgoing = oldOptions.translateOutgoing;
            }
        }
        finally {
            oldPlayer.invalidateCaps();
        }
    }

    public static void set(ServerPlayer player, boolean translateIncoming, boolean translateOutgoing) {
        TranslationOptions capability = TranslationOptions.getOrNull((Player)player);
        if (capability != null) {
            capability.translateIncoming = translateIncoming;
            capability.translateOutgoing = translateOutgoing;
        }
    }

    public static CompletableFuture<TranslationBundle> translate(@Nullable ServerPlayer player, PlayerChatMessage message) {
        if (player != null && TranslationOptions.shouldTranslateOutgoing(player)) {
            return TranslationService.INSTANCE.translate(player.getLanguage(), message.m_245728_());
        }
        return CompletableFuture.completedFuture(TranslationBundle.EMPTY);
    }

    public static boolean shouldTranslateIncoming(ServerPlayer player) {
        TranslationOptions capability = TranslationOptions.getOrNull((Player)player);
        return capability == null || capability.translateIncoming;
    }

    public static boolean shouldTranslateOutgoing(ServerPlayer player) {
        TranslationOptions capability = TranslationOptions.getOrNull((Player)player);
        return capability == null || capability.translateIncoming;
    }

    @Nullable
    private static TranslationOptions getOrNull(Player player) {
        return (TranslationOptions)player.getCapability(LTExtras.TRANSLATION).orElse(null);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return LTExtras.TRANSLATION.orEmpty(cap, this.instance);
    }
}

