/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.translation;

import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.ExtrasConfig;
import com.lovetropics.extras.translation.TranslatableLanguage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.TextAndImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TranslationPromptScreen
extends Screen {
    private static final Component TITLE = ExtraLangKeys.TRANSLATION_PROMPT_TITLE.get();
    private static final Component MESSAGE = ExtraLangKeys.TRANSLATION_PROMPT.get();
    private static final int MAX_WIDTH = 300;
    private static final int BUTTON_WIDTH = 200;
    private final Runnable callback;
    private final GridLayout layout = new GridLayout().m_267612_(8);
    private final MultiLineTextWidget warning;
    private final CycleButton<Boolean> translateIncoming;
    private final CycleButton<Boolean> translateOutgoing;

    public TranslationPromptScreen(Runnable callback, Minecraft minecraft, Font font) {
        super(TITLE);
        this.callback = callback;
        this.layout.m_264211_().m_264356_();
        GridLayout.RowHelper helper = this.layout.m_264606_(1);
        helper.m_264206_((LayoutElement)new StringWidget(TITLE, font).m_267729_(), this.layout.m_264626_().m_264184_(10));
        helper.m_264139_((LayoutElement)new MultiLineTextWidget(MESSAGE, font).m_269484_(true).m_269098_(300));
        TextAndImageButton languageButton = TextAndImageButton.m_267772_((Component)Component.m_237115_((String)"options.language"), (ResourceLocation)Button.f_93617_, button -> minecraft.m_91152_((Screen)new LanguageSelectScreen((Screen)this, minecraft.f_91066_, minecraft.m_91102_()))).m_267752_(3, 109).m_267570_(90, 3).m_267809_(20).m_267765_(14, 14).m_267643_(256, 256).m_267775_();
        languageButton.m_93674_(200);
        helper.m_264139_((LayoutElement)languageButton);
        this.warning = (MultiLineTextWidget)helper.m_264139_((LayoutElement)new MultiLineTextWidget((Component)ExtraLangKeys.TRANSLATION_PROMPT_UNRECOGNIZED.get().m_130940_(ChatFormatting.GOLD), font).m_269098_(300).m_269484_(true));
        this.translateIncoming = (CycleButton)helper.m_264139_((LayoutElement)CycleButton.m_168896_((Component)CommonComponents.f_130657_, (Component)CommonComponents.f_130658_).m_168948_((Object)((Boolean)ExtrasConfig.TRANSLATION.translateIncoming.get())).m_168930_(0, 0, 200, 20, (Component)ExtraLangKeys.TRANSLATION_PROMPT_INCOMING.get()));
        this.translateOutgoing = (CycleButton)helper.m_264139_((LayoutElement)CycleButton.m_168896_((Component)CommonComponents.f_130657_, (Component)CommonComponents.f_130658_).m_168948_((Object)((Boolean)ExtrasConfig.TRANSLATION.translateOutgoing.get())).m_168930_(0, 0, 200, 20, (Component)ExtraLangKeys.TRANSLATION_PROMPT_OUTGOING.get()));
        helper.m_264206_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, b -> this.m_7379_()).m_253136_(), this.layout.m_264626_().m_264184_(10));
    }

    protected void m_7856_() {
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_267719_();
    }

    protected void m_267719_() {
        this.updateWidgetStates();
        this.layout.m_264036_();
        FrameLayout.m_267781_((LayoutElement)this.layout, (ScreenRectangle)this.m_264198_());
    }

    private void updateWidgetStates() {
        String selectedLanguage = this.f_96541_.m_91102_().m_264236_();
        boolean translatable = TranslatableLanguage.byKey(selectedLanguage) != null;
        this.warning.f_93624_ = !translatable;
        this.translateIncoming.f_93623_ = translatable;
        this.translateOutgoing.f_93623_ = translatable;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public Component m_142562_() {
        return CommonComponents.m_267603_((Component[])new Component[]{TITLE, MESSAGE});
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_7379_() {
        ExtrasConfig.CategoryTranslation config = ExtrasConfig.TRANSLATION;
        config.translateIncoming.set((Object)((Boolean)this.translateIncoming.m_168883_()));
        config.translateOutgoing.set((Object)((Boolean)this.translateOutgoing.m_168883_()));
        ExtrasConfig.CLIENT_CONFIG.save();
        this.callback.run();
    }
}

