/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.translation;

import com.lovetropics.extras.ExtrasConfig;
import com.lovetropics.extras.translation.TranslatableLanguage;
import com.lovetropics.extras.translation.TranslationBundle;
import com.lovetropics.extras.translation.TranslationMode;
import com.mojang.logging.LogUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import net.minecraft.Util;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;

public class TranslationService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Duration TIMEOUT = Duration.ofSeconds(2L);
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().executor(Util.m_183992_()).connectTimeout(TIMEOUT).build();
    public static final TranslationService INSTANCE = new TranslationService((Supplier<String>)ExtrasConfig.TECH_STACK.translationUrl);
    private final Supplier<String> url;

    private TranslationService(Supplier<String> url) {
        this.url = url;
    }

    private boolean isDisabled() {
        return Strings.isBlank((String)this.url.get());
    }

    public CompletableFuture<TranslationBundle> translate(String language, String text) {
        TranslatableLanguage languageType = TranslatableLanguage.byKey(language);
        if (languageType == null || this.isDisabled()) {
            return CompletableFuture.completedFuture(TranslationBundle.EMPTY);
        }
        CompletionStage future = switch (languageType) {
            default -> throw new IncompatibleClassChangeError();
            case TranslatableLanguage.ENGLISH -> this.translateTo(text, TranslationMode.EN_ES).thenCombine(this.translateTo(text, TranslationMode.EN_FR), (spanish, french) -> TranslationService.createBundle(text, spanish, french));
            case TranslatableLanguage.FRENCH -> this.translateTo(text, TranslationMode.FR_EN).thenCompose(english -> this.translateTo((String)english, TranslationMode.EN_ES).thenApply(spanish -> TranslationService.createBundle(english, spanish, text)));
            case TranslatableLanguage.SPANISH -> this.translateTo(text, TranslationMode.ES_EN).thenCompose(english -> this.translateTo((String)english, TranslationMode.EN_FR).thenApply(french -> TranslationService.createBundle(english, text, french)));
        };
        return ((CompletableFuture)future).handle((result, throwable) -> {
            if (throwable != null) {
                LOGGER.warn("Failed to translate text: {}", (Object)text, throwable);
            }
            return Objects.requireNonNullElse(result, TranslationBundle.EMPTY);
        });
    }

    private static TranslationBundle createBundle(String english, String spanish, String french) {
        return new TranslationBundle(Map.of(TranslatableLanguage.ENGLISH, english, TranslatableLanguage.SPANISH, spanish, TranslatableLanguage.FRENCH, french));
    }

    private CompletableFuture<String> translateTo(String text, TranslationMode mode) {
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.url.get() + "/" + mode.m_7912_())).POST(HttpRequest.BodyPublishers.ofString(text)).timeout(TIMEOUT).build();
        return HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                return (String)response.body();
            }
            throw new RuntimeException("Received unexpected response " + response.statusCode() + " from translation of '" + text + "' (" + mode + "): " + (String)response.body());
        });
    }
}

