/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.extras.network.WorldParticleEffectsPacket;
import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public record ParticlesEffect(List<Particle> particles) implements WorldEffect
{
    public static final MapCodec<ParticlesEffect> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Particle.CODEC.listOf().fieldOf("particles").forGetter(ParticlesEffect::particles)).apply((Applicative)i, ParticlesEffect::new));

    public ParticlesEffect(FriendlyByteBuf input) {
        this(input.m_236845_(Particle::new));
    }

    public void write(FriendlyByteBuf output) {
        output.m_236828_(this.particles, (out, particle) -> particle.write((FriendlyByteBuf)out));
    }

    @Override
    public void apply(ServerPlayer player, boolean immediate) {
        LTExtrasNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new WorldParticleEffectsPacket(this));
    }

    @Override
    public void clear(ServerPlayer player, boolean immediate) {
        LTExtrasNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new WorldParticleEffectsPacket((ParticlesEffect)null));
    }

    @Override
    public WorldEffectType type() {
        return WorldEffectType.PARTICLES;
    }

    public record Particle(ParticleOptions particle, int count, int range, Vec3i offset) {
        public static final Codec<Particle> CODEC = RecordCodecBuilder.create(i -> i.group((App)ParticleTypes.f_123791_.fieldOf("options").forGetter(Particle::particle), (App)Codec.INT.fieldOf("count").forGetter(Particle::count), (App)Codec.INT.fieldOf("range").forGetter(Particle::range), (App)Vec3i.f_123287_.optionalFieldOf("offset", (Object)BlockPos.f_121853_).forGetter(Particle::offset)).apply((Applicative)i, Particle::new));

        public Particle(FriendlyByteBuf input) {
            this((ParticleOptions)Particle.readParticle(input, (ParticleType)input.m_236816_((IdMap)BuiltInRegistries.f_257034_)), input.m_130242_(), input.m_130242_(), (Vec3i)input.m_130135_());
        }

        public void write(FriendlyByteBuf output) {
            output.m_236818_((IdMap)BuiltInRegistries.f_257034_, (Object)this.particle.m_6012_());
            this.particle.m_7711_(output);
            output.m_130130_(this.count);
            output.m_130130_(this.range);
            output.m_130064_(new BlockPos(this.offset));
        }

        private static <T extends ParticleOptions> T readParticle(FriendlyByteBuf input, ParticleType<T> type) {
            return (T)type.m_123743_().m_6507_(type, input);
        }
    }
}

