/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.extras.network.SetSkyColorPacket;
import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastColor;
import net.minecraftforge.network.PacketDistributor;

public record SkyColorEffect(int red, int green, int blue, int fadeLength) implements WorldEffect
{
    private static final Codec<Integer> COLOR_COMPONENT_CODEC = ExtraCodecs.m_269197_((int)0, (int)255);
    public static final MapCodec<SkyColorEffect> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)COLOR_COMPONENT_CODEC.fieldOf("red").forGetter(SkyColorEffect::red), (App)COLOR_COMPONENT_CODEC.fieldOf("green").forGetter(SkyColorEffect::green), (App)COLOR_COMPONENT_CODEC.fieldOf("blue").forGetter(SkyColorEffect::blue), (App)ExtraCodecs.f_144628_.optionalFieldOf("fade_length", (Object)20).forGetter(SkyColorEffect::fadeLength)).apply((Applicative)i, SkyColorEffect::new));

    @Override
    public void apply(ServerPlayer player, boolean immediate) {
        int color = FastColor.ARGB32.m_13660_((int)0, (int)this.red, (int)this.green, (int)this.blue);
        LTExtrasNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetSkyColorPacket(color, immediate ? 0 : this.fadeLength));
    }

    @Override
    public void clear(ServerPlayer player, boolean immediate) {
        LTExtrasNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)SetSkyColorPacket.clear(this.fadeLength));
    }

    @Override
    public WorldEffectType type() {
        return WorldEffectType.SKY_COLOR;
    }
}

