/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.world_effect.WorldEffectConfigs;
import com.lovetropics.extras.world_effect.WorldEffectHolder;
import com.lovetropics.extras.world_effect.WorldEffectManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public class WorldEffectCommand {
    private static final DynamicCommandExceptionType WORLD_EFFECT_CONFIG_NOT_FOUND = new DynamicCommandExceptionType(id -> Component.m_237113_((String)("World effect does not exist with id: " + id)));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"worldeffect").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"apply").then(((RequiredArgumentBuilder)WorldEffectCommand.effectArgument("effect").executes(context -> WorldEffectCommand.apply((CommandContext<CommandSourceStack>)context, WorldEffectCommand.getEffect((CommandContext<CommandSourceStack>)context, "effect"), Long.MAX_VALUE))).then(Commands.m_82129_((String)"duration", (ArgumentType)TimeArgument.m_113037_()).executes(context -> WorldEffectCommand.apply((CommandContext<CommandSourceStack>)context, WorldEffectCommand.getEffect((CommandContext<CommandSourceStack>)context, "effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"))))))).then(Commands.m_82127_((String)"clear").then(WorldEffectCommand.effectArgument("effect").executes(context -> WorldEffectCommand.clear((CommandContext<CommandSourceStack>)context, WorldEffectCommand.getEffect((CommandContext<CommandSourceStack>)context, "effect"))))));
    }

    private static int apply(CommandContext<CommandSourceStack> context, WorldEffectHolder effect, long duration) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        long expiresAt = duration == Long.MAX_VALUE ? Long.MAX_VALUE : server.m_129783_().m_46467_() + duration;
        WorldEffectManager.apply(((CommandSourceStack)context.getSource()).m_81372_(), effect, expiresAt);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Applied world effect: " + effect.id())), false);
        return 1;
    }

    private static int clear(CommandContext<CommandSourceStack> context, WorldEffectHolder effect) {
        WorldEffectManager.clear(((CommandSourceStack)context.getSource()).m_81372_(), effect.id());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Cleared world effect: " + effect.id())), false);
        return 1;
    }

    public static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> effectArgument(String name) {
        return Commands.m_82129_((String)name, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> SharedSuggestionProvider.m_82957_(WorldEffectConfigs.REGISTRY.stream().map(WorldEffectHolder::id), (SuggestionsBuilder)builder));
    }

    private static WorldEffectHolder getEffect(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.m_107011_(context, (String)name);
        WorldEffectHolder config = (WorldEffectHolder)WorldEffectConfigs.REGISTRY.get((Object)id);
        if (config == null) {
            throw WORLD_EFFECT_CONFIG_NOT_FOUND.create((Object)id);
        }
        return config;
    }
}

