/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectHolder;
import com.lovetropics.extras.world_effect.WorldEffectManager;
import com.lovetropics.lib.codec.CodecRegistry;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="ltextras")
public class WorldEffectConfigs {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CodecRegistry<ResourceLocation, WorldEffectHolder> REGISTRY = CodecRegistry.resourceLocationKeys();
    private static final FileToIdConverter LISTER = FileToIdConverter.m_246568_((String)"world_effects");

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> WorldEffectConfigs.listEffects(resourceManager, backgroundExecutor), backgroundExecutor).thenCompose(f -> f)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(effects -> {
            REGISTRY.clear();
            effects.forEach((id, effect) -> REGISTRY.register(id, (Object)new WorldEffectHolder((ResourceLocation)id, (WorldEffect)effect)));
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                WorldEffectManager.reload(server);
            }
        }, gameExecutor));
    }

    private static CompletableFuture<Map<ResourceLocation, WorldEffect>> listEffects(ResourceManager resourceManager, Executor executor) {
        List<CompletableFuture> futures = LISTER.m_247457_(resourceManager).entrySet().stream().map(entry -> {
            ResourceLocation path = (ResourceLocation)entry.getKey();
            ResourceLocation id = LISTER.m_245273_(path);
            Resource resource = (Resource)entry.getValue();
            return CompletableFuture.supplyAsync(() -> Pair.of((Object)id, (Object)WorldEffectConfigs.loadEffect((DynamicOps<JsonElement>)JsonOps.INSTANCE, path, resource)), executor);
        }).toList();
        return Util.m_137567_(futures).thenApply(configs -> configs.stream().filter(pair -> pair.getSecond() != null).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
    }

    @Nullable
    private static WorldEffect loadEffect(DynamicOps<JsonElement> ops, ResourceLocation path, Resource resource) {
        try {
            DataResult result;
            try (BufferedReader reader = resource.m_215508_();){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                result = WorldEffect.CODEC.parse(ops, (Object)json);
            }
            if (result.error().isPresent()) {
                LOGGER.error("Failed to load world effect at {}: {}", (Object)path, result.error().get());
            }
            return result.result().orElse(null);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load world effect at {}", (Object)path, (Object)e);
            return null;
        }
    }
}

