/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectConfigs;
import com.lovetropics.extras.world_effect.WorldEffectHolder;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras")
public class WorldEffectManager {
    private static final Map<ResourceKey<Level>, Map<ResourceLocation, Entry>> EFFECTS_BY_DIMENSION = new Reference2ObjectOpenHashMap();

    public static void apply(ServerLevel level, WorldEffectHolder effect, long expiresAt) {
        Map effects = EFFECTS_BY_DIMENSION.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new Object2ObjectOpenHashMap());
        Entry entry = new Entry(effect.value(), expiresAt);
        if (effects.put(effect.id(), entry) == null) {
            WorldEffectManager.apply(level, effect.value(), false);
        }
    }

    public static void clear(ServerLevel level, ResourceLocation effectId) {
        Map<ResourceLocation, Entry> effects = EFFECTS_BY_DIMENSION.get(level.m_46472_());
        if (effects == null) {
            return;
        }
        Entry entry = effects.remove(effectId);
        if (entry != null) {
            WorldEffectManager.clear(level, entry.effect(), false);
        }
    }

    private static void apply(ServerLevel level, WorldEffect effect, boolean immediate) {
        for (ServerPlayer player : level.m_6907_()) {
            effect.apply(player, immediate);
        }
    }

    private static void clear(ServerLevel level, WorldEffect effect, boolean immediate) {
        for (ServerPlayer player : level.m_6907_()) {
            effect.clear(player, immediate);
        }
    }

    public static void reload(MinecraftServer server) {
        EFFECTS_BY_DIMENSION.forEach((dimension, effects) -> {
            ServerLevel level = server.m_129880_(dimension);
            if (level != null) {
                Map<ResourceLocation, Entry> newEffects = WorldEffectManager.reloadInDimension(effects, level);
                effects.clear();
                effects.putAll(newEffects);
            }
        });
    }

    private static Map<ResourceLocation, Entry> reloadInDimension(Map<ResourceLocation, Entry> effects, ServerLevel level) {
        for (Entry entry2 : effects.values()) {
            WorldEffectManager.clear(level, entry2.effect(), true);
        }
        Map<ResourceLocation, Entry> newEffects = effects.entrySet().stream().map(entry -> {
            WorldEffectHolder newEffect = (WorldEffectHolder)WorldEffectConfigs.REGISTRY.get((Object)((ResourceLocation)entry.getKey()));
            if (newEffect != null) {
                return Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)((Entry)entry.getValue()).rebind(newEffect.value()));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        for (Entry entry3 : newEffects.values()) {
            WorldEffectManager.apply(level, entry3.effect(), true);
        }
        return newEffects;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        MinecraftServer server = event.getServer();
        long gameTime = server.m_129783_().m_46467_();
        EFFECTS_BY_DIMENSION.entrySet().removeIf(entry -> {
            ServerLevel level = server.m_129880_((ResourceKey)entry.getKey());
            return level == null || WorldEffectManager.tickDimension(((Map)entry.getValue()).values(), gameTime, level);
        });
    }

    private static boolean tickDimension(Collection<Entry> entries, long gameTime, ServerLevel level) {
        entries.removeIf(e -> {
            if (gameTime > e.expiresAt()) {
                WorldEffectManager.clear(level, e.effect(), false);
                return true;
            }
            return false;
        });
        return entries.isEmpty();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldEffectManager.forEachEffect(player2, player2.m_284548_(), (e, p) -> e.apply((ServerPlayer)p, true));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerLevel toLevel;
            ServerPlayer player2 = (ServerPlayer)player;
            MinecraftServer server = player2.f_8924_;
            ServerLevel fromLevel = server.m_129880_(event.getFrom());
            if (fromLevel != null) {
                WorldEffectManager.forEachEffect(player2, fromLevel, (e, p) -> e.clear((ServerPlayer)p, true));
            }
            if ((toLevel = server.m_129880_(event.getTo())) != null) {
                WorldEffectManager.forEachEffect(player2, toLevel, (e, p) -> e.apply((ServerPlayer)p, true));
            }
        }
    }

    private static void forEachEffect(ServerPlayer player, ServerLevel level, BiConsumer<WorldEffect, ServerPlayer> consumer) {
        Map<ResourceLocation, Entry> effects = EFFECTS_BY_DIMENSION.get(level.m_46472_());
        if (effects != null && !effects.isEmpty()) {
            for (Entry entry : effects.values()) {
                consumer.accept(entry.effect(), player);
            }
        }
    }

    private record Entry(WorldEffect effect, long expiresAt) {
        public Entry rebind(WorldEffect effect) {
            return new Entry(effect, this.expiresAt);
        }
    }
}

