/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.lovetropics.gamemodebuild.ItemFilter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="gamemodebuild", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GBConfigs {
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        SERVER.loadLists();
        SERVER.resetFilter();
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        SERVER.loadLists();
        SERVER.resetFilter();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        final Gson gson;
        final Type listsConfigType = new TypeToken<Map<String, ItemList>>(){}.getType();
        final String defaultList = "default";
        Map<String, ItemList> lists = new HashMap<String, ItemList>();
        final ForgeConfigSpec.ConfigValue<String> listsConfig;
        final ForgeConfigSpec.BooleanValue enabled;
        final ForgeConfigSpec.BooleanValue removeBreakSpeedDebuff;
        final ForgeConfigSpec.BooleanValue playerDefaultEnabled;
        final Map<String, ItemFilter> filters = new HashMap<String, ItemFilter>();

        Server(ForgeConfigSpec.Builder builder) {
            this.gson = new GsonBuilder().create();
            this.lists.put("default", new ItemList());
            this.listsConfig = builder.define("lists", (Object)this.gson.toJson(this.lists), o -> {
                if (o instanceof String) {
                    try {
                        this.gson.fromJson((String)o, this.listsConfigType);
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            });
            this.enabled = builder.comment("Enable SurvivalPlus for all players").define("enabled", true);
            this.removeBreakSpeedDebuff = builder.comment("If true, players will break blocks in build mode as fast as if they were not flying").define("removeBreakSpeedDebuff", true);
            this.playerDefaultEnabled = builder.comment("Enable for all players by default. If false, you will need to use /build enable @s to enable for a player.").define("playerDefaultEnabled", true);
        }

        void loadLists() {
            String configValue = (String)this.listsConfig.get();
            this.lists = (Map)this.gson.fromJson(configValue, this.listsConfigType);
            if (this.lists == null) {
                this.lists = new HashMap<String, ItemList>();
            }
        }

        private void saveLists() {
            this.listsConfig.set((Object)this.gson.toJson(this.lists));
            this.listsConfig.save();
        }

        public Collection<String> getLists() {
            return this.lists.keySet();
        }

        public <T> T modifyList(String name, Function<ItemList, T> function, boolean save) {
            ItemList list = this.lists.get(name);
            if (list == null) {
                list = new ItemList();
                this.lists.put(name, list);
            }
            T result = function.apply(list);
            if (save) {
                this.saveLists();
            }
            this.resetFilter();
            return result;
        }

        private void addToList(Function<ItemList, List<String>> getter, String name, String entry, boolean save) {
            this.modifyList(name, list -> {
                if (((List)getter.apply((ItemList)list)).contains(entry)) {
                    return false;
                }
                return ((List)getter.apply((ItemList)list)).add(entry);
            }, save);
        }

        public void addToWhitelist(String name, String entry, boolean save) {
            this.addToList(ItemList::getWhitelist, name, entry, save);
        }

        public void addToBlacklist(String name, String entry, boolean save) {
            this.addToList(ItemList::getBlacklist, name, entry, save);
        }

        public boolean removeFromWhitelist(String name, String entry, boolean save) {
            return this.modifyList(name, list -> list.getWhitelist().remove(entry), save);
        }

        public boolean removeFromBlacklist(String name, String entry, boolean save) {
            return this.modifyList(name, list -> list.getBlacklist().remove(entry), save);
        }

        public int clearWhitelist(String name, boolean save) {
            return this.modifyList(name, list -> {
                int size = list.getWhitelist().size();
                list.getWhitelist().clear();
                return size;
            }, save);
        }

        public int clearBlacklist(String name, boolean save) {
            return this.modifyList(name, list -> {
                int size = list.getBlacklist().size();
                list.getBlacklist().clear();
                return size;
            }, save);
        }

        public Stream<String> getWhitelistStream(String name) {
            List<String> list = this.lists.get(name).getWhitelist();
            if (list == null) {
                list = new ArrayList<String>();
            }
            return list.stream();
        }

        public Stream<String> getBlacklistStream(String name) {
            List<String> list = this.lists.get(name).getBlacklist();
            if (list == null) {
                list = new ArrayList<String>();
            }
            return list.stream();
        }

        public ItemFilter getFilter(String name) {
            return this.filters.computeIfAbsent(name, k -> {
                ItemList list = this.lists.getOrDefault(k, new ItemList());
                return ItemFilter.fromStrings(list.getWhitelist(), list.getBlacklist());
            });
        }

        void resetFilter() {
            this.filters.clear();
        }

        public void enable(boolean state) {
            this.enabled.set((Object)state);
            this.enabled.save();
        }

        public boolean enabled() {
            return (Boolean)this.enabled.get();
        }

        public boolean playerDefaultEnabled() {
            return (Boolean)this.playerDefaultEnabled.get();
        }

        public boolean removeBreakSpeedDebuff() {
            return (Boolean)this.removeBreakSpeedDebuff.get();
        }
    }

    public static class ItemList {
        private final List<String> whitelist;
        private final List<String> blacklist;

        public ItemList(List<String> whitelist, List<String> blacklist) {
            this.whitelist = whitelist;
            this.blacklist = blacklist;
        }

        public ItemList() {
            this(new ArrayList<String>(), new ArrayList<String>());
        }

        public List<String> getWhitelist() {
            return this.whitelist;
        }

        public List<String> getBlacklist() {
            return this.blacklist;
        }
    }
}

