/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild;

import com.lovetropics.gamemodebuild.GBConfigs;
import com.lovetropics.gamemodebuild.command.GamemodeBuildCommand;
import com.lovetropics.gamemodebuild.command.ItemFilterArgument;
import com.lovetropics.gamemodebuild.container.BuildContainer;
import com.lovetropics.gamemodebuild.message.GBNetwork;
import com.lovetropics.gamemodebuild.state.GBClientState;
import com.lovetropics.gamemodebuild.state.GBServerState;
import com.mojang.brigadier.CommandDispatcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="gamemodebuild")
public class GamemodeBuild {
    public static final String MODID = "gamemodebuild";
    public static final String NAME = "Build Mode";
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> ARGUMENT_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)"gamemodebuild");
    private static final RegistryObject<ArgumentTypeInfo<?, ?>> ITEM_FILTER_ARGUMENT = ARGUMENT_REGISTER.register("item_filter", () -> ArgumentTypeInfos.registerByClass(ItemFilterArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235449_(ItemFilterArgument::new)));
    private static final Pattern QUALIFIER = Pattern.compile("-\\w+\\+\\d+");

    public GamemodeBuild() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(GamemodeBuild::getCompatVersion, (s, v) -> GamemodeBuild.isCompatibleVersion(s)));
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        ARGUMENT_REGISTER.register(modBus);
        BuildContainer.REGISTER.register(modBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)GBConfigs.serverSpec);
    }

    public static String getCompatVersion() {
        return GamemodeBuild.getCompatVersion(((ModContainer)ModList.get().getModContainerById(MODID).orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    public static boolean isCompatibleVersion(String version) {
        return GamemodeBuild.getCompatVersion().equals(GamemodeBuild.getCompatVersion(version));
    }

    private void setup(FMLCommonSetupEvent event) {
        GBNetwork.register();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        GamemodeBuildCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().m_20096_()) {
            return;
        }
        if (GBConfigs.SERVER.removeBreakSpeedDebuff() && GamemodeBuild.isActive(event.getEntity())) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
    }

    public static boolean isActive(Player player) {
        if (player.m_9236_().m_5776_()) {
            return GBClientState.isActive();
        }
        return GBServerState.isActiveFor(player);
    }
}

