/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild;

import com.lovetropics.gamemodebuild.mixin.CreativeModeTabAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.SingleKeyCache;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.apache.commons.lang3.Validate;

public class ItemFilter {
    private final List<Predicate<Item>> whitelistPredicates;
    private final List<Predicate<Item>> blacklistPredicates;
    private final SingleKeyCache<Key, List<ItemStack>> cache;

    public static ItemFilter fromStrings(List<String> whitelist, List<String> blacklist) {
        return new ItemFilter(ItemFilter.parsePredicates(whitelist), ItemFilter.parsePredicates(blacklist));
    }

    private static List<Predicate<Item>> parsePredicates(List<String> predicates) {
        if (predicates == null) {
            return new ArrayList<Predicate<Item>>();
        }
        return predicates.stream().map(ItemFilter::parsePredicate).collect(Collectors.toList());
    }

    private static Predicate<Item> parsePredicate(String predicate) {
        Validate.notNull((Object)predicate);
        if ("*".equals(predicate)) {
            return item -> true;
        }
        if (predicate.startsWith("#")) {
            ResourceLocation tagLocation = new ResourceLocation(predicate.substring(1));
            return new TagFilter((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLocation));
        }
        ResourceLocation location = new ResourceLocation(predicate);
        return new ItemTypeFilter((ResourceKey<Item>)ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)location));
    }

    private ItemFilter(List<Predicate<Item>> whitelist, List<Predicate<Item>> blacklist) {
        this.whitelistPredicates = new ArrayList<Predicate<Item>>(whitelist);
        this.blacklistPredicates = new ArrayList<Predicate<Item>>(blacklist);
        this.cache = Util.m_269175_(key -> this.computeStacks(key.featureFlags(), key.registryAccess()));
    }

    public List<ItemStack> getAllStacks(FeatureFlagSet enabledFeatures, RegistryAccess registryAccess) {
        return (List)this.cache.m_269185_((Object)new Key(enabledFeatures, (HolderLookup.Provider)registryAccess));
    }

    private List<ItemStack> computeStacks(FeatureFlagSet enabledFeatures, HolderLookup.Provider registryAccess) {
        if (this.whitelistPredicates.isEmpty()) {
            return List.of();
        }
        Set items = ItemStackLinkedSet.m_261170_();
        CreativeModeTab.Output output = this.createFilteredOutput(items);
        CreativeModeTab.ItemDisplayParameters parameters = new CreativeModeTab.ItemDisplayParameters(enabledFeatures, true, registryAccess);
        BuiltInRegistries.f_279662_.m_203611_().forEach(holder -> {
            CreativeModeTab tab = (CreativeModeTab)holder.m_203334_();
            if (tab.m_257962_() != CreativeModeTab.Type.SEARCH) {
                ItemFilter.generateItems((ResourceKey<CreativeModeTab>)holder.m_205785_(), tab, parameters, output);
            }
        });
        return List.copyOf(items);
    }

    private static void generateItems(ResourceKey<CreativeModeTab> tabKey, CreativeModeTab tab, CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        CreativeModeTab.DisplayItemsGenerator originalGenerator = ((CreativeModeTabAccessor)tab).getDisplayItemsGenerator();
        MutableHashedLinkedMap entries = new MutableHashedLinkedMap(ItemStackLinkedSet.f_260558_, (key, left, right) -> CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        originalGenerator.m_257865_(parameters, (arg_0, arg_1) -> ((MutableHashedLinkedMap)entries).put(arg_0, arg_1));
        ModLoader.get().postEvent((Event)new BuildCreativeModeTabContentsEvent(tab, tabKey, parameters, entries));
        entries.forEach(e -> output.m_246342_((ItemStack)e.getKey()));
    }

    private CreativeModeTab.Output createFilteredOutput(Set<ItemStack> items) {
        Predicate<ItemStack> whitelist = stack -> {
            for (Predicate<Item> predicate : this.whitelistPredicates) {
                if (!predicate.test(stack.m_41720_())) continue;
                return true;
            }
            return false;
        };
        Predicate<ItemStack> blacklist = !this.blacklistPredicates.isEmpty() ? stack -> {
            for (Predicate<Item> predicate : this.blacklistPredicates) {
                if (!predicate.test(stack.m_41720_())) continue;
                return false;
            }
            return true;
        } : stack -> true;
        return (stack, visibility) -> {
            if (whitelist.test(stack) && blacklist.test(stack)) {
                items.add(stack);
            }
        };
    }

    private record TagFilter(TagKey<Item> tag) implements Predicate<Item>
    {
        @Override
        public boolean test(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }
    }

    private record ItemTypeFilter(ResourceKey<Item> item) implements Predicate<Item>
    {
        @Override
        public boolean test(Item item) {
            return item.m_204114_().m_203565_(this.item);
        }
    }

    private record Key(FeatureFlagSet featureFlags, HolderLookup.Provider registryAccess) {
    }
}

