/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild.command;

import com.lovetropics.gamemodebuild.GBConfigs;
import com.lovetropics.gamemodebuild.command.ItemFilterArgument;
import com.lovetropics.gamemodebuild.message.GBNetwork;
import com.lovetropics.gamemodebuild.message.ListUpdateMessage;
import com.lovetropics.gamemodebuild.state.GBPlayerStore;
import com.lovetropics.gamemodebuild.state.GBServerState;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public final class GamemodeBuildCommand {
    private static final SimpleCommandExceptionType FILTER_DID_NOT_EXIST = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"That filter did not exist!"));

    private static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> getPlayerArg() {
        return Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_());
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ItemFilterArgument.Result> getItemArg(CommandBuildContext buildContext) {
        return Commands.m_82129_((String)"item", (ArgumentType)ItemFilterArgument.itemFilter(buildContext));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> enable(boolean enable) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)(enable ? "enable" : "disable")).requires(src -> src.m_6761_(4))).executes(ctx -> GamemodeBuildCommand.enable((CommandContext<CommandSourceStack>)ctx, null, enable))).then(GamemodeBuildCommand.getPlayerArg().executes(ctx -> GamemodeBuildCommand.enable((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"player"), enable)));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> nameArg() {
        return Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(GBConfigs.SERVER.getLists(), (SuggestionsBuilder)builder));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> listCommands(boolean whitelist, CommandBuildContext buildContext) {
        return ((RequiredArgumentBuilder)((RequiredArgumentBuilder)GamemodeBuildCommand.nameArg().then(Commands.m_82127_((String)"add").then(GamemodeBuildCommand.getItemArg(buildContext).executes(GamemodeBuildCommand.getListAddCommand(whitelist))))).then(Commands.m_82127_((String)"remove").then(GamemodeBuildCommand.getItemArg(buildContext).suggests(GamemodeBuildCommand.getSuggestions(whitelist)).executes(GamemodeBuildCommand.getListRemoveCommand(whitelist))))).then(Commands.m_82127_((String)"clear").executes(GamemodeBuildCommand.getListClearCommand(whitelist)));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"build").requires(src -> src.m_6761_(4))).then(GamemodeBuildCommand.enable(true))).then(GamemodeBuildCommand.enable(false))).then(Commands.m_82127_((String)"whitelist").then(GamemodeBuildCommand.listCommands(true, buildContext)))).then(Commands.m_82127_((String)"blacklist").then(GamemodeBuildCommand.listCommands(false, buildContext)))).then(Commands.m_82127_((String)"set_list").then(GamemodeBuildCommand.getPlayerArg().then(GamemodeBuildCommand.nameArg().executes(ctx -> {
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"player");
            players.forEach(player -> GBPlayerStore.setList((Player)player, StringArgumentType.getString((CommandContext)ctx, (String)"name")));
            return players.size();
        })))));
    }

    private static int enable(CommandContext<CommandSourceStack> ctx, @Nullable Collection<ServerPlayer> players, boolean state) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer server = src.m_81377_();
        if (players == null) {
            if (state == GBServerState.isGloballyEnabled()) {
                throw new CommandRuntimeException((Component)Component.m_237113_((String)("Build Mode is already " + (state ? "enabled" : "disabled"))));
            }
            GBServerState.setGloballyEnabled(server, state);
            src.m_288197_(() -> Component.m_237113_((String)((state ? "Enabled" : "Disabled") + " Build Mode globally")), false);
            return 1;
        }
        players.forEach(p -> GBServerState.setEnabledFor(p, state));
        src.m_288197_(() -> Component.m_237113_((String)((state ? "Enabled" : "Disabled") + " Build Mode for " + players.size() + " player(s)")), false);
        if (state && !GBServerState.isGloballyEnabled()) {
            src.m_288197_(() -> Component.m_237113_((String)"Warning: This will have no effect as Build Mode is currently globally disabled!").m_130940_(ChatFormatting.YELLOW), false);
        }
        return players.size();
    }

    private static Command<CommandSourceStack> getListAddCommand(boolean whitelist) {
        return ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            ItemFilterArgument.Result filter = ItemFilterArgument.getItemFilter((CommandContext<CommandSourceStack>)ctx, "item");
            String entry = filter.asString();
            if (whitelist) {
                GBConfigs.SERVER.addToWhitelist(name, entry, true);
            } else {
                GBConfigs.SERVER.addToBlacklist(name, entry, true);
            }
            GBNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ListUpdateMessage(ListUpdateMessage.Operation.ADD, whitelist, name, entry));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Added '" + entry + "' to " + name + (whitelist ? " whitelist" : " blacklist"))), false);
            return 1;
        };
    }

    private static Command<CommandSourceStack> getListRemoveCommand(boolean whitelist) {
        return ctx -> {
            boolean found;
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            ItemFilterArgument.Result filter = ItemFilterArgument.getItemFilter((CommandContext<CommandSourceStack>)ctx, "item");
            String entry = filter.asString();
            boolean bl = found = whitelist ? GBConfigs.SERVER.removeFromWhitelist(name, entry, true) : GBConfigs.SERVER.removeFromBlacklist(name, entry, true);
            if (!found) {
                throw FILTER_DID_NOT_EXIST.create();
            }
            GBNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ListUpdateMessage(ListUpdateMessage.Operation.REMOVE, whitelist, name, entry));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed '" + entry + "' from " + name + (whitelist ? " whitelist" : " blacklist"))), false);
            return 1;
        };
    }

    private static Command<CommandSourceStack> getListClearCommand(boolean whitelist) {
        return ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            int count = whitelist ? GBConfigs.SERVER.clearWhitelist(name, true) : GBConfigs.SERVER.clearBlacklist(name, true);
            GBNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ListUpdateMessage(ListUpdateMessage.Operation.CLEAR, whitelist, name, null));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed " + count + " " + (whitelist ? " whitelist" : " blacklist") + " entries from " + name)), false);
            return 1;
        };
    }

    private static SuggestionProvider<CommandSourceStack> getSuggestions(boolean whitelist) {
        return (ctx, builder) -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return SharedSuggestionProvider.m_82981_(whitelist ? GBConfigs.SERVER.getWhitelistStream(name) : GBConfigs.SERVER.getBlacklistStream(name), (SuggestionsBuilder)builder);
        };
    }
}

