/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;

public class ItemFilterArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick", "minecraft:stick", "#stick");
    private final HolderLookup<Item> items;

    public ItemFilterArgument(CommandBuildContext buildContext) {
        this.items = buildContext.m_227133_(Registries.f_256913_);
    }

    public static ItemFilterArgument itemFilter(CommandBuildContext buildContext) {
        return new ItemFilterArgument(buildContext);
    }

    public static Result getItemFilter(CommandContext<CommandSourceStack> context, String name) {
        return (Result)context.getArgument(name, Result.class);
    }

    public Result parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead(1) && reader.peek() == '*') {
            reader.skip();
            return new WildcardResult();
        }
        return (Result)ItemParser.m_235319_(this.items, (StringReader)reader).map(item -> new ItemResult((Holder<Item>)item.f_235328_()), tag -> new TagResult((HolderSet<Item>)tag.f_235339_()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
        return ItemParser.m_235308_(this.items, (SuggestionsBuilder)builder, (boolean)true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static interface Result {
        public String asString();
    }

    public static class WildcardResult
    implements Result {
        @Override
        public String asString() {
            return "*";
        }
    }

    public record TagResult(HolderSet<Item> set) implements Result
    {
        @Override
        public String asString() {
            return this.set.m_245234_().map(key -> "#" + key.f_203868_()).orElseThrow();
        }
    }

    public record ItemResult(Holder<Item> item) implements Result
    {
        @Override
        public String asString() {
            return this.item.m_203543_().map(key -> key.m_135782_().toString()).orElseThrow();
        }
    }
}

