/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild.container;

import com.google.common.base.Strings;
import com.lovetropics.gamemodebuild.GBConfigs;
import com.lovetropics.gamemodebuild.container.BuildScreen;
import com.lovetropics.gamemodebuild.container.GBStackMarker;
import com.lovetropics.gamemodebuild.message.GBNetwork;
import com.lovetropics.gamemodebuild.message.SetScrollMessage;
import com.lovetropics.gamemodebuild.state.GBPlayerStore;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="gamemodebuild", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BuildContainer
extends AbstractContainerMenu {
    public static final int WIDTH = 9;
    public static final int HEIGHT = 5;
    public static final DeferredRegister<MenuType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"gamemodebuild");
    public static final RegistryObject<MenuType<BuildContainer>> TYPE = REGISTER.register("container", () -> IForgeMenuType.create(BuildContainer::new));
    private static final ThreadLocal<Boolean> SUPPRESS_SEND_CHANGES = new ThreadLocal();
    private boolean takeStacks = false;
    private final Player player;
    public final InfiniteInventory inventory;
    private int scrollOffset;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)TYPE.get()), BuildScreen::new));
    }

    public static Component title() {
        return Component.m_237113_((String)"Build Mode");
    }

    public BuildContainer(int windowId, Inventory playerInventory, Player player) {
        this(windowId, playerInventory, player, GBPlayerStore.getList(player));
    }

    public BuildContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, playerInventory.f_35978_, extraData.m_130277_());
    }

    public BuildContainer(int windowId, Inventory playerInventory, Player player, @Nullable String list) {
        super((MenuType)TYPE.get(), windowId);
        this.player = player;
        FeatureFlagSet featureFlags = player.m_9236_().m_246046_();
        RegistryAccess registryAccess = player.m_9236_().m_9598_();
        List<ItemStack> buildingStacks = list == null ? List.of() : GBConfigs.SERVER.getFilter(list).getAllStacks(featureFlags, registryAccess);
        this.inventory = new InfiniteInventory(player, buildingStacks);
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 9; ++x) {
                int i = x + y * 9;
                this.m_38897_(new InfiniteSlot(this.inventory, i, 9 + x * 18, 18 + y * 18));
            }
        }
        for (int h = 0; h < 9; ++h) {
            this.m_38897_(new Slot((Container)playerInventory, h, 9 + h * 18, 112));
        }
    }

    public void setScrollOffset(int scrollOffset) {
        if (this.scrollOffset != (scrollOffset = Math.max(scrollOffset, 0))) {
            this.scrollOffset = scrollOffset;
            if (this.player.m_9236_().f_46443_) {
                GBNetwork.CHANNEL.sendToServer((Object)new SetScrollMessage(scrollOffset));
            }
            for (Slot slot : this.f_38839_) {
                if (!(slot instanceof InfiniteSlot)) continue;
                ((InfiniteSlot)slot).setScrollOffset(scrollOffset);
            }
        }
    }

    public int scrollHeight() {
        return (this.inventory.items.size() + 9 - 1) / 9 - 5;
    }

    public boolean canScroll() {
        return this.inventory.items.size() > 45;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BitSet applyFilter(String filter) {
        return this.inventory.applyFilter(filter);
    }

    public void setFilter(BitSet filteredSlots) {
        this.inventory.setFilter(filteredSlots);
    }

    public void m_182410_(int id, List<ItemStack> stacks, ItemStack carried) {
    }

    public void m_38946_() {
        SUPPRESS_SEND_CHANGES.set(true);
        try {
            super.m_38946_();
        }
        finally {
            SUPPRESS_SEND_CHANGES.set(false);
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId < 0 || slotId >= 45) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
            return;
        }
        this.takeStacks = clickTypeIn == ClickType.SWAP;
        ItemStack oldCursor = this.m_142621_().m_41777_();
        if ((clickTypeIn == ClickType.PICKUP || clickTypeIn == ClickType.PICKUP_ALL) && ItemStack.m_150942_((ItemStack)this.m_38853_(slotId).m_7993_(), (ItemStack)oldCursor)) {
            ItemStack ret = oldCursor.m_41777_();
            if (ret.m_41613_() < ret.m_41741_()) {
                ret.m_41769_(1);
            }
            this.m_142503_(ret);
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
        ItemStack newCursor = this.m_142621_();
        if (!oldCursor.m_41619_() && GBStackMarker.isMarked(oldCursor) && GBStackMarker.isMarked(newCursor)) {
            if (!ItemStack.m_150942_((ItemStack)oldCursor, (ItemStack)newCursor)) {
                this.m_142503_(ItemStack.f_41583_);
            } else {
                newCursor.m_41764_(Math.max(oldCursor.m_41613_(), newCursor.m_41613_()));
                this.m_142503_(newCursor);
            }
        }
        this.takeStacks = false;
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot instanceof InfiniteSlot) {
            ItemStack stack = slot.m_7993_().m_255036_(slot.m_7993_().m_41741_());
            this.m_142503_(stack);
            return ItemStack.f_41583_;
        }
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            if (index < 45) {
                stack.m_41764_(64);
                this.m_38903_(stack, 45, this.f_38839_.size(), false);
                return ItemStack.f_41583_;
            }
            if (GBStackMarker.isMarked(stack)) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public class InfiniteInventory
    implements Container {
        private final Player player;
        private final List<ItemStack> masterItems;
        private final List<ItemStack> items;

        private InfiniteInventory(Player player, List<ItemStack> items) {
            this.player = player;
            this.masterItems = items;
            this.items = new ArrayList<ItemStack>();
            this.setFilter(new BitSet());
        }

        public void m_6211_() {
        }

        public int m_6643_() {
            return this.items.size();
        }

        public boolean m_7983_() {
            return this.items.isEmpty();
        }

        public ItemStack m_8020_(int index) {
            if (index >= 0 && index < this.items.size()) {
                ItemStack stack = this.items.get(index).m_41777_();
                if (BuildContainer.this.takeStacks) {
                    stack.m_41764_(stack.m_41741_());
                }
                GBStackMarker.mark(stack);
                return stack;
            }
            return ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int index, int count) {
            ItemStack stack = this.m_8020_(index);
            if (!stack.m_41619_()) {
                stack.m_41764_(count);
                return stack;
            }
            return ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int index) {
            return this.m_8020_(index);
        }

        public void m_6836_(int index, ItemStack stack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void setFilter(BitSet filteredSlots) {
            this.items.clear();
            for (int i = 0; i < this.masterItems.size(); ++i) {
                if (filteredSlots.get(i)) continue;
                this.items.add(this.masterItems.get(i));
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public BitSet applyFilter(String filter) {
            BitSet filteredSlots = new BitSet();
            Locale locale = Minecraft.m_91087_().m_91102_().getJavaLocale();
            if (!Strings.isNullOrEmpty((String)(filter = filter.toLowerCase(locale)))) {
                for (int i = 0; i < this.masterItems.size(); ++i) {
                    ItemStack stack = this.masterItems.get(i);
                    if (!stack.m_41619_() && stack.m_41786_().getString().toLowerCase(locale).contains(filter)) continue;
                    filteredSlots.set(i);
                }
            }
            this.setFilter(filteredSlots);
            return filteredSlots;
        }
    }

    public static class InfiniteSlot
    extends Slot {
        private int idxOffset;

        public InfiniteSlot(InfiniteInventory inventory, int index, int x, int y) {
            super((Container)inventory, index, x, y);
        }

        public boolean m_8010_(Player player) {
            return true;
        }

        public boolean m_5857_(ItemStack stack) {
            return GBStackMarker.isMarked(stack);
        }

        public void setScrollOffset(int offset) {
            this.idxOffset = Math.max(offset, 0) * 9;
        }

        public void m_5852_(ItemStack stack) {
        }

        public ItemStack m_6201_(int amount) {
            return this.f_40218_.m_7407_(this.getSlotIndex() + this.idxOffset, amount);
        }

        public ItemStack m_7993_() {
            Boolean suppressSendChanges = SUPPRESS_SEND_CHANGES.get();
            if (suppressSendChanges != null && suppressSendChanges.booleanValue()) {
                return ItemStack.f_41583_;
            }
            return this.f_40218_.m_8020_(this.getSlotIndex() + this.idxOffset);
        }
    }
}

