/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild.container;

import com.lovetropics.gamemodebuild.container.BuildContainer;
import com.lovetropics.gamemodebuild.message.GBNetwork;
import com.lovetropics.gamemodebuild.message.UpdateFilterMessage;
import java.util.BitSet;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BuildScreen
extends AbstractContainerScreen<BuildContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("gamemodebuild", "textures/gui/menu.png");
    private static final ResourceLocation TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private EditBox searchField;
    private float scrollAmount;
    private boolean draggingScroll;
    private String lastSearchFilter = "";

    public BuildScreen(BuildContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97726_ = 195;
        this.f_97727_ = 136;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchField = new EditBox(this.f_96547_, this.f_97735_ + 82, this.f_97736_ + 6, 80, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchField.m_94199_(50);
        this.searchField.m_94182_(false);
        this.searchField.m_94194_(true);
        this.searchField.m_94202_(-1);
        this.searchField.m_94151_(searchFilter -> {
            if (!searchFilter.equals(this.lastSearchFilter)) {
                this.updateSearch((String)searchFilter);
            }
            this.lastSearchFilter = searchFilter;
        });
        this.m_142416_((GuiEventListener)this.searchField);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.searchField.m_94120_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.searchField.m_93696_() && this.searchField.m_94213_() && keyCode != 256) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void updateSearch(String searchFilter) {
        BitSet filteredSlots = ((BuildContainer)this.f_97732_).applyFilter(searchFilter);
        GBNetwork.CHANNEL.sendToServer((Object)new UpdateFilterMessage(filteredSlots));
        this.updateScroll(this.scrollAmount);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((BuildContainer)this.f_97732_).canScroll()) {
            Rect2i rect = this.scrollRect();
            graphics.m_280218_(TABS, rect.left, rect.top, 232, 0, rect.width, rect.height);
        }
    }

    public boolean m_6050_(double x, double y, double amount) {
        if (((BuildContainer)this.f_97732_).canScroll()) {
            int scrollHeight = ((BuildContainer)this.f_97732_).scrollHeight();
            this.updateScroll((float)((double)this.scrollAmount - amount / (double)scrollHeight));
            return true;
        }
        return false;
    }

    public boolean m_6375_(double x, double y, int button) {
        Rect2i rect;
        if (button == 0 && (rect = this.scrollRect()).contains(x, y)) {
            this.draggingScroll = true;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        if (this.draggingScroll) {
            this.draggingScroll = false;
            return true;
        }
        return super.m_6348_(x, y, button);
    }

    public boolean m_7979_(double x, double y, int button, double deltaX, double deltaY) {
        if (this.draggingScroll) {
            Rect2i area = this.scrollArea();
            Rect2i rect = this.scrollRect();
            this.updateScroll((float)(y - (double)area.top - (double)((float)rect.height / 2.0f)) / (float)(area.height - rect.height));
            return true;
        }
        return super.m_7979_(x, y, button, deltaX, deltaY);
    }

    private void updateScroll(float amount) {
        this.scrollAmount = Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f);
        int scrollOffset = Math.round(this.scrollAmount * (float)((BuildContainer)this.f_97732_).scrollHeight());
        ((BuildContainer)this.f_97732_).setScrollOffset(scrollOffset);
    }

    private Rect2i scrollRect() {
        Rect2i area = this.scrollArea();
        int scrollLength = (int)((float)(area.height - 17) * this.scrollAmount);
        return new Rect2i(area.left, area.top + scrollLength, area.width, 15);
    }

    private Rect2i scrollArea() {
        int scrollLeft = this.f_97735_ + 175;
        int scrollTop = this.f_97736_ + 18;
        return new Rect2i(scrollLeft, scrollTop, 12, 112);
    }

    private record Rect2i(int left, int top, int width, int height) {
        public boolean contains(double x, double y) {
            return x >= (double)this.left && y >= (double)this.top && x <= (double)(this.left + this.width) && y <= (double)(this.top + this.height);
        }
    }
}

