/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild.message;

import com.lovetropics.gamemodebuild.GBConfigs;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record ListUpdateMessage(Operation operation, boolean whitelist, String name, String entry) {
    public ListUpdateMessage(FriendlyByteBuf input) {
        this(Operation.deserialize(input.readByte()), input.readBoolean(), (String)input.m_236868_(b -> b.m_130136_(64)), (String)input.m_236868_(b -> b.m_130136_(100)));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        switch (this.operation) {
            case ADD: {
                if (this.whitelist) {
                    GBConfigs.SERVER.addToWhitelist(this.name, this.entry, false);
                    break;
                }
                GBConfigs.SERVER.addToBlacklist(this.name, this.entry, false);
                break;
            }
            case REMOVE: {
                if (this.whitelist) {
                    GBConfigs.SERVER.removeFromWhitelist(this.name, this.entry, false);
                    break;
                }
                GBConfigs.SERVER.removeFromBlacklist(this.name, this.entry, false);
                break;
            }
            case CLEAR: {
                if (this.whitelist) {
                    GBConfigs.SERVER.clearWhitelist(this.name, false);
                    break;
                }
                GBConfigs.SERVER.clearBlacklist(this.name, false);
            }
        }
    }

    public void serialize(FriendlyByteBuf output) {
        output.writeByte((int)this.operation.serialize());
        output.writeBoolean(this.whitelist);
        output.m_236821_((Object)this.name, (b, s) -> b.m_130072_(s, 64));
        output.m_236821_((Object)this.entry, (b, s) -> b.m_130072_(s, 100));
    }

    public static enum Operation {
        ADD,
        REMOVE,
        CLEAR;


        public byte serialize() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ADD -> 1;
                case REMOVE -> 2;
                case CLEAR -> 3;
            };
        }

        public static Operation deserialize(byte data) {
            return switch (data) {
                case 1 -> ADD;
                case 2 -> REMOVE;
                case 3 -> CLEAR;
                default -> throw new IllegalArgumentException("Operation can only be a value from 1 to 3");
            };
        }
    }
}

