/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild.state;

import com.lovetropics.gamemodebuild.GBConfigs;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class GBPlayerStore {
    private static final String KEY_ACTIVE = "active";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_PLAYER_INVENTORY = "playerinv";
    private static final String KEY_BUILD_INVENTORY = "buildinv";
    private static final String KEY_LIST = "list";

    public static void setEnabled(Player player, boolean enabled) {
        CompoundTag survivalPlus = GBPlayerStore.getOrCreatePersistent(player, "gamemodebuild");
        survivalPlus.m_128379_(KEY_ENABLED, enabled);
    }

    public static boolean isEnabled(Player player) {
        CompoundTag survivalPlus = GBPlayerStore.getOrCreatePersistent(player, "gamemodebuild");
        if (!survivalPlus.m_128441_(KEY_ENABLED)) {
            return GBConfigs.SERVER.playerDefaultEnabled();
        }
        return !survivalPlus.m_128441_(KEY_ENABLED) || survivalPlus.m_128471_(KEY_ENABLED);
    }

    public static void setActive(Player player, boolean active) {
        CompoundTag survivalPlus = GBPlayerStore.getOrCreatePersistent(player, "gamemodebuild");
        survivalPlus.m_128379_(KEY_ACTIVE, active);
    }

    public static boolean isActive(Player player) {
        CompoundTag survivalPlus = GBPlayerStore.getOrCreatePersistent(player, "gamemodebuild");
        return survivalPlus.m_128471_(KEY_ACTIVE);
    }

    public static void setList(Player player, String list) {
        CompoundTag survivalPlus = GBPlayerStore.getOrCreatePersistent(player, "gamemodebuild");
        survivalPlus.m_128359_(KEY_LIST, list);
    }

    public static String getList(Player player) {
        CompoundTag survivalPlus = GBPlayerStore.getOrCreatePersistent(player, "gamemodebuild");
        return survivalPlus.m_128441_(KEY_LIST) ? survivalPlus.m_128461_(KEY_LIST) : "default";
    }

    public static void switchToInventory(Player player, boolean buildMode) {
        if (buildMode) {
            GBPlayerStore.switchInventories(player, KEY_PLAYER_INVENTORY, KEY_BUILD_INVENTORY);
        } else {
            GBPlayerStore.switchInventories(player, KEY_BUILD_INVENTORY, KEY_PLAYER_INVENTORY);
        }
    }

    private static void switchInventories(Player player, String from, String to) {
        ListTag currentInventory = new ListTag();
        player.m_150109_().m_36026_(currentInventory);
        ListTag newInventory = GBPlayerStore.swapInventoryTag(player, from, to, currentInventory);
        GBPlayerStore.loadInventory(player.m_150109_(), newInventory);
    }

    private static ListTag swapInventoryTag(Player player, String from, String to, ListTag inventory) {
        CompoundTag tag = GBPlayerStore.getOrCreatePersistent(player, "gamemodebuild");
        ListTag newInventory = tag.m_128437_(to, 10);
        tag.m_128473_(to);
        tag.m_128365_(from, (Tag)inventory);
        return newInventory;
    }

    private static void loadInventory(Inventory inventory, ListTag tag) {
        List armor = List.copyOf(inventory.f_35975_);
        inventory.m_6211_();
        inventory.m_36035_(tag);
        for (int i = 0; i < armor.size(); ++i) {
            inventory.f_35975_.set(i, (Object)((ItemStack)armor.get(i)));
        }
    }

    private static CompoundTag getOrCreatePersistent(Player player, String key) {
        CompoundTag nbt = player.getPersistentData();
        CompoundTag persisted = GBPlayerStore.getOrCreateCompound(nbt, "PlayerPersisted");
        return GBPlayerStore.getOrCreateCompound(persisted, key);
    }

    private static CompoundTag getOrCreateCompound(CompoundTag root, String key) {
        if (root.m_128425_(key, 10)) {
            return root.m_128469_(key);
        }
        CompoundTag compound = new CompoundTag();
        root.m_128365_(key, (Tag)compound);
        return compound;
    }
}

