/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.gamemodebuild.state;

import com.lovetropics.gamemodebuild.GBConfigs;
import com.lovetropics.gamemodebuild.message.GBNetwork;
import com.lovetropics.gamemodebuild.message.SetActiveMessage;
import com.lovetropics.gamemodebuild.state.GBPlayerStore;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="gamemodebuild")
public final class GBServerState {
    public static void setGloballyEnabled(MinecraftServer server, boolean enabled) {
        if (enabled == GBServerState.isGloballyEnabled()) {
            return;
        }
        Reference2BooleanOpenHashMap activeMap = new Reference2BooleanOpenHashMap();
        for (ServerPlayer player2 : server.m_6846_().m_11314_()) {
            activeMap.put((Object)player2, GBServerState.isActiveFor((Player)player2));
        }
        GBConfigs.SERVER.enable(enabled);
        activeMap.forEach((player, wasActive) -> GBServerState.notifyPlayerActivity(wasActive, player));
    }

    public static void setEnabledFor(ServerPlayer player, boolean enabled) {
        boolean wasActive = GBServerState.isActiveFor((Player)player);
        GBPlayerStore.setEnabled((Player)player, enabled);
        GBServerState.notifyPlayerActivity(wasActive, player);
    }

    public static boolean isGloballyEnabled() {
        return GBConfigs.SERVER.enabled();
    }

    public static boolean isEnabledFor(Player player) {
        return GBServerState.isGloballyEnabled() && GBPlayerStore.isEnabled(player);
    }

    public static void requestActive(ServerPlayer player, boolean active) {
        if (!GBServerState.isEnabledFor((Player)player)) {
            GBServerState.notifyDisabled(player);
            return;
        }
        boolean wasActive = GBServerState.isActiveFor((Player)player);
        GBPlayerStore.setActive((Player)player, active);
        GBServerState.notifyPlayerActivity(wasActive, player);
    }

    public static boolean isActiveFor(Player player) {
        return GBServerState.isEnabledFor(player) && GBPlayerStore.isActive(player);
    }

    private static void notifyPlayerActivity(boolean prevState, ServerPlayer player) {
        boolean state = GBServerState.isActiveFor((Player)player);
        if (prevState == state) {
            return;
        }
        GBPlayerStore.switchToInventory((Player)player, state);
        if (state) {
            player.m_5661_((Component)Component.m_237113_((String)"Build Mode activated"), true);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"Build Mode deactivated"), true);
        }
        GBServerState.sendPlayerState(player);
    }

    public static void notifyDisabled(ServerPlayer player) {
        player.m_5661_((Component)Component.m_237113_((String)"Build Mode is disabled!"), true);
    }

    public static void sendPlayerState(ServerPlayer player) {
        SetActiveMessage message = new SetActiveMessage(GBServerState.isActiveFor((Player)player));
        GBNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            GBServerState.sendPlayerState(player2);
        }
    }
}

