/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Reflection;
import com.mojang.brigadier.CommandDispatcher;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.command.TropicraftCommands;
import net.tropicraft.core.common.command.debug.MapBiomesCommand;
import net.tropicraft.core.common.dimension.TropicraftWorldgenRegistries;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeBuilder;
import net.tropicraft.core.common.dimension.carver.TropicraftCarvers;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftStructureTypes;
import net.tropicraft.core.common.dimension.feature.block_state_provider.TropicraftBlockStateProviders;
import net.tropicraft.core.common.dimension.feature.jigsaw.AdjustBuildingHeightProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.AirToCaveAirProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SinkInGroundProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SmoothingGravityProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SteepPathProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureSupportsProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureVoidProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.HomeTreeBranchPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.NoRotateSingleJigsawPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.SingleNoAirJigsawPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePieceTypes;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePoolElementTypes;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftFoliagePlacers;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.item.scuba.ScubaData;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.sound.Sounds;

@Mod(value="tropicraft")
public class Tropicraft {
    public static final ProviderType<RegistrateTagsProvider.Impl<Biome>> BIOME_TAGS = ProviderType.register((String)"tags/biome", type -> (p, e) -> {
        PackOutput output = e.getGenerator().getPackOutput();
        CompletionStage provider = e.getLookupProvider().thenApply(TropicraftWorldgenRegistries::createLookup);
        return new RegistrateTagsProvider.Impl(p, type, "biome", output, Registries.f_256952_, (CompletableFuture)provider, e.getExistingFileHelper());
    });
    private static final NonNullLazy<Registrate> REGISTRATE = NonNullLazy.of(() -> (Registrate)((Registrate)Registrate.create((String)"tropicraft").defaultCreativeTab("tropicraft", builder -> builder.m_257737_(() -> new ItemStack((ItemLike)TropicraftBlocks.PALM_SAPLING.get()))).build()).addDataGenerator(ProviderType.LANG, prov -> {
        prov.add("attribute.name." + ForgeMod.SWIM_SPEED.getId().m_135815_(), "Swim Speed");
        TropicraftLangKeys.generate(prov);
    }));
    private static final Pattern QUALIFIER = Pattern.compile("-\\w+\\+\\d+");

    public static Registrate registrate() {
        return (Registrate)REGISTRATE.get();
    }

    public Tropicraft() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(Tropicraft::getCompatVersion, (s, v) -> Tropicraft.isCompatibleVersion(s)));
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        Sounds.REGISTER.register(modBus);
        ScubaGogglesItem.ATTRIBUTES.register(modBus);
        MixerRecipes.addMixerRecipes();
        TropicraftCarvers.CARVERS.register(modBus);
        TropicraftFoliagePlacers.REGISTER.register(modBus);
        TropicraftTrunkPlacers.REGISTER.register(modBus);
        TropicraftTreeDecorators.REGISTER.register(modBus);
        TropicraftFeatures.FEATURES.register(modBus);
        TropicraftBlockStateProviders.BLOCK_STATE_PROVIDERS.register(modBus);
        TropicraftStructurePoolElementTypes.REGISTER.register(modBus);
        TropicraftProcessorTypes.REGISTER.register(modBus);
        TropicraftStructureTypes.REGISTER.register(modBus);
        TropicraftStructurePieceTypes.REGISTER.register(modBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(event -> {
            StateDefinition frameState = new StateDefinition.Builder((Object)Blocks.f_50016_).m_61104_(new Property[]{BooleanProperty.m_61465_((String)"map")}).m_61101_(Block::m_49966_, BlockState::new);
            ModelBakery.f_119242_ = ImmutableMap.builder().putAll(ModelBakery.f_119242_).put((Object)TropicraftItems.BAMBOO_ITEM_FRAME.getId(), (Object)frameState).build();
        }));
    }

    public static String getCompatVersion() {
        return Tropicraft.getCompatVersion(((ModContainer)ModList.get().getModContainerById("tropicraft").orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    public static boolean isCompatibleVersion(String version) {
        return Tropicraft.getCompatVersion().equals(Tropicraft.getCompatVersion(version));
    }

    private void setup(FMLCommonSetupEvent event) {
        TropicraftPackets.init();
        Reflection.initialize((Class[])new Class[]{TropicraftBiomeBuilder.class, SingleNoAirJigsawPiece.class, NoRotateSingleJigsawPiece.class, HomeTreeBranchPiece.class, AdjustBuildingHeightProcessor.class, AirToCaveAirProcessor.class, SinkInGroundProcessor.class, SmoothingGravityProcessor.class, SteepPathProcessor.class, StructureSupportsProcessor.class, StructureVoidProcessor.class, TropicraftTrunkPlacers.class, TropicraftFoliagePlacers.class, TropicraftTreeDecorators.class});
    }

    private void gatherData(GatherDataEvent event) {
        PackOutput output = event.getGenerator().getPackOutput();
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), TropicraftWorldgenRegistries.BUILDER, Set.of("tropicraft")));
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ScubaData.class);
    }

    private void onServerStarting(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        TropicraftCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        if (!FMLEnvironment.production) {
            MapBiomesCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        }
    }
}

