/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.common.entity.underdasea.EagleRayEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EagleRayModel
extends HierarchicalModel<EagleRayEntity> {
    private final float[] interpolatedWingAmplitudes = new float[10];
    private final ModelPart root;

    public EagleRayModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171480_().m_171481_(-2.0f, 0.0f, 0.0f, 5.0f, 3.0f, 32.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setupAnim(EagleRayEntity eagleRay, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.m_7695_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderWings(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderTailSimple(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    private void renderTailSimple(PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        float minU = 0.75f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 0.5f;
        stack.m_85836_();
        stack.m_252880_(0.55f, 0.0f, 1.5f);
        stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        stack.m_85841_(1.5f, 1.0f, 1.0f);
        EagleRayModel.vertex(buffer, stack.m_85850_().m_252922_(), stack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f, red, green, blue, alpha, minU, minV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.m_85850_().m_252922_(), stack.m_85850_().m_252943_(), 0.0f, 0.0f, 1.0f, red, green, blue, alpha, minU, maxV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.m_85850_().m_252922_(), stack.m_85850_().m_252943_(), 1.0f, 0.0f, 1.0f, red, green, blue, alpha, maxU, maxV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.m_85850_().m_252922_(), stack.m_85850_().m_252943_(), 1.0f, 0.0f, 0.0f, red, green, blue, alpha, maxU, minV, packedLightIn, packedOverlayIn);
        stack.m_85849_();
    }

    private static void vertex(VertexConsumer bufferIn, Matrix4f matrixIn, Matrix3f matrixNormalIn, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int packedLight, int packedOverlay) {
        bufferIn.m_252986_(matrixIn, x, y, z).m_85950_(red, green, blue, alpha).m_7421_(texU, texV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(matrixNormalIn, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private void renderWings(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.03125f, 0.0f, -0.5f);
        matrixStackIn.m_85841_(2.0f, 0.5f, 2.0f);
        this.renderWing(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, false);
        matrixStackIn.m_252880_(0.0f, 0.0f, 0.5f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_252880_(0.0f, 0.0f, -0.5f);
        this.renderWing(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, true);
        matrixStackIn.m_85849_();
    }

    private void renderWing(PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean reverse) {
        float minUFront = 0.0f;
        float maxUFront = 0.25f;
        float minVFront = 0.0f;
        float maxVFront = 0.5f;
        float minUBack = 0.0f;
        float maxUBack = 0.25f;
        float minVBack = 0.5f;
        float maxVBack = 1.0f;
        stack.m_85836_();
        stack.m_252880_(0.078125f, 0.0f, 0.0f);
        for (int i = 1; i < 10; ++i) {
            float prevAmplitude = this.interpolatedWingAmplitudes[i - 1];
            float amplitude = this.interpolatedWingAmplitudes[i];
            float prevX = (float)(i - 1) / 9.0f;
            float x = (float)i / 9.0f;
            float prevUFront = minUFront + (maxUFront - minUFront) * prevX;
            float uFront = minUFront + (maxUFront - minUFront) * x;
            float prevUBack = minUBack + (maxUBack - minUBack) * prevX;
            float uBack = minUBack + (maxUBack - minUBack) * x;
            float offset = -0.001f;
            Matrix4f matrix = stack.m_85850_().m_252922_();
            Matrix3f normal = stack.m_85850_().m_252943_();
            EagleRayModel.vertex(buffer, matrix, normal, x, amplitude - offset, 0.0f, red, green, blue, alpha, uBack, reverse ? maxVBack : minVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, x, amplitude - offset, 1.0f, red, green, blue, alpha, uBack, reverse ? minVBack : maxVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, prevX, prevAmplitude - offset, 1.0f, red, green, blue, alpha, prevUBack, reverse ? minVBack : maxVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, prevX, prevAmplitude - offset, 0.0f, red, green, blue, alpha, prevUBack, reverse ? maxVBack : minVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, prevX, prevAmplitude, 0.0f, red, green, blue, alpha, prevUFront, reverse ? maxVFront : minVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, prevX, prevAmplitude, 1.0f, red, green, blue, alpha, prevUFront, reverse ? minVFront : maxVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, x, amplitude, 1.0f, red, green, blue, alpha, uFront, reverse ? minVFront : maxVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, x, amplitude, 0.0f, red, green, blue, alpha, uFront, reverse ? maxVFront : minVFront, packedLightIn, packedOverlayIn);
        }
        stack.m_85849_();
    }

    public void prepareMobModel(EagleRayEntity ray, float par2, float par3, float partialTicks) {
        float[] prevWingAmplitudes = ray.getPrevWingAmplitudes();
        float[] wingAmplitudes = ray.getWingAmplitudes();
        for (int i = 1; i < 10; ++i) {
            float prevWingAmplitude = prevWingAmplitudes[i];
            float wingAmplitude = wingAmplitudes[i];
            this.interpolatedWingAmplitudes[i] = prevWingAmplitude + partialTicks * (wingAmplitude - prevWingAmplitude);
        }
    }
}

