/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.model.TropicraftAgeableHierarchicalModel;
import net.tropicraft.core.common.entity.passive.GibnutEntity;

public class GibnutModel
extends TropicraftAgeableHierarchicalModel<GibnutEntity> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart legBackLeft;
    private final ModelPart legBackRight;
    private final ModelPart legFrontLeft;
    private final ModelPart legFrontRight;
    private final ModelPart earLeft;
    private final ModelPart earRight;
    private final ModelPart whiskerLeft1;
    private final ModelPart whiskerLeft2;
    private final ModelPart whiskerRight1;
    private final ModelPart whiskerRight2;

    public GibnutModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body_base");
        this.head = this.body.m_171324_("head_base");
        this.legBackLeft = this.body.m_171324_("leg_back_left");
        this.legBackRight = this.body.m_171324_("leg_back_right");
        this.legFrontLeft = this.body.m_171324_("leg_front_left");
        this.legFrontRight = this.body.m_171324_("leg_front_right");
        this.earLeft = this.head.m_171324_("ear_left");
        this.earRight = this.head.m_171324_("ear_right");
        this.whiskerLeft1 = this.head.m_171324_("whisker_left1");
        this.whiskerLeft2 = this.head.m_171324_("whisker_left2");
        this.whiskerRight1 = this.head.m_171324_("whisker_right1");
        this.whiskerRight2 = this.head.m_171324_("whisker_right2");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body_base = partdefinition.m_171599_("body_base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, -7.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)21.0f, (float)4.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition head_base = body_base.m_171599_("head_base", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-1.5f, -0.5f, -4.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-7.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition ear_right = head_base.m_171599_("ear_right", CubeListBuilder.m_171558_().m_171514_(3, 31).m_171488_(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-0.5f, (float)-0.75f, (float)-0.0289f, (float)0.2163f, (float)-0.3958f));
        PartDefinition ear_left = head_base.m_171599_("ear_left", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-0.5f, (float)-0.75f, (float)-0.0289f, (float)-0.2163f, (float)0.3958f));
        PartDefinition whisker_right1 = head_base.m_171599_("whisker_right1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)0.5f, (float)-4.0f));
        PartDefinition whisker_right1_r1 = whisker_right1.m_171599_("whisker_right1_r1", CubeListBuilder.m_171558_().m_171514_(27, 29).m_171488_(-3.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.421f, (float)0.5574f, (float)-0.3532f));
        PartDefinition whisker_right2 = head_base.m_171599_("whisker_right2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.5f, (float)0.75f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition whisker_right2_r1 = whisker_right2.m_171599_("whisker_right2_r1", CubeListBuilder.m_171558_().m_171514_(18, 29).m_171488_(-3.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.421f, (float)0.5574f, (float)-0.3532f));
        PartDefinition whisker_left1 = head_base.m_171599_("whisker_left1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)0.5f, (float)-4.0f));
        PartDefinition whisker_left1_r1 = whisker_left1.m_171599_("whisker_left1_r1", CubeListBuilder.m_171558_().m_171514_(9, 29).m_171488_(0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)0.0f, (float)-0.421f, (float)-0.5574f, (float)0.3532f));
        PartDefinition whisker_left2 = head_base.m_171599_("whisker_left2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)1.5f, (float)0.75f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition whisker_left2_r1 = whisker_left2.m_171599_("whisker_left2_r1", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.421f, (float)-0.5574f, (float)0.3532f));
        PartDefinition leg_back_left = body_base.m_171599_("leg_back_left", CubeListBuilder.m_171558_().m_171514_(15, 13).m_171488_(-0.5f, -0.5f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-1.5f, (float)-0.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition leg_back_right = body_base.m_171599_("leg_back_right", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-0.5f, -0.5f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-1.5f, (float)-0.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition leg_front_right = body_base.m_171599_("leg_front_right", CubeListBuilder.m_171558_().m_171514_(14, 21).m_171488_(-0.5f, -1.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)0.75f, (float)-6.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg_front_left = body_base.m_171599_("leg_front_left", CubeListBuilder.m_171558_().m_171514_(7, 21).m_171488_(-0.5f, -1.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)0.75f, (float)-6.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(GibnutEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        ModelAnimator.look(this.head, headYaw, headPitch);
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(limbSwing * 0.125f, limbSwingAmount);){
            this.legFrontLeft.f_104203_ = walk.eval(1.0f, 1.0f);
            this.legFrontRight.f_104203_ = walk.eval(-1.0f, 1.0f);
            this.legBackLeft.f_104203_ = walk.eval(-1.0f, 1.0f);
            this.legBackRight.f_104203_ = walk.eval(1.0f, 1.0f);
            this.body.f_104201_ += walk.eval(2.0f, 0.5f, 0.5f, 0.0f);
            this.body.f_104205_ += walk.eval(1.0f, 0.15f);
        }
        if (entity.isVibing()) {
            try (ModelAnimator.Cycle vibe = ModelAnimator.cycle(ageInTicks * 0.1f, 1.0f);){
                this.head.f_104203_ += vibe.eval(1.0f, 0.1f);
            }
        }
        try (ModelAnimator.Cycle sniff = ModelAnimator.cycle(ageInTicks, 1.0f);){
            this.head.f_104203_ += sniff.twitch(40.0f, 0.15f, -0.08f);
        }
        try (ModelAnimator.Cycle whiskers = ModelAnimator.cycle(ageInTicks * 0.3f, 0.025f);){
            this.whiskerLeft1.f_104203_ += whiskers.eval(1.0f, 1.0f, 0.25f, 0.0f);
            this.whiskerLeft2.f_104203_ += whiskers.eval(1.0f, 1.0f, 0.0f, 0.0f);
            this.whiskerRight1.f_104203_ += whiskers.eval(1.0f, 1.0f, 0.0f, 0.0f);
            this.whiskerRight2.f_104203_ += whiskers.eval(1.0f, 1.0f, 0.25f, 0.0f);
        }
        try (ModelAnimator.Cycle idle = ModelAnimator.cycle(ageInTicks, 1.0f);){
            this.earLeft.f_104203_ += idle.twitch(7.0f, 0.22f, 1.0f);
            this.earRight.f_104203_ += idle.twitch(7.0f, 0.18f, 1.0f);
        }
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, -0.09375f);
        super.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    @Override
    protected ModelPart head() {
        return this.head;
    }

    @Override
    protected ModelPart root() {
        return this.root;
    }
}

