/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.model.TropicraftAgeableHierarchicalModel;
import net.tropicraft.core.common.entity.passive.SlenderHarvestMouseEntity;

public class SlenderHarvestMouseModel<T extends SlenderHarvestMouseEntity>
extends TropicraftAgeableHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart legBackLeft;
    private final ModelPart legBackRight;
    private final ModelPart legFrontLeft;
    private final ModelPart legFrontRight;
    private final ModelPart earLeft;
    private final ModelPart earRight;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;

    public SlenderHarvestMouseModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body_base");
        this.head = this.body.m_171324_("head");
        this.legBackLeft = this.body.m_171324_("leg_back_left");
        this.legBackRight = this.body.m_171324_("leg_back_right");
        this.legFrontLeft = this.body.m_171324_("leg_front_left");
        this.legFrontRight = this.body.m_171324_("leg_front_right");
        this.earLeft = this.head.m_171324_("cute_lil_ear_left");
        this.earRight = this.head.m_171324_("cute_lil_ear_right");
        this.tail1 = this.body.m_171324_("tail1");
        this.tail2 = this.tail1.m_171324_("tail2");
        this.tail3 = this.tail2.m_171324_("tail3");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body_base = partdefinition.m_171599_("body_base", CubeListBuilder.m_171558_().m_171514_(9, 0).m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.25f, (float)1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leg_front_right = body_base.m_171599_("leg_front_right", CubeListBuilder.m_171558_().m_171514_(3, 11).m_171488_(-0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)-1.5f));
        PartDefinition leg_front_left = body_base.m_171599_("leg_front_left", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)-1.5f));
        PartDefinition leg_back_right = body_base.m_171599_("leg_back_right", CubeListBuilder.m_171558_().m_171514_(9, 11).m_171488_(-0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)1.0f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leg_back_left = body_base.m_171599_("leg_back_left", CubeListBuilder.m_171558_().m_171514_(6, 11).m_171488_(-0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = body_base.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.5f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-1.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition wee_nose = head.m_171599_("wee_nose", CubeListBuilder.m_171558_().m_171514_(12, 11).m_171488_(-0.5f, 0.25f, -0.02f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-2.0f));
        PartDefinition cute_lil_ear_right = head.m_171599_("cute_lil_ear_right", CubeListBuilder.m_171558_().m_171514_(10, 8).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.6545f, (float)-0.9599f, (float)0.0f));
        PartDefinition cute_lil_ear_left = head.m_171599_("cute_lil_ear_left", CubeListBuilder.m_171558_().m_171514_(7, 8).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.6545f, (float)0.9599f, (float)0.0f));
        PartDefinition tail1 = body_base.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(7, 5).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        ModelAnimator.look(this.head, headYaw, headPitch + 20.0f);
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(limbSwing * 0.8f, limbSwingAmount * 1.5f);){
            this.legFrontLeft.f_104203_ = walk.eval(1.0f, 1.0f);
            this.legFrontRight.f_104203_ = walk.eval(-1.0f, 1.0f);
            this.legBackLeft.f_104203_ = walk.eval(-1.0f, 1.0f);
            this.legBackRight.f_104203_ = walk.eval(1.0f, 1.0f);
            this.body.f_104201_ += walk.eval(2.0f, 0.125f, 0.5f, 0.0f);
            this.body.f_104200_ += walk.eval(1.0f, 0.125f, 0.5f, 0.0f);
            this.tail1.f_104204_ += walk.eval(1.0f, 0.2f, 0.2f, 0.0f);
            this.tail2.f_104204_ += walk.eval(1.0f, 0.2f, 0.3f, 0.0f);
            this.tail3.f_104204_ += walk.eval(1.0f, 0.4f, 0.5f, 0.0f);
        }
        try (ModelAnimator.Cycle idle = ModelAnimator.cycle(ageInTicks, 1.0f);){
            this.head.f_104203_ += idle.eval(0.3f, 0.0125f);
        }
        idle = ModelAnimator.cycle(ageInTicks, 1.0f);
        try {
            this.earLeft.f_104203_ += idle.twitch(7.0f, 0.22f, 1.0f);
            this.earRight.f_104203_ += idle.twitch(7.0f, 0.18f, 1.0f);
            this.tail3.f_104203_ += idle.twitch(15.0f, 0.15f, 0.5f);
        }
        finally {
            if (idle != null) {
                idle.close();
            }
        }
    }

    @Override
    protected ModelPart root() {
        return this.root;
    }

    @Override
    protected ModelPart head() {
        return this.head;
    }
}

