/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.common.entity.passive.ToucanEntity;

public class ToucanModel
extends HierarchicalModel<ToucanEntity> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart legLeft;
    private final ModelPart legRight;
    private final ModelPart wingLeft;
    private final ModelPart wingRight;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart beakBottom;
    private final ModelPart tailTop;
    private final ModelPart tailBottomLeft;
    private final ModelPart tailBottomRight;

    public ToucanModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body_base");
        this.legLeft = this.body.m_171324_("leg_left");
        this.legRight = this.body.m_171324_("leg_right");
        this.wingLeft = this.body.m_171324_("wing_left");
        this.wingRight = this.body.m_171324_("wing_right");
        this.neck = this.body.m_171324_("neck_base");
        this.head = this.neck.m_171324_("head_base");
        this.beakBottom = this.head.m_171324_("beak_bottom");
        this.tailTop = this.body.m_171324_("tail_top");
        this.tailBottomLeft = this.body.m_171324_("tail_bottom_left");
        this.tailBottomRight = this.body.m_171324_("tail_bottom_right");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body_base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.5f, -4.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)2.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        body.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(5, 26).m_171488_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.25f, (float)0.5f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        body.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(5, 24).m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.25f, (float)0.5f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        body.m_171599_("wing_left", CubeListBuilder.m_171558_().m_171514_(9, 12).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-1.5f, (float)-3.0f, (float)0.0f, (float)0.0436f, (float)0.0f));
        body.m_171599_("wing_right", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-1.5f, (float)-3.0f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        body.m_171599_("tail_top", CubeListBuilder.m_171558_().m_171514_(13, 7).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-0.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        body.m_171599_("tail_bottom_left", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-0.5f, (float)0.0f, (float)0.9163f, (float)0.0f, (float)0.0f));
        body.m_171599_("tail_bottom_right", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171488_(-2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-0.48f, (float)0.0f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck_base", CubeListBuilder.m_171558_().m_171514_(9, 19).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.002f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)-4.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head_base", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-1.0f, -2.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.004f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        head.m_171599_("beak_top", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        head.m_171599_("beak_bottom", CubeListBuilder.m_171558_().m_171514_(16, 19).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setupAnim(ToucanEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        this.neck.f_104203_ = (headPitch - 65.0f) * ((float)Math.PI / 180);
        this.head.f_104205_ = headYaw * ((float)Math.PI / 180);
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float flightAnimation = entity.getFlightAnimation(partialTicks);
        float walkAnimation = 1.0f - flightAnimation;
        if (flightAnimation > 0.0f) {
            this.body.f_104203_ += 0.43633232f * flightAnimation;
            this.head.f_104203_ -= 0.43633232f * flightAnimation;
            this.tailTop.f_104203_ -= 0.61086524f * flightAnimation;
            this.tailBottomLeft.f_104203_ -= 0.6981317f * flightAnimation;
            this.tailBottomRight.f_104203_ -= 0.6981317f * flightAnimation;
            this.tailBottomLeft.f_104204_ += 0.61086524f * flightAnimation;
            this.tailBottomRight.f_104204_ -= 0.61086524f * flightAnimation;
            this.legLeft.f_104203_ += 0.6981317f * flightAnimation;
            this.legRight.f_104203_ += 0.6981317f * flightAnimation;
            this.wingLeft.f_104203_ += 1.5707964f * flightAnimation;
            this.wingRight.f_104203_ += 1.5707964f * flightAnimation;
            try (ModelAnimator.Cycle fly = ModelAnimator.cycle(ageInTicks * 0.15f, flightAnimation);){
                this.body.f_104201_ += fly.eval(1.0f, 0.2f, 0.06f, 0.0f);
                this.body.f_104203_ += fly.eval(1.0f, -0.04f, 0.06f, -0.04f);
                this.tailTop.f_104203_ += fly.eval(1.0f, 0.1f, -0.2f, 0.0f);
                this.tailBottomLeft.f_104203_ += fly.eval(1.0f, 0.1f, -0.1f, 0.0f);
                this.tailBottomRight.f_104203_ += fly.eval(1.0f, 0.1f, -0.1f, 0.0f);
                this.wingLeft.f_104205_ += fly.eval(1.0f, 1.3f, -0.1f, 1.4f);
                this.wingRight.f_104205_ += fly.eval(1.0f, -1.3f, -0.1f, -1.4f);
            }
        }
        if (walkAnimation > 0.0f) {
            try (ModelAnimator.Cycle walk = ModelAnimator.cycle(limbSwing, limbSwingAmount * walkAnimation);){
                this.legLeft.f_104203_ += walk.eval(1.0f, 1.0f);
                this.legRight.f_104203_ += walk.eval(1.0f, -1.0f);
            }
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

