/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.AshenModel;
import net.tropicraft.core.common.entity.hostile.AshenEntity;

@OnlyIn(value=Dist.CLIENT)
public class AshenHeldItemLayer<T extends AshenEntity, M extends EntityModel<T>>
extends ItemInHandLayer<T, M> {
    private final AshenModel model;

    public AshenHeldItemLayer(RenderLayerParent<T, M> renderer, ItemInHandRenderer itemInHandRenderer, AshenModel model) {
        super(renderer, itemInHandRenderer);
        this.model = model;
    }

    protected ResourceLocation getTextureLocation(AshenEntity entityIn) {
        return TropicraftRenderUtils.getTextureEntity("ashen/ashen");
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int packedLightIn, T ashen, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack blowGunHand = ashen.m_21205_();
        ItemStack daggerHand = ashen.m_21206_();
        if (!blowGunHand.m_41619_() || !daggerHand.m_41619_()) {
            stack.m_85836_();
            if (this.model.f_102610_) {
                stack.m_252880_(0.0f, 0.625f, 0.0f);
                stack.m_252781_(Axis.f_252495_.m_252977_(-20.0f));
                stack.m_85841_(0.5f, 0.5f, 0.5f);
            }
            HumanoidArm side = ((AshenEntity)((Object)ashen)).m_5737_();
            this.renderHeldItem((AshenEntity)((Object)ashen), blowGunHand, side, stack, buffer, packedLightIn);
            side = side.m_20828_();
            this.renderHeldItem((AshenEntity)((Object)ashen), daggerHand, side, stack, buffer, packedLightIn);
            stack.m_85849_();
        }
    }

    private void renderHeldItem(AshenEntity entity, ItemStack itemstack, HumanoidArm handSide, PoseStack stack, MultiBufferSource buffer, int combinedLightIn) {
        if (itemstack.m_41619_()) {
            return;
        }
        if (entity.getActionState() == AshenEntity.AshenState.HOSTILE) {
            float scale = 0.5f;
            if (handSide == HumanoidArm.LEFT) {
                stack.m_85836_();
                this.model.leftArm.m_104299_(stack);
                stack.m_252880_(0.3f, -0.3f, -0.045f);
                stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
                stack.m_85841_(scale, scale, scale);
                Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)entity, itemstack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, stack, buffer, entity.m_9236_(), combinedLightIn, OverlayTexture.f_118083_, entity.m_19879_());
                stack.m_85849_();
            } else {
                stack.m_85836_();
                this.model.rightArm.m_104299_(stack);
                stack.m_252880_(-0.375f, -0.35f, -0.125f);
                stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                stack.m_85841_(scale, scale, scale);
                Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)entity, itemstack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, false, stack, buffer, entity.m_9236_(), combinedLightIn, OverlayTexture.f_118083_, entity.m_19879_());
                stack.m_85849_();
            }
        }
    }
}

