/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.scuba;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaData;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaAmbienceTicker {
    public static final SoundEvent SHALLOW_SCUBA = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("tropicraft", "scuba.shallow"));
    public static final SoundEvent DEEP_SCUBA = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("tropicraft", "scuba.deep"));
    private static SoundEvent currentSound;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null) {
            Camera renderInfo = mc.m_91290_().f_114358_;
            Entity renderViewEntity = mc.m_91288_();
            if (renderInfo != null && renderViewEntity instanceof Player) {
                Player player = (Player)renderViewEntity;
                if (renderInfo.m_167685_() == FogType.WATER && player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ScubaArmorItem) {
                    if (ScubaData.getDepth(player) < 60.0) {
                        ScubaAmbienceTicker.play(SHALLOW_SCUBA);
                        return;
                    }
                    ScubaAmbienceTicker.play(DEEP_SCUBA);
                    return;
                }
            }
        }
        ScubaAmbienceTicker.stop();
    }

    private static void play(SoundEvent sound) {
        if (currentSound != sound) {
            ScubaAmbienceTicker.stop();
            currentSound = sound;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(sound.m_11660_(), SoundSource.AMBIENT, 0.4f, 1.0f, SoundInstance.m_235150_(), true, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        }
    }

    private static void stop() {
        if (currentSound != null) {
            Minecraft.m_91087_().m_91106_().m_120386_(currentSound.m_11660_(), SoundSource.AMBIENT);
            currentSound = null;
        }
    }
}

