/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FruitingBranchBlock
extends Block
implements BonemealableBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    public static final int MAX_AGE = 2;
    private static final int GROW_CHANCE = 10;
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)14.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)2.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0);

    public FruitingBranchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_(FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> throw new UnsupportedOperationException();
        };
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) == 0) {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)AGE));
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 2;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.m_61143_(FACING);
        if (direction == facing.m_122424_()) {
            return neighborState.m_60783_((BlockGetter)level, neighborPos, facing) ? state : Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_(FACING);
        BlockPos attachPos = pos.m_121945_(facing.m_122424_());
        return level.m_8055_(attachPos).m_60783_((BlockGetter)level, attachPos, facing);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_();
        if (facing.m_122434_() == Direction.Axis.Y) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)facing);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_(FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_(FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AGE});
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 2;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
    }
}

