/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import it.unimi.dsi.fastutil.objects.Reference2ByteMap;
import it.unimi.dsi.fastutil.objects.Reference2ByteOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.block.TropicraftBlocks;

public final class MangroveRootsBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final Reference2ByteMap<BlockState> STATE_TO_KEY = new Reference2ByteOpenHashMap();
    private static final VoxelShape[] SHAPE_TABLE = MangroveRootsBlock.buildShapeTable();
    private static final int PIANGUA_GROW_CHANCE = 80;
    private static final int PIANGUA_RADIUS = 1;
    public static final BooleanProperty TALL = BooleanProperty.m_61465_((String)"tall");
    public static final BooleanProperty GROUNDED = BooleanProperty.m_61465_((String)"grounded");
    public static final EnumProperty<Connection> NORTH = EnumProperty.m_61587_((String)"north", Connection.class);
    public static final EnumProperty<Connection> EAST = EnumProperty.m_61587_((String)"east", Connection.class);
    public static final EnumProperty<Connection> SOUTH = EnumProperty.m_61587_((String)"south", Connection.class);
    public static final EnumProperty<Connection> WEST = EnumProperty.m_61587_((String)"west", Connection.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final EnumProperty<Connection>[] CONNECTIONS = new EnumProperty[]{NORTH, EAST, SOUTH, WEST};

    public MangroveRootsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TALL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)GROUNDED, (Comparable)Boolean.valueOf(false))).m_61124_(NORTH, (Comparable)((Object)Connection.NONE))).m_61124_(EAST, (Comparable)((Object)Connection.NONE))).m_61124_(SOUTH, (Comparable)((Object)Connection.NONE))).m_61124_(WEST, (Comparable)((Object)Connection.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape[] buildShapeTable() {
        VoxelShape[] table = new VoxelShape[32];
        for (int key = 0; key < table.length; ++key) {
            boolean tall = (key & 1) != 0;
            boolean north = (key >> 1 & 1) != 0;
            boolean east = (key >> 2 & 1) != 0;
            boolean south = (key >> 3 & 1) != 0;
            boolean west = (key >> 4 & 1) != 0;
            table[key] = MangroveRootsBlock.computeShapeFor(tall, north, east, south, west);
        }
        return table;
    }

    private static VoxelShape computeShapeFor(boolean tall, boolean north, boolean east, boolean south, boolean west) {
        double height = tall ? 16.0 : 10.0;
        VoxelShape shape = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)height, (double)10.0);
        if (north) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)height, (double)6.0));
        }
        if (east) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)height, (double)10.0));
        }
        if (south) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)height, (double)16.0));
        }
        if (west) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)height, (double)10.0));
        }
        return shape;
    }

    private static int shapeKey(BlockState state) {
        return ((Boolean)state.m_61143_((Property)TALL) != false ? 1 : 0) | (((Connection)((Object)state.m_61143_(NORTH))).exists() ? 2 : 0) | (((Connection)((Object)state.m_61143_(EAST))).exists() ? 4 : 0) | (((Connection)((Object)state.m_61143_(SOUTH))).exists() ? 8 : 0) | (((Connection)((Object)state.m_61143_(WEST))).exists() ? 16 : 0);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        byte key = STATE_TO_KEY.computeByteIfAbsent((Object)state, MangroveRootsBlock::shapeKey);
        return SHAPE_TABLE[key];
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return super.m_7947_(state, reader, pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getConnectedState((LevelReader)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return this.getConnectedState((LevelReader)world, currentPos);
    }

    private BlockState getConnectedState(LevelReader world, BlockPos pos) {
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_205070_(FluidTags.f_13131_)))).m_61124_((Property)GROUNDED, (Comparable)Boolean.valueOf(this.isGrounded((BlockGetter)world, pos)));
        if (!this.isTall(state = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.NORTH)))).m_61124_(EAST, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.EAST)))).m_61124_(SOUTH, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.SOUTH)))).m_61124_(WEST, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.WEST)))) && !this.canConnectUp(world, pos.m_7494_())) {
            state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)TALL, (Comparable)Boolean.valueOf(false))).m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(NORTH))).shorten()))).m_61124_(EAST, (Comparable)((Object)((Connection)((Object)state.m_61143_(EAST))).shorten()))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(SOUTH))).shorten()))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)state.m_61143_(WEST))).shorten()));
        }
        return state;
    }

    private Connection getConnectionFor(LevelReader world, BlockPos pos, Direction direction) {
        BlockPos adjacentPos = pos.m_121945_(direction);
        BlockState adjacentState = world.m_8055_(adjacentPos);
        if (this.canConnectTo(adjacentState, (BlockGetter)world, adjacentPos, direction)) {
            if (world.m_8055_(pos.m_7494_()).m_60713_((Block)this) && this.canConnectTo((BlockGetter)world, adjacentPos.m_7494_(), direction)) {
                return Connection.NONE;
            }
            if (adjacentState.m_60713_((Block)this)) {
                boolean tall = this.isAdjacentTall(world, adjacentPos, direction.m_122424_());
                return tall ? Connection.HIGH : Connection.LOW;
            }
            return Connection.HIGH;
        }
        return Connection.NONE;
    }

    private boolean isAdjacentTall(LevelReader world, BlockPos pos, Direction sourceDirection) {
        if (this.canConnectUp(world, pos.m_7494_())) {
            return true;
        }
        for (Direction direction : DIRECTIONS) {
            if (direction == sourceDirection || !this.canConnectTo((BlockGetter)world, pos.m_121945_(direction), direction)) continue;
            return true;
        }
        return false;
    }

    private boolean isTall(BlockState state) {
        int count = 0;
        if (((Connection)((Object)state.m_61143_(NORTH))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.m_61143_(EAST))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.m_61143_(SOUTH))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.m_61143_(WEST))).exists()) {
            ++count;
        }
        return count > 1;
    }

    private boolean canConnectTo(BlockGetter world, BlockPos pos, Direction direction) {
        return this.canConnectTo(world.m_8055_(pos), world, pos, direction);
    }

    private boolean canConnectTo(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (state.m_60713_((Block)this) || state.m_60783_(world, pos, direction)) && !FenceBlock.m_152463_((BlockState)state) && !(state.m_60734_() instanceof TrapDoorBlock);
    }

    private boolean canConnectUp(LevelReader world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return (state.m_60713_((Block)this) || Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)Direction.DOWN)) && !(state.m_60734_() instanceof TrapDoorBlock);
    }

    private boolean isGrounded(BlockGetter world, BlockPos pos) {
        BlockPos groundPos = pos.m_7495_();
        return world.m_8055_(groundPos).m_60783_(world, groundPos, Direction.UP);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(SOUTH)))))).m_61124_(EAST, (Comparable)((Object)((Connection)((Object)state.m_61143_(WEST)))))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(NORTH)))))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)state.m_61143_(EAST)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(EAST)))))).m_61124_(EAST, (Comparable)((Object)((Connection)((Object)state.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)state.m_61143_(NORTH)))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(WEST)))))).m_61124_(EAST, (Comparable)((Object)((Connection)((Object)state.m_61143_(NORTH)))))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(EAST)))))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)state.m_61143_(SOUTH)))));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)state.m_61143_(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((Object)((Connection)((Object)state.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)state.m_61143_(EAST)))));
            }
        }
        return super.m_6943_(state, mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TALL, GROUNDED, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)GROUNDED) != false && (Boolean)state.m_61143_((Property)TALL) != false;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(80) == 0) {
            this.tryGrowPianguas(world, pos, random);
        }
    }

    private void tryGrowPianguas(ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos soilPos = pos.m_7495_();
        if (!world.m_8055_(soilPos).m_60713_((Block)TropicraftBlocks.MUD.get())) {
            return;
        }
        BlockPos growPos = soilPos.m_7918_(random.m_188503_(3) - 1, -random.m_188503_(2), random.m_188503_(3) - 1);
        BlockState growIn = world.m_8055_(growPos);
        if (growIn.m_60713_((Block)TropicraftBlocks.MUD.get()) && !world.m_8055_(growPos.m_7494_()).m_60815_() && !this.hasNearPianguas(world, growPos)) {
            world.m_46597_(growPos, ((Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get()).m_49966_());
        }
    }

    private boolean hasNearPianguas(ServerLevel world, BlockPos source) {
        Block mudWithPianguas = (Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get();
        BlockPos minSpacingPos = source.m_7918_(-1, -1, -1);
        BlockPos maxSpacingPos = source.m_7918_(1, 0, 1);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minSpacingPos, (BlockPos)maxSpacingPos)) {
            if (!world.m_8055_(pos).m_60713_(mudWithPianguas)) continue;
            return true;
        }
        return false;
    }

    public static enum Connection implements StringRepresentable
    {
        NONE("none"),
        HIGH("high"),
        LOW("low");

        private final String key;

        private Connection(String key) {
            this.key = key;
        }

        public boolean exists() {
            return this != NONE;
        }

        public String m_7912_() {
            return this.key;
        }

        public Connection shorten() {
            return this == HIGH ? LOW : this;
        }
    }
}

