/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftItemRenderers;
import net.tropicraft.core.client.tileentity.AirCompressorRenderer;
import net.tropicraft.core.client.tileentity.BambooChestRenderer;
import net.tropicraft.core.client.tileentity.DrinkMixerRenderer;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.BambooChestBlock;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.BoardwalkBlock;
import net.tropicraft.core.common.block.BongoDrumBlock;
import net.tropicraft.core.common.block.CoconutBlock;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.CustomSeagrassBlock;
import net.tropicraft.core.common.block.CustomTallSeagrassBlock;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.FruitingBranchBlock;
import net.tropicraft.core.common.block.FruitingVineBlock;
import net.tropicraft.core.common.block.GrowableDoublePlantBlock;
import net.tropicraft.core.common.block.GrowableSinglePlantBlock;
import net.tropicraft.core.common.block.MahoganyNutBlock;
import net.tropicraft.core.common.block.MangroveLeavesBlock;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.block.PapayaBlock;
import net.tropicraft.core.common.block.PineappleBlock;
import net.tropicraft.core.common.block.PortalWaterBlock;
import net.tropicraft.core.common.block.PropaguleBlock;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.ScientificNameBlock;
import net.tropicraft.core.common.block.SifterBlock;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftLeavesBlock;
import net.tropicraft.core.common.block.TropicraftLogBlock;
import net.tropicraft.core.common.block.TropicraftTrees;
import net.tropicraft.core.common.block.TropicraftWoodTypes;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;
import net.tropicraft.core.common.block.jigarbov.JigarbovTorchType;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;
import net.tropicraft.core.common.block.tileentity.SifterBlockEntity;
import net.tropicraft.core.common.block.tileentity.VolcanoBlockEntity;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.mixin.BlockEntityTypeAccessor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class TropicraftBlocks {
    private static final Registrate REGISTRATE = Tropicraft.registrate();
    private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    private static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_285888_(HAS_SILK_TOUCH);
    private static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    private static final float[] FRUIT_SAPLING_RATES = new float[]{0.1f, 0.125f, 0.16666667f, 0.2f};
    private static final float[] SAPLING_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] RARE_SAPLING_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    public static final BlockEntry<PortalWaterBlock> TELEPORT_WATER;
    public static final BlockEntry<LiquidBlock> PORTAL_WATER;
    public static final BlockEntry<Block> CHUNK;
    public static final BlockEntry<DropExperienceBlock> AZURITE_ORE;
    public static final BlockEntry<DropExperienceBlock> EUDIALYTE_ORE;
    public static final BlockEntry<DropExperienceBlock> MANGANESE_ORE;
    public static final BlockEntry<DropExperienceBlock> SHAKA_ORE;
    public static final BlockEntry<DropExperienceBlock> ZIRCON_ORE;
    public static final BlockEntry<Block> AZURITE_BLOCK;
    public static final BlockEntry<Block> EUDIALYTE_BLOCK;
    public static final BlockEntry<Block> MANGANESE_BLOCK;
    public static final BlockEntry<Block> SHAKA_BLOCK;
    public static final BlockEntry<Block> ZIRCON_BLOCK;
    public static final BlockEntry<Block> ZIRCONIUM_BLOCK;
    public static final Map<TropicraftFlower, BlockEntry<TropicsFlowerBlock>> FLOWERS;
    public static final BlockEntry<BlockTropicraftSand> PURIFIED_SAND;
    public static final BlockEntry<Block> PACKED_PURIFIED_SAND;
    public static final BlockEntry<BlockTropicraftSand> CORAL_SAND;
    public static final BlockEntry<BlockTropicraftSand> FOAMY_SAND;
    public static final BlockEntry<VolcanicSandBlock> VOLCANIC_SAND;
    public static final BlockEntry<BlockTropicraftSand> MINERAL_SAND;
    public static final BlockEntry<Block> MUD;
    public static final BlockEntry<Block> MUD_WITH_PIANGUAS;
    public static final BlockEntry<RotatedPillarBlock> BAMBOO_BUNDLE;
    public static final BlockEntry<RotatedPillarBlock> THATCH_BUNDLE;
    public static final BlockEntry<Block> MAHOGANY_PLANKS;
    public static final BlockEntry<Block> PALM_PLANKS;
    public static final BlockEntry<RotatedPillarBlock> MAHOGANY_LOG;
    public static final BlockEntry<RotatedPillarBlock> PALM_LOG;
    public static final BlockEntry<RotatedPillarBlock> MAHOGANY_WOOD;
    public static final BlockEntry<RotatedPillarBlock> PALM_WOOD;
    public static final BlockEntry<StairBlock> PALM_STAIRS;
    public static final BlockEntry<StairBlock> MAHOGANY_STAIRS;
    public static final BlockEntry<StairBlock> THATCH_STAIRS;
    public static final BlockEntry<StairBlock> THATCH_STAIRS_FUZZY;
    public static final BlockEntry<StairBlock> BAMBOO_STAIRS;
    public static final BlockEntry<StairBlock> CHUNK_STAIRS;
    public static final BlockEntry<CoconutBlock> COCONUT;
    public static final BlockEntry<SlabBlock> BAMBOO_SLAB;
    public static final BlockEntry<SlabBlock> THATCH_SLAB;
    public static final BlockEntry<SlabBlock> CHUNK_SLAB;
    public static final BlockEntry<SlabBlock> PALM_SLAB;
    public static final BlockEntry<SlabBlock> MAHOGANY_SLAB;
    public static final BlockEntry<SaplingBlock> GRAPEFRUIT_SAPLING;
    public static final BlockEntry<SaplingBlock> LEMON_SAPLING;
    public static final BlockEntry<SaplingBlock> LIME_SAPLING;
    public static final BlockEntry<SaplingBlock> ORANGE_SAPLING;
    public static final BlockEntry<SaplingBlock> PAPAYA_SAPLING;
    public static final BlockEntry<SaplingBlock> MAHOGANY_SAPLING;
    public static final BlockEntry<SaplingBlock> PALM_SAPLING;
    public static final BlockEntry<LeavesBlock> MAHOGANY_LEAVES;
    public static final BlockEntry<LeavesBlock> PALM_LEAVES;
    public static final BlockEntry<LeavesBlock> KAPOK_LEAVES;
    public static final BlockEntry<LeavesBlock> FRUIT_LEAVES;
    public static final BlockEntry<LeavesBlock> GRAPEFRUIT_LEAVES;
    public static final BlockEntry<LeavesBlock> LEMON_LEAVES;
    public static final BlockEntry<LeavesBlock> LIME_LEAVES;
    public static final BlockEntry<LeavesBlock> ORANGE_LEAVES;
    public static final BlockEntry<LeavesBlock> PAPAYA_LEAVES;
    public static final BlockEntry<LeavesBlock> WHITE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> RED_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> BLUE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> PURPLE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> YELLOW_FLOWERING_LEAVES;
    public static final BlockEntry<FruitingVineBlock> PASSIONFRUIT_VINE;
    public static final BlockEntry<RotatedPillarBlock> PAPAYA_LOG;
    public static final BlockEntry<RotatedPillarBlock> PAPAYA_WOOD;
    public static final BlockEntry<SaplingBlock> PLANTAIN_SAPLING;
    public static final BlockEntry<RotatedPillarBlock> PLANTAIN_STEM;
    public static final BlockEntry<LeavesBlock> PLANTAIN_LEAVES;
    public static final BlockEntry<Block> GREEN_PLANTAIN_BUNCH;
    public static final BlockEntry<Block> YELLOW_PLANTAIN_BUNCH;
    public static final BlockEntry<SaplingBlock> JOCOTE_SAPLING;
    public static final BlockEntry<RotatedPillarBlock> JOCOTE_LOG;
    public static final BlockEntry<LeavesBlock> JOCOTE_LEAVES;
    public static final BlockEntry<FruitingBranchBlock> JOCOTE_BRANCH;
    public static final BlockEntry<MahoganyNutBlock> MAHOGANY_NUT;
    public static final BlockEntry<RotatedPillarBlock> RED_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> RED_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> RED_MANGROVE_ROOTS;
    public static final BlockEntry<RotatedPillarBlock> LIGHT_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> LIGHT_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> LIGHT_MANGROVE_ROOTS;
    public static final BlockEntry<RotatedPillarBlock> BLACK_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> BLACK_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> BLACK_MANGROVE_ROOTS;
    public static final BlockEntry<MangroveLeavesBlock> RED_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> TALL_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> TEA_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> BLACK_MANGROVE_LEAVES;
    public static final BlockEntry<PropaguleBlock> RED_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> TALL_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> TEA_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> BLACK_MANGROVE_PROPAGULE;
    public static final BlockEntry<RotatedPillarBlock> STRIPPED_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> STRIPPED_MANGROVE_WOOD;
    public static final BlockEntry<Block> MANGROVE_PLANKS;
    public static final BlockEntry<StairBlock> MANGROVE_STAIRS;
    public static final BlockEntry<SlabBlock> MANGROVE_SLAB;
    public static final BlockEntry<FenceBlock> MANGROVE_FENCE;
    public static final BlockEntry<FenceGateBlock> MANGROVE_FENCE_GATE;
    public static final BlockEntry<DoorBlock> MANGROVE_DOOR;
    public static final BlockEntry<TrapDoorBlock> MANGROVE_TRAPDOOR;
    public static final BlockEntry<ButtonBlock> MANGROVE_BUTTON;
    public static final BlockEntry<ButtonBlock> MAHOGANY_BUTTON;
    public static final BlockEntry<ButtonBlock> PALM_BUTTON;
    public static final BlockEntry<ButtonBlock> BAMBOO_BUTTON;
    public static final BlockEntry<ButtonBlock> THATCH_BUTTON;
    public static final BlockEntry<PressurePlateBlock> MANGROVE_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> MAHOGANY_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> PALM_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> BAMBOO_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> THATCH_PRESSURE_PLATE;
    public static final BlockEntry<StandingSignBlock> MAHOGANY_SIGN;
    public static final BlockEntry<StandingSignBlock> PALM_SIGN;
    public static final BlockEntry<StandingSignBlock> BAMBOO_SIGN;
    public static final BlockEntry<StandingSignBlock> THATCH_SIGN;
    public static final BlockEntry<StandingSignBlock> MANGROVE_SIGN;
    public static final BlockEntry<WallSignBlock> MAHOGANY_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> PALM_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> BAMBOO_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> THATCH_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> MANGROVE_WALL_SIGN;
    public static final BlockEntry<ReedsBlock> REEDS;
    public static final BlockEntry<PapayaBlock> PAPAYA;
    public static final BlockEntry<FenceBlock> BAMBOO_FENCE;
    public static final BlockEntry<FenceBlock> THATCH_FENCE;
    public static final BlockEntry<FenceBlock> CHUNK_FENCE;
    public static final BlockEntry<FenceBlock> PALM_FENCE;
    public static final BlockEntry<FenceBlock> MAHOGANY_FENCE;
    public static final BlockEntry<FenceGateBlock> BAMBOO_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> THATCH_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> CHUNK_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> PALM_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> MAHOGANY_FENCE_GATE;
    public static final BlockEntry<WallBlock> CHUNK_WALL;
    public static final BlockEntry<DoorBlock> BAMBOO_DOOR;
    public static final BlockEntry<DoorBlock> PALM_DOOR;
    public static final BlockEntry<DoorBlock> MAHOGANY_DOOR;
    public static final BlockEntry<DoorBlock> THATCH_DOOR;
    public static final BlockEntry<TrapDoorBlock> BAMBOO_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> PALM_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> MAHOGANY_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> THATCH_TRAPDOOR;
    public static final BlockEntry<TallFlowerBlock> IRIS;
    public static final BlockEntry<PineappleBlock> PINEAPPLE;
    public static final BlockEntry<BongoDrumBlock> SMALL_BONGO_DRUM;
    public static final BlockEntry<BongoDrumBlock> MEDIUM_BONGO_DRUM;
    public static final BlockEntry<BongoDrumBlock> LARGE_BONGO_DRUM;
    public static final BlockEntry<LadderBlock> BAMBOO_LADDER;
    public static final BlockEntry<BoardwalkBlock> BAMBOO_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> PALM_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> MAHOGANY_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> MANGROVE_BOARDWALK;
    public static final BlockEntry<BambooChestBlock> BAMBOO_CHEST;
    public static final BlockEntityEntry<BambooChestBlockEntity> BAMBOO_CHEST_ENTITY;
    public static final BlockEntry<SifterBlock> SIFTER;
    public static final BlockEntityEntry<SifterBlockEntity> SIFTER_ENTITY;
    public static final BlockEntry<DrinkMixerBlock> DRINK_MIXER;
    public static final BlockEntityEntry<DrinkMixerBlockEntity> DRINK_MIXER_ENTITY;
    public static final BlockEntry<AirCompressorBlock> AIR_COMPRESSOR;
    public static final BlockEntityEntry<AirCompressorBlockEntity> AIR_COMPRESSOR_ENTITY;
    public static final BlockEntry<VolcanoBlock> VOLCANO;
    public static final BlockEntityEntry<VolcanoBlockEntity> VOLCANO_ENTITY;
    public static final BlockEntry<TikiTorchBlock> TIKI_TORCH;
    public static final BlockEntry<FlowerPotBlock> BAMBOO_FLOWER_POT;
    public static final BlockEntry<CoffeeBushBlock> COFFEE_BUSH;
    public static final BlockEntry<GrowableSinglePlantBlock> GOLDEN_LEATHER_FERN;
    public static final BlockEntry<GrowableDoublePlantBlock> TALL_GOLDEN_LEATHER_FERN;
    public static final BlockEntry<HugePlantBlock> LARGE_GOLDEN_LEATHER_FERN;
    public static final BlockEntry<CustomSeagrassBlock> EEL_GRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_EEL_GRASS;
    public static final BlockEntry<CustomSeagrassBlock> FLOWERING_EEL_GRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> FLOWERING_TALL_EEL_GRASS;
    public static final BlockEntry<ScientificNameBlock> MATTED_EEL_GRASS;
    public static final BlockEntry<ScientificNameBlock> EEL_GRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> FERN_SEAGRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_FERN_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> MATTED_FERN_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> FERN_SEAGRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> SICKLE_SEAGRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_SICKLE_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> MATTED_SICKLE_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> SICKLE_SEAGRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> NOODLE_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> MATTED_NOODLE_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> NOODLE_SEAGRASS_BLOCK;
    private static final Set<BlockEntry<? extends Block>> POTTABLE_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> BAMBOO_POTTED_TROPICS_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> VANILLA_POTTED_TROPICS_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> BAMBOO_POTTED_VANILLA_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> ALL_POTTED_PLANTS;
    public static final Map<JigarbovTorchType, BlockEntry<? extends RedstoneWallTorchBlock>> JIGARBOV_WALL_TORCHES;

    private static BlockBuilder<DropExperienceBlock, Registrate> ore(String name, MapColor color) {
        return (BlockBuilder)REGISTRATE.block(name, DropExperienceBlock::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60978_(3.0f).m_284180_(color)).tag(new TagKey[]{BlockTags.f_144282_, Tags.Blocks.ORES}).item().tag(new TagKey[]{Tags.Items.ORES}).build();
    }

    private static BlockBuilder<DropExperienceBlock, Registrate> ore(String name, Supplier<Item> gem, MapColor color) {
        return REGISTRATE.block(name, DropExperienceBlock::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60978_(3.0f).m_284180_(color)).loot((loot, block) -> loot.m_247577_((Block)block, RegistrateBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)loot.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)gem.get())).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))))))).tag(new TagKey[]{BlockTags.f_144282_, Tags.Blocks.ORES}).simpleItem();
    }

    private static BlockBuilder<Block, Registrate> oreStorageBlock(String name, MapColor color, ItemEntry<Item> ingredient) {
        return REGISTRATE.block(name, Block::new).properties(p -> p.m_60999_().m_284180_(color).m_60918_(SoundType.f_56743_).m_155954_(5.0f).m_155956_(6.0f)).tag(new TagKey[]{BlockTags.f_144282_}).recipe((ctx, prov) -> prov.storage((com.tterrag.registrate.util.nullness.NonNullSupplier)ingredient, RecipeCategory.BUILDING_BLOCKS, (com.tterrag.registrate.util.nullness.NonNullSupplier)ctx)).simpleItem();
    }

    private static BlockEntry<Block> plantainBunch(String name, Supplier<ItemEntry<Item>> item) {
        return REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.f_50186_).properties(p -> p.m_60918_(SoundType.f_56719_).m_60978_(0.5f)).tag(new TagKey[]{BlockTags.f_144281_}).loot((tables, block) -> tables.m_247577_(block, tables.m_245142_(block, (ItemLike)((ItemEntry)item.get()).get(), (NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)))).simpleItem().register();
    }

    private static BlockBuilder<BongoDrumBlock, Registrate> bongoDrum(String name, BongoDrumBlock.Size size) {
        return REGISTRATE.block(name, p -> new BongoDrumBlock(size, (BlockBehaviour.Properties)p)).properties(p -> p.m_284180_(MapColor.f_283919_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_().m_280658_(NoteBlockInstrument.BASS)).tag(new TagKey[]{TropicraftTags.Blocks.BONGOS}).blockstate((ctx, prov) -> {
            AABB bb = size.shape.m_83215_();
            prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().cubeBottomTop(ctx.getName(), prov.modLoc("block/bongo_side"), prov.modLoc("block/bongo_bottom"), prov.modLoc("block/bongo_top"))).element().from((float)bb.f_82288_ * 16.0f, (float)bb.f_82289_ * 16.0f, (float)bb.f_82290_ * 16.0f).to((float)bb.f_82291_ * 16.0f, (float)bb.f_82292_ * 16.0f, (float)bb.f_82293_ * 16.0f).allFaces((dir, face) -> face.texture(dir.m_122434_().m_122479_() ? "#side" : (dir == Direction.DOWN ? "#bottom" : "#top")).cullface((Direction)(dir.m_122434_().m_122478_() ? dir : null))).end());
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_(StringUtils.repeat((char)'T', (int)size.recipeColumns)).m_126130_(StringUtils.repeat((char)'B', (int)size.recipeColumns)).m_126130_(StringUtils.repeat((char)'B', (int)size.recipeColumns)).m_126127_(Character.valueOf('T'), (ItemLike)TropicraftItems.IGUANA_LEATHER.get()).m_126127_(Character.valueOf('B'), (ItemLike)MAHOGANY_PLANKS.get()).m_126145_("tropicraft:bongos").m_126132_("has_" + prov.safeName((ItemLike)TropicraftItems.IGUANA_LEATHER.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.IGUANA_LEATHER.get()))).m_176498_((Consumer)prov)).simpleItem();
    }

    private static BlockBuilder<CustomSeagrassBlock, Registrate> seagrass(String name, String scientificName, @Nullable Supplier<BlockEntry<? extends TallSeagrassBlock>> tall) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new CustomSeagrassBlock((BlockBehaviour.Properties)p, scientificName, () -> TropicraftBlocks.lambda$seagrass$221((Supplier)tall))).initialProperties(() -> Blocks.f_50037_).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears((Block)block))).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> {
            ResourceLocation texture = prov.blockTexture((Block)ctx.get());
            prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.mcLoc("template_seagrass"))).texture("texture", texture)).texture("particle", texture));
        }).item().model(TropicraftBlocks::blockSprite).build();
    }

    private static BlockBuilder<CustomTallSeagrassBlock, Registrate> tallSeagrass(String name, String scientificName, BlockEntry<? extends SeagrassBlock> normal) {
        return REGISTRATE.block(name, p -> new CustomTallSeagrassBlock((BlockBehaviour.Properties)p, scientificName, (NonNullSupplier<? extends SeagrassBlock>)((NonNullSupplier)() -> ((BlockEntry)normal).get()))).initialProperties(() -> Blocks.f_50037_).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears((Block)normal.get()))).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> {
            ModelBuilder top = ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_top", prov.mcLoc("template_seagrass"))).texture("texture", prov.modLoc("block/" + ctx.getName() + "_top"))).texture("particle", prov.modLoc("block/" + ctx.getName() + "_top"));
            ModelBuilder bottom = ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_bottom", prov.mcLoc("template_seagrass"))).texture("texture", prov.modLoc("block/" + ctx.getName() + "_bottom"))).texture("particle", prov.modLoc("block/" + ctx.getName() + "_bottom"));
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)top).addModel()).condition((Property)TallSeagrassBlock.f_154740_, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.UPPER}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)bottom).addModel()).condition((Property)TallSeagrassBlock.f_154740_, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.LOWER}).end();
        });
    }

    private static BlockBuilder<ScientificNameBlock, Registrate> seagrassBlock(String name, String scientificName) {
        return REGISTRATE.block(name + "_block", p -> new ScientificNameBlock((BlockBehaviour.Properties)p, scientificName)).initialProperties(() -> Blocks.f_49992_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/matted_" + name + "_top")))).simpleItem();
    }

    private static BlockBuilder<ScientificNameBlock, Registrate> mattedSeagrassBlock(String name, String scientificName) {
        return REGISTRATE.block(name, p -> new ScientificNameBlock((BlockBehaviour.Properties)p, scientificName)).initialProperties(() -> Blocks.f_49992_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeBottomTop(ctx.getName(), prov.modLoc("block/" + ctx.getName() + "_side"), prov.modLoc("block/" + PURIFIED_SAND.getId().m_135815_()), prov.modLoc("block/" + ctx.getName() + "_top")))).simpleItem();
    }

    private static BlockEntry<FlowerPotBlock> bambooPot(String name, Supplier<? extends Block> plant) {
        return REGISTRATE.block(name, p -> new FlowerPotBlock(BAMBOO_FLOWER_POT, plant, p)).properties(p -> p.m_60913_(0.2f, 5.0f).m_60918_(SoundType.f_56754_).m_278166_(PushReaction.DESTROY)).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.pottedPlantLoot(loot, block))).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13045_}).blockstate((ctx, prov) -> TropicraftBlocks.flowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, BAMBOO_FLOWER_POT, prov.modLoc("block/bamboo_side"))).register();
    }

    private static BlockEntry<FlowerPotBlock> vanillaPot(String name, Supplier<? extends Block> plant) {
        return REGISTRATE.block(name, p -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, plant, p)).initialProperties(() -> Blocks.f_50276_).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.pottedPlantLoot(loot, block))).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13045_}).blockstate((ctx, prov) -> TropicraftBlocks.flowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, () -> Blocks.f_50276_, new ResourceLocation("block/flower_pot"))).register();
    }

    private static void flowerPot(DataGenContext<Block, ? extends FlowerPotBlock> ctx, RegistrateBlockstateProvider prov, Supplier<? extends Block> empty, ResourceLocation particle) {
        Block flower = ((FlowerPotBlock)ctx.get()).m_53560_();
        boolean isVanilla = flower.m_204297_().m_205785_().m_135782_().m_135827_().equals("minecraft");
        String flowerName = TropicraftBlocks.name((ItemLike)flower);
        String parent = flower == Blocks.f_50016_ ? "flower_pot" : (!isVanilla ? "flower_pot_cross" : "block/potted_" + flowerName);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), parent)).texture("flowerpot", prov.blockTexture(empty.get()))).texture("dirt", prov.mcLoc("block/dirt"))).texture("particle", prov.modLoc("block/bamboo_side"));
        if (!isVanilla) {
            if (flower instanceof TropicsFlowerBlock) {
                model.texture("plant", prov.modLoc("block/flower/" + flowerName));
            } else if (flower instanceof TallFlowerBlock) {
                model.texture("plant", prov.modLoc("block/" + flowerName + "_top"));
            } else {
                model.texture("plant", prov.blockTexture(flower));
            }
        }
        prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
    }

    private static LootTable.Builder pottedPlantLoot(RegistrateBlockLootTables loot, FlowerPotBlock fullPot) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)loot.m_247733_((ItemLike)fullPot.getEmptyPot(), (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)fullPot.getEmptyPot())))).m_79161_((LootPool.Builder)loot.m_247733_((ItemLike)fullPot.m_53560_(), (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)fullPot.m_53560_()))));
    }

    private static BlockBuilder<StairBlock, Registrate> stoneStairs(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.stairs(name, block, (TagKey<Block>)BlockTags.f_13030_, (TagKey<Item>)ItemTags.f_13138_).recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, null, true)).tag(new TagKey[]{BlockTags.f_144282_});
    }

    private static BlockBuilder<StairBlock, Registrate> woodenStairs(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.stairs(name, block, (TagKey<Block>)BlockTags.f_13096_, (TagKey<Item>)ItemTags.f_13174_).recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "wooden_stairs", false)).tag(new TagKey[]{BlockTags.f_144280_});
    }

    private static BlockBuilder<StairBlock, Registrate> stairs(String name, BlockEntry<? extends Block> block, TagKey<Block> blockTag, TagKey<Item> itemTag) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new StairBlock(() -> ((Block)block.get()).m_49966_(), p)).initialProperties(block).tag(new TagKey[]{blockTag}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), prov.blockTexture((Block)block.get()))).item().tag(new TagKey[]{itemTag}).build();
    }

    private static BlockBuilder<SlabBlock, Registrate> stoneSlab(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.slab(name, block, (TagKey<Block>)BlockTags.f_13031_, (TagKey<Item>)ItemTags.f_13139_).recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, null, true)).tag(new TagKey[]{BlockTags.f_144282_});
    }

    private static BlockBuilder<SlabBlock, Registrate> woodenSlab(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.slab(name, block, (TagKey<Block>)BlockTags.f_13097_, (TagKey<Item>)ItemTags.f_13175_).recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "wooden_slab", false)).tag(new TagKey[]{BlockTags.f_144280_});
    }

    private static BlockBuilder<SlabBlock, Registrate> slab(String name, BlockEntry<? extends Block> block, TagKey<Block> blockTag, TagKey<Item> itemTag) {
        return (BlockBuilder)REGISTRATE.block(name, SlabBlock::new).initialProperties(block).loot((loot, slab) -> loot.m_247577_((Block)slab, loot.m_247233_((Block)slab))).tag(new TagKey[]{blockTag}).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), block.getId(), prov.blockTexture((Block)block.get()))).item().tag(new TagKey[]{itemTag}).build();
    }

    private static BlockBuilder<ButtonBlock, Registrate> woodButton(String name, BlockEntry<? extends Block> block, String texture) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new ButtonBlock(p, BlockSetType.f_271198_, 30, true)).initialProperties(block).properties(p -> p.m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY)).tag(new TagKey[]{BlockTags.f_13092_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.get(), prov.modLoc("block/" + texture))).recipe((ctx, prov) -> RegistrateRecipeProvider.m_176658_((ItemLike)((ItemLike)ctx.get()), (Ingredient)DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0])).m_126132_("has_" + prov.safeName((ItemLike)block.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)block.get()))).m_126145_("wooden_button").m_176498_((Consumer)prov)).item().model((ctx, prov) -> prov.buttonInventory(ctx.getName(), prov.modLoc("block/" + texture))).tag(new TagKey[]{ItemTags.f_13170_}).build();
    }

    private static BlockBuilder<PressurePlateBlock, Registrate> pressurePlate(String name, BlockEntry<? extends Block> block, String texture) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, p, BlockSetType.f_271198_)).initialProperties(block).properties(p -> p.m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(0.5f).m_278183_().m_278166_(PushReaction.DESTROY)).tag(new TagKey[]{BlockTags.f_13100_, BlockTags.f_144280_}).recipe((ctx, prov) -> RegistrateRecipeProvider.m_247347_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ctx.get()), (Ingredient)DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0])).m_126132_("has_" + prov.safeName((ItemLike)block.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)block.get()))).m_126145_("wooden_pressure_plate").m_176498_((Consumer)prov)).blockstate((ctx, prov) -> prov.pressurePlateBlock((PressurePlateBlock)ctx.get(), prov.modLoc("block/" + texture))).item().model((ctx, prov) -> prov.pressurePlate(ctx.getName(), prov.modLoc("block/" + texture))).build();
    }

    private static BlockBuilder<StandingSignBlock, Registrate> standingSign(WoodType woodType, Supplier<? extends Item> item, String texture) {
        String woodName = new ResourceLocation(woodType.f_61839_()).m_135815_();
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(woodName + "_sign", p -> new StandingSignBlock(p, woodType)).initialProperties(() -> Blocks.f_50095_).tag(new TagKey[]{BlockTags.f_13066_, BlockTags.f_144280_}).blockstate((ctx, prov) -> {
            BlockModelBuilder model = (BlockModelBuilder)prov.models().sign(woodType.f_61839_() + "_sign", prov.modLoc("block/" + texture));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).loot((loot, b) -> loot.m_246125_((Block)b, (ItemLike)item.get())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).onRegisterAfter(Registries.f_256922_, b -> TropicraftBlocks.extendBlockEntity(BlockEntityType.f_58924_, (Block)b));
    }

    private static BlockBuilder<WallSignBlock, Registrate> wallSign(WoodType woodType, Supplier<? extends Item> item, String texture) {
        String woodName = new ResourceLocation(woodType.f_61839_()).m_135815_();
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(woodName + "_wall_sign", p -> new WallSignBlock(p, woodType)).initialProperties(() -> Blocks.f_50158_).tag(new TagKey[]{BlockTags.f_13067_, BlockTags.f_144280_}).blockstate((ctx, prov) -> {
            BlockModelBuilder model = (BlockModelBuilder)prov.models().sign(woodType.f_61839_() + "_sign", prov.modLoc("block/" + texture));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).loot((loot, b) -> loot.m_246125_((Block)b, (ItemLike)item.get())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).onRegisterAfter(Registries.f_256922_, b -> TropicraftBlocks.extendBlockEntity(BlockEntityType.f_58924_, (Block)b));
    }

    @SafeVarargs
    private static BlockBuilder<SaplingBlock, Registrate> sapling(String name, AbstractTreeGrower tree, final Supplier<? extends Block> ... validPlantBlocks) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new SaplingBlock(tree, (BlockBehaviour.Properties)p){

            public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
                if (super.m_7898_(state, level, pos)) {
                    return true;
                }
                BlockPos ground = pos.m_7495_();
                return this.m_6266_(level.m_8055_(ground), (BlockGetter)level, ground);
            }

            protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
                Block block = state.m_60734_();
                if (super.m_6266_(state, level, pos)) {
                    return true;
                }
                return Arrays.stream(validPlantBlocks).map(Supplier::get).anyMatch(b -> b == block);
            }
        }).initialProperties(() -> Blocks.f_50746_).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13104_}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross(ctx.getName(), prov.blockTexture((Block)ctx.get())))).item().model(TropicraftBlocks::blockSprite).tag(new TagKey[]{ItemTags.f_13180_}).build();
    }

    private static BlockBuilder<LeavesBlock, Registrate> leaves(String name, BlockEntry<SaplingBlock> sapling, float[] saplingRates, boolean decay) {
        return (BlockBuilder)REGISTRATE.block(name, decay ? LeavesBlock::new : TropicraftLeavesBlock::new).initialProperties(() -> Blocks.f_50050_).loot((loot, block) -> loot.m_247577_((Block)block, loot.m_246047_((Block)block, (Block)sapling.get(), saplingRates))).tag(new TagKey[]{BlockTags.f_13035_, BlockTags.f_144281_}).item().tag(new TagKey[]{ItemTags.f_13143_}).build();
    }

    private static BlockBuilder<LeavesBlock, Registrate> leaves(String name, boolean decay) {
        return (BlockBuilder)REGISTRATE.block(name, decay ? LeavesBlock::new : TropicraftLeavesBlock::new).initialProperties(() -> Blocks.f_50050_).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears((Block)block).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)loot.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))))).tag(new TagKey[]{BlockTags.f_13035_, BlockTags.f_144281_}).item().tag(new TagKey[]{ItemTags.f_13143_}).build();
    }

    private static BlockBuilder<LeavesBlock, Registrate> fruitLeaves(String name, Supplier<SaplingBlock> sapling, Supplier<? extends Item> fruit) {
        return (BlockBuilder)REGISTRATE.block(name, LeavesBlock::new).initialProperties(() -> Blocks.f_50050_).loot((loot, block) -> loot.m_247577_((Block)block, loot.m_246047_((Block)block, (Block)sapling.get(), FRUIT_SAPLING_RATES).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_((LootPoolEntryContainer.Builder)loot.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)fruit.get()))))))).tag(new TagKey[]{BlockTags.f_13035_, BlockTags.f_144281_}).item().tag(new TagKey[]{ItemTags.f_13143_}).build();
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> log(String name, MapColor topColor, MapColor sideColor) {
        return TropicraftBlocks.log(name, topColor, sideColor, null);
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> log(String name, MapColor topColor, MapColor sideColor, @Nullable Supplier<? extends RotatedPillarBlock> strippedLog) {
        return (BlockBuilder)REGISTRATE.block(name, p -> strippedLog != null ? new TropicraftLogBlock((BlockBehaviour.Properties)p, strippedLog) : new RotatedPillarBlock(p)).properties(p -> TropicraftBlocks.rotatedPillarProperties(topColor, sideColor).m_60918_(SoundType.f_56736_).m_60978_(2.0f).m_278183_().m_280658_(NoteBlockInstrument.BASS)).tag(new TagKey[]{BlockTags.f_13106_, BlockTags.f_13105_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.logBlock((RotatedPillarBlock)ctx.get())).item().tag(new TagKey[]{ItemTags.f_13182_, ItemTags.f_13181_}).build();
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> wood(String name, MapColor color, BlockEntry<? extends RotatedPillarBlock> bark) {
        return TropicraftBlocks.wood(name, color, bark, null);
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> wood(String name, MapColor color, BlockEntry<? extends RotatedPillarBlock> bark, @Nullable Supplier<? extends RotatedPillarBlock> stripped) {
        return (BlockBuilder)REGISTRATE.block(name, p -> stripped != null ? new TropicraftLogBlock((BlockBehaviour.Properties)p, stripped) : new RotatedPillarBlock(p)).properties(p -> p.m_60918_(SoundType.f_56736_).m_284180_(color).m_60978_(2.0f).m_278183_().m_280658_(NoteBlockInstrument.BASS)).tag(new TagKey[]{BlockTags.f_13106_, BlockTags.f_13105_, BlockTags.f_144280_}).blockstate((ctx, prov) -> {
            ResourceLocation barkTexture = prov.blockTexture((Block)bark.get());
            prov.axisBlock((RotatedPillarBlock)ctx.get(), barkTexture, barkTexture);
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)bark.get()).m_126145_("bark").m_126132_("has_log", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Blocks.f_50003_)).m_176498_((Consumer)prov)).item().tag(new TagKey[]{ItemTags.f_13182_, ItemTags.f_13181_}).build();
    }

    private static BlockBuilder<MangroveRootsBlock, Registrate> mangroveRoots(String name) {
        return (BlockBuilder)REGISTRATE.block(name, MangroveRootsBlock::new).properties(p -> p.m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60955_().m_60924_((state, world, pos) -> false).m_60982_((state, world, pos) -> true)).addLayer(() -> RenderType::m_110457_).tag(new TagKey[]{TropicraftTags.Blocks.ROOTS, BlockTags.f_144280_}).blockstate((ctx, prov) -> {
            ResourceLocation roots = prov.modLoc("block/" + name);
            ModelBuilder stem = ((BlockModelBuilder)prov.models().withExistingParent(name + "_stem", prov.modLoc("block/mangrove_roots/stem"))).texture("roots", roots);
            ModelBuilder stemShort = ((BlockModelBuilder)prov.models().withExistingParent(name + "_stem_short", prov.modLoc("block/mangrove_roots/stem_short"))).texture("roots", roots);
            ModelBuilder connectionLow = ((BlockModelBuilder)prov.models().withExistingParent(name + "_connection_low", prov.modLoc("block/mangrove_roots/connection_low"))).texture("roots", roots);
            ModelBuilder connectionHigh = ((BlockModelBuilder)prov.models().withExistingParent(name + "_connection_high", prov.modLoc("block/mangrove_roots/connection_high"))).texture("roots", roots);
            ModelBuilder appendagesHigh = ((BlockModelBuilder)prov.models().withExistingParent(name + "_appendages_high", prov.modLoc("block/mangrove_roots/appendages"))).texture("appendages", prov.modLoc("block/" + name + "_appendages_high"));
            ModelBuilder appendagesHighShort = ((BlockModelBuilder)prov.models().withExistingParent(name + "_appendages_high_short", prov.modLoc("block/mangrove_roots/appendages"))).texture("appendages", prov.modLoc("block/" + name + "_appendages_high_short"));
            ModelBuilder appendagesGrounded = ((BlockModelBuilder)prov.models().withExistingParent(name + "_appendages_ground", prov.modLoc("block/mangrove_roots/appendages"))).texture("appendages", prov.modLoc("block/" + name + "_appendages_ground"));
            ModelBuilder appendagesGroundedShort = ((BlockModelBuilder)prov.models().withExistingParent(name + "_appendages_ground_short", prov.modLoc("block/mangrove_roots/appendages"))).texture("appendages", prov.modLoc("block/" + name + "_appendages_ground_short"));
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)stem).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)stemShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesGrounded).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesGroundedShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesHigh).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesHighShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{false});
            for (int i = 0; i < 4; ++i) {
                EnumProperty<MangroveRootsBlock.Connection> connection = MangroveRootsBlock.CONNECTIONS[i];
                int rotation = (i * 90 + 270) % 360;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)connectionHigh).rotationY(rotation).uvLock(true).addModel()).condition(connection, (Comparable[])new MangroveRootsBlock.Connection[]{MangroveRootsBlock.Connection.HIGH});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)connectionLow).rotationY(rotation).uvLock(true).addModel()).condition(connection, (Comparable[])new MangroveRootsBlock.Connection[]{MangroveRootsBlock.Connection.LOW});
            }
        }).item().model((ctx, prov) -> prov.blockItem((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, "_stem")).build();
    }

    private static BlockBuilder<MangroveLeavesBlock, Registrate> mangroveLeaves(String name, Supplier<PropaguleBlock> propagule) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new MangroveLeavesBlock((BlockBehaviour.Properties)p, propagule)).initialProperties(() -> Blocks.f_50050_).properties(BlockBehaviour.Properties::m_60977_).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears((Block)block).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)loot.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))))).tag(new TagKey[]{BlockTags.f_13035_}).item().tag(new TagKey[]{ItemTags.f_13143_}).build();
    }

    private static BlockBuilder<PropaguleBlock, Registrate> propagule(String name, AbstractTreeGrower tree, String scientificName) {
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(name, p -> new PropaguleBlock(tree, (BlockBehaviour.Properties)p)).initialProperties(() -> Blocks.f_50746_).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13104_}).blockstate((ctx, prov) -> {
            BlockModelBuilder planted = (BlockModelBuilder)prov.models().cross(ctx.getName() + "_planted", prov.modLoc("block/" + ctx.getName() + "_planted"));
            BlockModelBuilder hanging = (BlockModelBuilder)prov.models().cross(ctx.getName() + "_hanging", prov.blockTexture((Block)ctx.get()));
            prov.getVariantBuilder((Block)ctx.get()).partialState().with((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)hanging)}).partialState().with((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)planted)});
        }).setData(ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, scientificName))).item().model(TropicraftBlocks::blockSprite).tag(new TagKey[]{ItemTags.f_13180_}).build();
    }

    private static BlockBuilder<Block, Registrate> planks(String name, MapColor color, Supplier<DataIngredient> log) {
        return (BlockBuilder)REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.f_50705_).properties(p -> p.m_284180_(color)).tag(new TagKey[]{BlockTags.f_13090_, BlockTags.f_144280_}).recipe((ctx, prov) -> prov.planks((DataIngredient)log.get(), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx)).item().tag(new TagKey[]{ItemTags.f_13168_}).build();
    }

    private static BlockBuilder<FenceBlock, Registrate> woodenFence(String name, BlockEntry<? extends Block> block) {
        return (BlockBuilder)REGISTRATE.block(name, FenceBlock::new).initialProperties(block).tag(new TagKey[]{BlockTags.f_13098_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.get(), prov.blockTexture((Block)block.get()))).recipe((ctx, prov) -> prov.fence(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_fence")).item().tag(new TagKey[]{ItemTags.f_13176_}).model((ctx, prov) -> prov.fenceInventory(ctx.getName(), prov.modLoc("block/" + prov.name((com.tterrag.registrate.util.nullness.NonNullSupplier)block)))).build();
    }

    private static BlockBuilder<FenceGateBlock, Registrate> fenceGate(String name, BlockEntry<? extends Block> block) {
        return REGISTRATE.block(name, p -> new FenceGateBlock(p, SoundEvents.f_11873_, SoundEvents.f_11872_)).initialProperties(block).tag(new TagKey[]{BlockTags.f_13055_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.fenceGateBlock((FenceGateBlock)ctx.get(), prov.blockTexture((Block)block.get()))).recipe((ctx, prov) -> prov.fenceGate(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_fence_gate")).simpleItem();
    }

    private static BlockBuilder<DoorBlock, Registrate> woodenDoor(String name, BlockEntry<? extends Block> material) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new DoorBlock(p, BlockSetType.f_271198_)).initialProperties(() -> Blocks.f_50154_).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, (Block)block, DoorBlock.f_52730_, DoubleBlockHalf.LOWER))).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13095_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.get(), prov.modLoc("block/" + ctx.getName() + "_bottom"), prov.modLoc("block/" + ctx.getName() + "_top"))).recipe((ctx, prov) -> prov.trapDoor(DataIngredient.items((ItemLike)((Block)material.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_door")).item().defaultModel().tag(new TagKey[]{ItemTags.f_13173_}).build();
    }

    private static BlockBuilder<TrapDoorBlock, Registrate> trapdoor(String name, BlockEntry<? extends Block> material) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new TrapDoorBlock(p, BlockSetType.f_271198_)).initialProperties(() -> Blocks.f_50216_).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13102_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.trapdoorBlock((TrapDoorBlock)ctx.get(), prov.blockTexture((Block)ctx.get()), true)).recipe((ctx, prov) -> prov.trapDoor(DataIngredient.items((ItemLike)((Block)material.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_trapdoor")).item().tag(new TagKey[]{ItemTags.f_13178_}).model((ctx, prov) -> prov.blockItem((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, "_bottom")).build();
    }

    private static BlockBuilder<BoardwalkBlock, Registrate> boardwalk(String name, BlockEntry<SlabBlock> slab, Either<Supplier<Block>, ResourceLocation> texture) {
        return (BlockBuilder)REGISTRATE.block(name, BoardwalkBlock::new).initialProperties(slab).properties(BlockBehaviour.Properties::m_60955_).tag(new TagKey[]{BlockTags.f_144280_}).blockstate((ctx, prov) -> {
            Direction.Axis[] horizontals;
            ResourceLocation resolvedTexture = (ResourceLocation)texture.map(b -> prov.blockTexture((Block)b.get()), Function.identity());
            ModelBuilder shortModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_short", prov.modLoc("block/boardwalk/short"))).texture("planks", resolvedTexture);
            ModelBuilder shortPostModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_short_post", prov.modLoc("block/boardwalk/short_post"))).texture("planks", resolvedTexture);
            ModelBuilder tallModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tall", prov.modLoc("block/boardwalk/tall"))).texture("planks", resolvedTexture);
            ModelBuilder tallPostModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tall_post", prov.modLoc("block/boardwalk/tall_post"))).texture("planks", resolvedTexture);
            ModelBuilder tallConnectionModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tall_connection", prov.modLoc("block/boardwalk/tall_connection"))).texture("planks", resolvedTexture);
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            for (Direction.Axis axis : horizontals = new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}) {
                int rotation = axis == Direction.Axis.X ? 270 : 0;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)shortModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.SHORTS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.TALLS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallConnectionModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.BACKS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallConnectionModel).rotationY((rotation + 180) % 360).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.FRONTS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
            }
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)shortPostModel).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.SHORT_POSTS);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallPostModel).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.TALL_POSTS);
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("XXX").m_126130_("S S").m_126127_(Character.valueOf('X'), (ItemLike)slab.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126145_("tropicraft:boardwalk").m_126132_("has_" + prov.safeName((ItemLike)slab.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)slab.get()))).m_176498_((Consumer)prov)).item().model((ctx, prov) -> prov.blockItem((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, "_short")).build();
    }

    private static BlockBehaviour.Properties rotatedPillarProperties(MapColor topColor, MapColor sideColor) {
        return BlockBehaviour.Properties.m_284310_().m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : sideColor);
    }

    protected static <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(RegistrateBlockLootTables loot, Block block, Property<T> property, T value) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)loot.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(property, value))))));
    }

    private static LootPool.Builder droppingChunksPool(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk) {
        return LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)chunk.get()).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_271388_)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_7170_((LootPoolEntryContainer.Builder)loot.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)block))));
    }

    protected static LootTable.Builder droppingChunks(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk) {
        return LootTable.m_79147_().m_79161_(TropicraftBlocks.droppingChunksPool(loot, block, chunk));
    }

    protected static LootTable.Builder droppingChunks(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk, LootItemCondition.Builder condition) {
        return LootTable.m_79147_().m_79161_(TropicraftBlocks.droppingChunksPool(loot, block, chunk).m_79080_(condition));
    }

    private static LootTable.Builder dropNumberOfItems(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> drop, int minDrops, int maxDrops) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)loot.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)minDrops, (float)maxDrops)))));
    }

    private static LootTable.Builder onlyWithSilkTouchOrShears(Block block) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_(HAS_SHEARS_OR_SILK_TOUCH).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)));
    }

    private static ModelFile cubeTop(DataGenContext<Block, BlockTropicraftSand> ctx, RegistrateBlockstateProvider prov, String suffix) {
        return prov.models().cubeTop(ctx.getName() + "_" + suffix, prov.blockTexture((Block)ctx.get()), prov.modLoc("block/" + ctx.getName() + "_" + suffix));
    }

    private static ModelFile fuzzyStairs(RegistrateBlockstateProvider prov, String name, String parent, String side, String end, String cross) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc(parent))).texture("side", prov.modLoc("block/" + side))).texture("bottom", prov.modLoc("block/" + end))).texture("top", prov.modLoc("block/" + end))).texture("cross", prov.modLoc("block/" + cross));
    }

    private static ModelFile fuzzyStairs(RegistrateBlockstateProvider prov, String name, String side, String end, String cross) {
        return TropicraftBlocks.fuzzyStairs(prov, name, "stairs_fuzzy", side, end, cross);
    }

    private static ModelFile fuzzyStairsOuter(RegistrateBlockstateProvider prov, String name, String side, String end, String cross) {
        return TropicraftBlocks.fuzzyStairs(prov, name, "stairs_fuzzy_outer", side, end, cross);
    }

    private static void doublePlant(DataGenContext<Block, ? extends DoublePlantBlock> ctx, RegistrateBlockstateProvider prov) {
        BlockModelProvider models = prov.models();
        prov.getVariantBuilder((Block)ctx.get()).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)models.cross(ctx.getName() + "_bottom", prov.modLoc("block/" + ctx.getName() + "_bottom")))}).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)models.cross(ctx.getName() + "_top", prov.modLoc("block/" + ctx.getName() + "_top")))});
    }

    private static void noModelBlock(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, ResourceLocation particle) {
        prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(ctx.getName())).texture("particle", particle));
    }

    private static void simpleBlockAllRotations(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.get(), ConfiguredModel.allRotations((ModelFile)prov.cubeAll((Block)ctx.get()), (boolean)false));
    }

    private static ItemModelBuilder blockSprite(DataGenContext<Item, ? extends ItemLike> ctx, RegistrateItemModelProvider prov) {
        return prov.blockSprite(ctx);
    }

    private static NonNullBiFunction<Block, Item.Properties, BlockItem> itemWithRenderer(final Supplier<IClientItemExtensions> properties) {
        return (b, p) -> new BlockItem((Block)b, (Item.Properties)p){

            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept((IClientItemExtensions)properties.get());
            }
        };
    }

    private static String name(ItemLike item) {
        return item.m_5456_().m_204114_().m_205785_().m_135782_().m_135815_();
    }

    private static void extendBlockEntity(BlockEntityType<?> type, Block block) {
        ((BlockEntityTypeAccessor)type).tropicraft$setValidBlocks((Set<Block>)ImmutableSet.builder().addAll(((BlockEntityTypeAccessor)type).tropicraft$getValidBlocks()).add((Object)block).build());
    }

    private static /* synthetic */ TallSeagrassBlock lambda$seagrass$221(Supplier tall) {
        return (TallSeagrassBlock)((BlockEntry)tall.get()).get();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$static$184(ModelFile tikiUpper, ModelFile tikiLower, BlockState state) {
        return ConfiguredModel.builder().modelFile(state.m_61143_(TikiTorchBlock.SECTION) == TikiTorchBlock.TorchSection.UPPER ? tikiUpper : tikiLower).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$static$148(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
    }

    static {
        REGISTRATE.addDataGenerator(ProviderType.BLOCKSTATE, prov -> {
            ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("bamboo_item_frame", "item_frame")).texture("particle", prov.modLoc("block/bamboo_side"))).texture("wood", prov.modLoc("block/bamboo_side"));
            ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("bamboo_item_frame_map", "item_frame_map")).texture("particle", prov.modLoc("block/bamboo_side"))).texture("wood", prov.modLoc("block/bamboo_side"));
        });
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.addTag(TropicraftTags.Blocks.CARVER_REPLACEABLES).addTags(new TagKey[]{BlockTags.f_215820_}));
        TELEPORT_WATER = REGISTRATE.block("teleport_water", PortalWaterBlock::new).initialProperties(() -> Blocks.f_49990_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(prov.mcLoc("block/water")))).register();
        PORTAL_WATER = REGISTRATE.block("portal_water", p -> new LiquidBlock(() -> Fluids.f_76193_, p)).initialProperties(() -> Blocks.f_49990_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(prov.mcLoc("block/water")))).register();
        CHUNK = REGISTRATE.block("chunk", Block::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_284180_(MapColor.f_283927_).m_60978_(6.0f).m_155956_(30.0f)).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.f_144282_}).lang("Chunk O' Head").simpleItem().register();
        AZURITE_ORE = ((BlockBuilder)TropicraftBlocks.ore("azurite_ore", TropicraftItems.AZURITE, MapColor.f_283947_).tag(new TagKey[]{BlockTags.f_144285_}).item().tag(new TagKey[]{TropicraftTags.Items.AZURITE_ORE, Tags.Items.ORES}).build()).register();
        EUDIALYTE_ORE = ((BlockBuilder)TropicraftBlocks.ore("eudialyte_ore", TropicraftItems.EUDIALYTE, MapColor.f_283947_).tag(new TagKey[]{BlockTags.f_144285_}).item().tag(new TagKey[]{TropicraftTags.Items.EUDIALYTE_ORE, Tags.Items.ORES}).build()).register();
        MANGANESE_ORE = ((BlockBuilder)TropicraftBlocks.ore("manganese_ore", MapColor.f_283947_).tag(new TagKey[]{BlockTags.f_144285_}).item().tag(new TagKey[]{TropicraftTags.Items.MANGANESE_ORE, Tags.Items.ORES}).build()).register();
        SHAKA_ORE = ((BlockBuilder)TropicraftBlocks.ore("shaka_ore", MapColor.f_283927_).tag(new TagKey[]{BlockTags.f_144285_}).item().tag(new TagKey[]{TropicraftTags.Items.SHAKA_ORE, Tags.Items.ORES}).build()).register();
        ZIRCON_ORE = ((BlockBuilder)TropicraftBlocks.ore("zircon_ore", TropicraftItems.ZIRCON, MapColor.f_283947_).tag(new TagKey[]{BlockTags.f_144285_}).item().tag(new TagKey[]{TropicraftTags.Items.ZIRCON_ORE, Tags.Items.ORES}).build()).register();
        AZURITE_BLOCK = TropicraftBlocks.oreStorageBlock("azurite_block", MapColor.f_283869_, TropicraftItems.AZURITE).tag(new TagKey[]{BlockTags.f_144285_}).register();
        EUDIALYTE_BLOCK = TropicraftBlocks.oreStorageBlock("eudialyte_block", MapColor.f_283765_, TropicraftItems.EUDIALYTE).tag(new TagKey[]{BlockTags.f_144285_}).register();
        MANGANESE_BLOCK = TropicraftBlocks.oreStorageBlock("manganese_block", MapColor.f_283889_, TropicraftItems.MANGANESE).tag(new TagKey[]{BlockTags.f_144285_}).register();
        SHAKA_BLOCK = TropicraftBlocks.oreStorageBlock("shaka_block", MapColor.f_283743_, TropicraftItems.SHAKA).tag(new TagKey[]{BlockTags.f_144285_}).register();
        ZIRCON_BLOCK = TropicraftBlocks.oreStorageBlock("zircon_block", MapColor.f_283913_, TropicraftItems.ZIRCON).tag(new TagKey[]{BlockTags.f_144285_}).register();
        ZIRCONIUM_BLOCK = TropicraftBlocks.oreStorageBlock("zirconium_block", MapColor.f_283765_, TropicraftItems.ZIRCONIUM).register();
        FLOWERS = (Map)Arrays.stream(TropicraftFlower.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), flower -> {
            BlockBuilder builder = (BlockBuilder)REGISTRATE.block(flower.getId(), p -> new TropicsFlowerBlock(flower.getEffect(), flower.getEffectDuration(), flower.getShape(), (BlockBehaviour.Properties)p)).initialProperties(() -> Blocks.f_50112_).addLayer(() -> RenderType::m_110463_).tag(flower.getTags()).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), "block/cross")).texture("cross", "tropicraft:block/flower/" + ctx.getName()))).item().tag(new TagKey[]{ItemTags.f_13149_}).model((ctx, prov) -> prov.generated((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("block/flower/" + ctx.getName())})).build();
            Item dye = flower.getDye();
            if (dye != null) {
                builder = builder.recipe((ctx, prov) -> prov.singleItemUnfinished(DataIngredient.items((ItemLike)((TropicsFlowerBlock)((Object)((Object)((Object)ctx.get())))), (ItemLike[])new TropicsFlowerBlock[0]), RecipeCategory.MISC, () -> dye, 1, 2).m_126140_((Consumer)prov, new ResourceLocation("tropicraft", TropicraftBlocks.name((ItemLike)dye))));
            }
            return builder.register();
        }));
        PURIFIED_SAND = ((BlockBuilder)REGISTRATE.block("purified_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.f_49992_).tag(new TagKey[]{BlockTags.f_13029_, BlockTags.f_144283_, TropicraftTags.Blocks.CARVER_REPLACEABLES}).blockstate((ctx, prov) -> {
            ModelFile normal = prov.cubeAll((Block)ctx.get());
            ModelFile calcified = TropicraftBlocks.cubeTop((DataGenContext<Block, BlockTropicraftSand>)ctx, prov, "calcified");
            ModelFile dune1 = TropicraftBlocks.cubeTop((DataGenContext<Block, BlockTropicraftSand>)ctx, prov, "dune1");
            ModelFile dune2 = TropicraftBlocks.cubeTop((DataGenContext<Block, BlockTropicraftSand>)ctx, prov, "dune2");
            ModelFile starfish = TropicraftBlocks.cubeTop((DataGenContext<Block, BlockTropicraftSand>)ctx, prov, "starfish");
            prov.getVariantBuilder((Block)ctx.get()).partialState().with((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.allRotations((ModelFile)normal, (boolean)false, (int)50)).addModels(ConfiguredModel.allYRotations((ModelFile)calcified, (int)0, (boolean)false, (int)5)).partialState().with((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.allRotations((ModelFile)normal, (boolean)false, (int)50)).addModels(ConfiguredModel.allYRotations((ModelFile)dune1, (int)0, (boolean)false, (int)10)).addModels(ConfiguredModel.allYRotations((ModelFile)dune2, (int)0, (boolean)false, (int)10)).addModels(ConfiguredModel.allYRotations((ModelFile)starfish, (int)0, (boolean)false));
        }).item().tag(new TagKey[]{ItemTags.f_13137_}).build()).register();
        PACKED_PURIFIED_SAND = ((BlockBuilder)REGISTRATE.block("packed_purified_sand", Block::new).initialProperties(() -> Blocks.f_49992_).properties(p -> p.m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.f_13029_, BlockTags.f_144283_, TropicraftTags.Blocks.CARVER_REPLACEABLES}).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get())).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)PURIFIED_SAND.get()).m_126132_("has_purified_sand", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)PURIFIED_SAND.get()))).m_176498_((Consumer)prov)).item().tag(new TagKey[]{ItemTags.f_13137_}).build()).register();
        CORAL_SAND = ((BlockBuilder)REGISTRATE.block("coral_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.f_49992_).properties(p -> p.m_284180_(MapColor.f_283765_)).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.f_13029_, BlockTags.f_144283_, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.f_13137_}).build()).register();
        FOAMY_SAND = ((BlockBuilder)REGISTRATE.block("foamy_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.f_49992_).properties(p -> p.m_284180_(MapColor.f_283784_)).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.f_13029_, BlockTags.f_144283_, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.f_13137_}).build()).register();
        VOLCANIC_SAND = ((BlockBuilder)REGISTRATE.block("volcanic_sand", VolcanicSandBlock::new).initialProperties(() -> Blocks.f_49992_).properties(p -> p.m_284180_(MapColor.f_283779_)).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.f_13029_, BlockTags.f_144283_, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.f_13137_}).build()).register();
        MINERAL_SAND = ((BlockBuilder)REGISTRATE.block("mineral_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.f_49992_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), ConfiguredModel.allRotations((ModelFile)prov.cubeAll((Block)ctx.get()), (boolean)false))).tag(new TagKey[]{BlockTags.f_13029_, BlockTags.f_144283_, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.f_13137_}).build()).register();
        MUD = REGISTRATE.block("mud", Block::new).initialProperties(() -> Blocks.f_50493_).properties(p -> p.m_60956_(0.5f).m_60922_((s, w, pa, e) -> true).m_60924_((s, w, pa) -> true).m_60971_((s, w, pa) -> true).m_60960_((s, w, pa) -> true)).tag(new TagKey[]{TropicraftTags.Blocks.MUD, BlockTags.f_144283_, TropicraftTags.Blocks.CARVER_REPLACEABLES}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ConfiguredModel[])ArrayUtils.addAll((Object[])ConfiguredModel.allYRotations((ModelFile)prov.models().cubeAll("mud", prov.modLoc("block/mud")), (int)0, (boolean)false, (int)5), (Object[])ConfiguredModel.allYRotations((ModelFile)prov.models().cubeAll("mud_with_stones", prov.modLoc("block/mud_with_stones")), (int)0, (boolean)false, (int)1)))).simpleItem().register();
        MUD_WITH_PIANGUAS = REGISTRATE.block("mud_with_pianguas", Block::new).initialProperties(MUD).loot((loot, block) -> loot.m_247577_(block, (LootTable.Builder)loot.m_246108_((ItemLike)MUD_WITH_PIANGUAS.get(), (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)MUD_WITH_PIANGUAS.get())).m_79080_(HAS_SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)MUD.get()))))).m_79161_(LootPool.m_79043_().m_79080_(HAS_NO_SILK_TOUCH).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TropicraftItems.PIANGUAS.get())).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))))))).tag(new TagKey[]{TropicraftTags.Blocks.MUD, BlockTags.f_144283_, TropicraftTags.Blocks.CARVER_REPLACEABLES}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), model -> ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false))).simpleItem().register();
        BAMBOO_BUNDLE = REGISTRATE.block("bamboo_bundle", RotatedPillarBlock::new).properties(p -> p.m_284180_(MapColor.f_283915_).m_60918_(SoundType.f_56754_).m_60913_(0.2f, 5.0f)).blockstate((ctx, prov) -> prov.axisBlock((RotatedPillarBlock)ctx.get(), prov.modLoc("block/bamboo"))).recipe((ctx, prov) -> prov.singleItem(DataIngredient.items(TropicraftItems.BAMBOO_STICK, (com.tterrag.registrate.util.nullness.NonNullSupplier[])new com.tterrag.registrate.util.nullness.NonNullSupplier[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, 9, 2)).simpleItem().register();
        THATCH_BUNDLE = REGISTRATE.block("thatch_bundle", RotatedPillarBlock::new).properties(p -> p.m_284180_(MapColor.f_283915_).m_60918_(SoundType.f_56754_).m_60913_(0.2f, 5.0f).m_278183_().m_278166_(PushReaction.DESTROY)).blockstate((ctx, prov) -> prov.axisBlock((RotatedPillarBlock)ctx.get(), prov.modLoc("block/thatch"))).recipe((ctx, prov) -> prov.singleItem(DataIngredient.items((ItemLike)Items.f_41909_, (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, 9, 1)).simpleItem().register();
        MAHOGANY_PLANKS = TropicraftBlocks.planks("mahogany_planks", MapColor.f_283748_, () -> DataIngredient.items((ItemLike)((RotatedPillarBlock)MAHOGANY_LOG.get()), (ItemLike[])new RotatedPillarBlock[0])).register();
        PALM_PLANKS = TropicraftBlocks.planks("palm_planks", MapColor.f_283748_, () -> DataIngredient.items((ItemLike)((RotatedPillarBlock)PALM_LOG.get()), (ItemLike[])new RotatedPillarBlock[0])).register();
        MAHOGANY_LOG = TropicraftBlocks.log("mahogany_log", MapColor.f_283825_, MapColor.f_283748_).register();
        PALM_LOG = TropicraftBlocks.log("palm_log", MapColor.f_283818_, MapColor.f_283748_).register();
        MAHOGANY_WOOD = TropicraftBlocks.wood("mohogany_wood", MapColor.f_283825_, MAHOGANY_LOG).lang("Mahogany Wood").register();
        PALM_WOOD = TropicraftBlocks.wood("palm_wood", MapColor.f_283818_, PALM_LOG).register();
        PALM_STAIRS = TropicraftBlocks.woodenStairs("palm_stairs", PALM_PLANKS).register();
        MAHOGANY_STAIRS = TropicraftBlocks.woodenStairs("mahogany_stairs", MAHOGANY_PLANKS).register();
        THATCH_STAIRS = TropicraftBlocks.woodenStairs("thatch_stairs", THATCH_BUNDLE).blockstate((ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/thatch_side");
            ResourceLocation end = prov.modLoc("block/thatch_end");
            prov.stairsBlock((StairBlock)ctx.get(), side, end, end);
        }).register();
        THATCH_STAIRS_FUZZY = TropicraftBlocks.woodenStairs("thatch_stairs_fuzzy", THATCH_BUNDLE).addLayer(() -> RenderType::m_110457_).blockstate((ctx, prov) -> {
            ModelFile fuzzyThatch = TropicraftBlocks.fuzzyStairs(prov, "thatch_stairs_fuzzy", "thatch_side", "thatch_end", "thatch_grass");
            ModelFile fuzzyThatchOuter = TropicraftBlocks.fuzzyStairsOuter(prov, "thatch_stairs_fuzzy_outer", "thatch_side", "thatch_end", "thatch_grass");
            prov.stairsBlock((StairBlock)ctx.get(), fuzzyThatch, (ModelFile)prov.models().getExistingFile(prov.modLoc("thatch_stairs_inner")), fuzzyThatchOuter);
        }).lang("Thatch Roof").recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).m_126130_("C  ").m_126130_("XC ").m_126130_("XXC").m_126127_(Character.valueOf('X'), (ItemLike)THATCH_BUNDLE.get()).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41909_).m_126132_("has_thatch_bundle", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)THATCH_BUNDLE.get()))).m_176498_((Consumer)prov)).register();
        BAMBOO_STAIRS = TropicraftBlocks.woodenStairs("bamboo_stairs", BAMBOO_BUNDLE).blockstate((ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/bamboo_side");
            ResourceLocation end = prov.modLoc("block/bamboo_end");
            prov.stairsBlock((StairBlock)ctx.get(), side, end, end);
        }).register();
        CHUNK_STAIRS = TropicraftBlocks.stoneStairs("chunk_stairs", CHUNK).register();
        COCONUT = ((BlockBuilder)REGISTRATE.block("coconut", CoconutBlock::new).properties(p -> p.m_284180_(MapColor.f_283915_).m_60978_(2.0f).m_60918_(SoundType.f_56742_).m_278166_(PushReaction.DESTROY)).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.droppingChunks(loot, (Block)block, TropicraftItems.COCONUT_CHUNK))).tag(new TagKey[]{BlockTags.f_144280_}).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross("coconut", prov.modLoc("block/coconut")))).item().model(TropicraftBlocks::blockSprite).build()).register();
        BAMBOO_SLAB = TropicraftBlocks.woodenSlab("bamboo_slab", BAMBOO_BUNDLE).blockstate((ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/bamboo_side");
            ResourceLocation end = prov.modLoc("block/bamboo_end");
            prov.slabBlock((SlabBlock)ctx.get(), BAMBOO_BUNDLE.getId(), side, end, end);
        }).register();
        THATCH_SLAB = TropicraftBlocks.woodenSlab("thatch_slab", THATCH_BUNDLE).blockstate((ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/thatch_side");
            ResourceLocation end = prov.modLoc("block/thatch_end");
            prov.slabBlock((SlabBlock)ctx.get(), THATCH_BUNDLE.getId(), side, end, end);
        }).register();
        CHUNK_SLAB = TropicraftBlocks.stoneSlab("chunk_slab", CHUNK).register();
        PALM_SLAB = TropicraftBlocks.woodenSlab("palm_slab", PALM_PLANKS).register();
        MAHOGANY_SLAB = TropicraftBlocks.woodenSlab("mahogany_slab", MAHOGANY_PLANKS).register();
        GRAPEFRUIT_SAPLING = TropicraftBlocks.sapling("grapefruit_sapling", TropicraftTrees.GRAPEFRUIT, new Supplier[0]).register();
        LEMON_SAPLING = TropicraftBlocks.sapling("lemon_sapling", TropicraftTrees.LEMON, new Supplier[0]).register();
        LIME_SAPLING = TropicraftBlocks.sapling("lime_sapling", TropicraftTrees.LIME, new Supplier[0]).register();
        ORANGE_SAPLING = TropicraftBlocks.sapling("orange_sapling", TropicraftTrees.ORANGE, new Supplier[0]).register();
        PAPAYA_SAPLING = TropicraftBlocks.sapling("papaya_sapling", TropicraftTrees.PAPAYA, new Supplier[0]).register();
        MAHOGANY_SAPLING = TropicraftBlocks.sapling("mahogany_sapling", TropicraftTrees.RAINFOREST, new Supplier[0]).register();
        PALM_SAPLING = TropicraftBlocks.sapling("palm_sapling", TropicraftTrees.PALM, new Supplier[]{() -> Blocks.f_49992_, CORAL_SAND, FOAMY_SAND, VOLCANIC_SAND, PURIFIED_SAND, MINERAL_SAND}).register();
        MAHOGANY_LEAVES = TropicraftBlocks.leaves("mahogany_leaves", MAHOGANY_SAPLING, RARE_SAPLING_RATES, false).register();
        PALM_LEAVES = TropicraftBlocks.leaves("palm_leaves", PALM_SAPLING, SAPLING_RATES, false).register();
        KAPOK_LEAVES = TropicraftBlocks.leaves("kapok_leaves", false).register();
        FRUIT_LEAVES = TropicraftBlocks.leaves("fruit_leaves", true).register();
        GRAPEFRUIT_LEAVES = TropicraftBlocks.fruitLeaves("grapefruit_leaves", GRAPEFRUIT_SAPLING, TropicraftItems.GRAPEFRUIT).register();
        LEMON_LEAVES = TropicraftBlocks.fruitLeaves("lemon_leaves", LEMON_SAPLING, TropicraftItems.LEMON).register();
        LIME_LEAVES = TropicraftBlocks.fruitLeaves("lime_leaves", LIME_SAPLING, TropicraftItems.LIME).register();
        ORANGE_LEAVES = TropicraftBlocks.fruitLeaves("orange_leaves", ORANGE_SAPLING, TropicraftItems.ORANGE).register();
        PAPAYA_LEAVES = TropicraftBlocks.leaves("papaya_leaves", PAPAYA_SAPLING, SAPLING_RATES, false).register();
        WHITE_FLOWERING_LEAVES = TropicraftBlocks.leaves("white_flowering_leaves", true).register();
        RED_FLOWERING_LEAVES = TropicraftBlocks.leaves("red_flowering_leaves", true).register();
        BLUE_FLOWERING_LEAVES = TropicraftBlocks.leaves("blue_flowering_leaves", true).register();
        PURPLE_FLOWERING_LEAVES = TropicraftBlocks.leaves("purple_flowering_leaves", true).register();
        YELLOW_FLOWERING_LEAVES = TropicraftBlocks.leaves("yellow_flowering_leaves", true).register();
        PASSIONFRUIT_VINE = ((BlockBuilder)REGISTRATE.block("passionfruit_vine", FruitingVineBlock::new).properties(p -> p.m_284180_(MapColor.f_283824_).m_280170_().m_60910_().m_60978_(0.2f).m_60918_(SoundType.f_56760_).m_278183_().m_278166_(PushReaction.DESTROY)).blockstate((ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            Iterator iterator = FruitingVineBlock.AGE.m_6908_().iterator();
            while (iterator.hasNext()) {
                int age = (Integer)iterator.next();
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + age, prov.modLoc("block/vines"))).texture("texture", prov.modLoc("block/" + ctx.getName() + "_" + age));
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(270).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(90).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(180).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(90).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(270).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{true});
            }
        }).addLayer(() -> RenderType::m_110457_).loot((loot, block) -> loot.m_247577_((Block)block, RegistrateBlockLootTables.m_246160_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)loot.m_247733_((ItemLike)block, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_(TropicraftItems.PASSIONFRUIT).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FruitingVineBlock.AGE, 2)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))))))).item().model((ctx, prov) -> prov.blockSprite((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, prov.modLoc("block/passionfruit_vine_1"))).build()).register();
        PAPAYA_LOG = TropicraftBlocks.log("papaya_log", MapColor.f_283818_, MapColor.f_283748_).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50002_).m_126209_((ItemLike)ctx.get()).m_126132_("has_papaya_log", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)ctx.get()))).m_176498_((Consumer)prov)).register();
        PAPAYA_WOOD = TropicraftBlocks.wood("papaya_wood", MapColor.f_283818_, PAPAYA_LOG).register();
        PLANTAIN_SAPLING = TropicraftBlocks.sapling("plantain_sapling", TropicraftTrees.PLANTAIN, new Supplier[0]).register();
        PLANTAIN_STEM = TropicraftBlocks.log("plantain_stem", MapColor.f_283916_, MapColor.f_283748_).register();
        PLANTAIN_LEAVES = TropicraftBlocks.leaves("plantain_leaves", PLANTAIN_SAPLING, SAPLING_RATES, true).register();
        GREEN_PLANTAIN_BUNCH = TropicraftBlocks.plantainBunch("green_plantain_bunch", () -> TropicraftItems.GREEN_PLANTAIN);
        YELLOW_PLANTAIN_BUNCH = TropicraftBlocks.plantainBunch("yellow_plantain_bunch", () -> TropicraftItems.YELLOW_PLANTAIN);
        JOCOTE_SAPLING = TropicraftBlocks.sapling("jocote_sapling", TropicraftTrees.JOCOTE, new Supplier[0]).register();
        JOCOTE_LOG = TropicraftBlocks.log("jocote_log", MapColor.f_283818_, MapColor.f_283748_).register();
        JOCOTE_LEAVES = TropicraftBlocks.leaves("jocote_leaves", JOCOTE_SAPLING, SAPLING_RATES, true).register();
        JOCOTE_BRANCH = ((BlockBuilder)REGISTRATE.block("jocote_branch", FruitingBranchBlock::new).properties(p -> p.m_60918_(SoundType.f_154666_).m_60955_().m_60910_().m_60966_().m_60977_().m_278166_(PushReaction.DESTROY)).blockstate((ctx, prov) -> {
            ResourceLocation fruitingBranch = prov.modLoc("block/fruiting_branch");
            List<BlockModelBuilder> models = IntStream.rangeClosed(0, 2).mapToObj(age -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_age" + age, fruitingBranch)).texture("horizontal", prov.modLoc("block/jocote_branch_horizontal_" + age))).texture("vertical", prov.modLoc("block/jocote_branch_vertical"))).toList();
            prov.horizontalBlock((Block)ctx.get(), state -> (ModelFile)models.get((Integer)state.m_61143_((Property)FruitingBranchBlock.AGE)));
        }).addLayer(() -> RenderType::m_110457_).loot((loot, block) -> loot.m_247577_((Block)block, LootTable.m_79147_().m_79161_((LootPool.Builder)loot.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_79076_(LootItem.m_79579_(TropicraftItems.JOCOTE).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FruitingBranchBlock.AGE, 2)))))))).item().model((ctx, prov) -> prov.blockSprite((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, prov.modLoc("block/jocote_branch_horizontal_0"))).build()).register();
        MAHOGANY_NUT = ((BlockBuilder)REGISTRATE.block("mahogany_nut", MahoganyNutBlock::new).initialProperties(() -> Blocks.f_50262_).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/mahogany_nut_" + state.m_61143_((Property)MahoganyNutBlock.AGE)))).build())).loot((loot, block) -> loot.m_247577_((Block)block, LootTable.m_79147_().m_79161_((LootPool.Builder)loot.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)MahoganyNutBlock.AGE, 2)))))))).addLayer(() -> RenderType::m_110457_).item().model((ctx, prov) -> prov.generated((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/mahogany_nut")})).build()).register();
        RED_MANGROVE_LOG = ((BlockBuilder)TropicraftBlocks.log("red_mangrove_log", MapColor.f_283818_, MapColor.f_283748_, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).item().tag(new TagKey[]{TropicraftTags.Items.MANGROVE_LOGS}).build()).register();
        RED_MANGROVE_WOOD = TropicraftBlocks.wood("red_mangrove_wood", MapColor.f_283818_, RED_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        RED_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("red_mangrove_roots").register();
        LIGHT_MANGROVE_LOG = ((BlockBuilder)TropicraftBlocks.log("light_mangrove_log", MapColor.f_283818_, MapColor.f_283748_, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).item().tag(new TagKey[]{TropicraftTags.Items.MANGROVE_LOGS}).build()).register();
        LIGHT_MANGROVE_WOOD = TropicraftBlocks.wood("light_mangrove_wood", MapColor.f_283818_, LIGHT_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        LIGHT_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("light_mangrove_roots").register();
        BLACK_MANGROVE_LOG = ((BlockBuilder)TropicraftBlocks.log("black_mangrove_log", MapColor.f_283818_, MapColor.f_283748_, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).item().tag(new TagKey[]{TropicraftTags.Items.MANGROVE_LOGS}).build()).register();
        BLACK_MANGROVE_WOOD = TropicraftBlocks.wood("black_mangrove_wood", MapColor.f_283818_, BLACK_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        BLACK_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("black_mangrove_roots").register();
        RED_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("red_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)RED_MANGROVE_PROPAGULE.get()))).register();
        TALL_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("tall_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)TALL_MANGROVE_PROPAGULE.get()))).register();
        TEA_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("tea_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)TEA_MANGROVE_PROPAGULE.get()))).register();
        BLACK_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("black_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)BLACK_MANGROVE_PROPAGULE.get()))).register();
        RED_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("red_mangrove_propagule", TropicraftTrees.RED_MANGROVE, "Rhizophora mangle").register();
        TALL_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("tall_mangrove_propagule", TropicraftTrees.TALL_MANGROVE, "Rhizophora racemosa").register();
        TEA_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("tea_mangrove_propagule", TropicraftTrees.TEA_MANGROVE, "Pelliciera rhizophorae").register();
        BLACK_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("black_mangrove_propagule", TropicraftTrees.BLACK_MANGROVE, "Avicennia germinans").register();
        STRIPPED_MANGROVE_LOG = TropicraftBlocks.log("stripped_mangrove_log", MapColor.f_283913_, MapColor.f_283913_).register();
        STRIPPED_MANGROVE_WOOD = TropicraftBlocks.wood("stripped_mangrove_wood", MapColor.f_283913_, STRIPPED_MANGROVE_LOG).register();
        MANGROVE_PLANKS = TropicraftBlocks.planks("mangrove_planks", MapColor.f_283748_, () -> DataIngredient.items(LIGHT_MANGROVE_LOG, (com.tterrag.registrate.util.nullness.NonNullSupplier[])new com.tterrag.registrate.util.nullness.NonNullSupplier[]{RED_MANGROVE_LOG, BLACK_MANGROVE_LOG})).register();
        MANGROVE_STAIRS = TropicraftBlocks.woodenStairs("mangrove_stairs", MANGROVE_PLANKS).register();
        MANGROVE_SLAB = TropicraftBlocks.woodenSlab("mangrove_slab", MANGROVE_PLANKS).register();
        MANGROVE_FENCE = TropicraftBlocks.woodenFence("mangrove_fence", MANGROVE_PLANKS).register();
        MANGROVE_FENCE_GATE = TropicraftBlocks.fenceGate("mangrove_fence_gate", MANGROVE_PLANKS).register();
        MANGROVE_DOOR = TropicraftBlocks.woodenDoor("mangrove_door", MANGROVE_PLANKS).register();
        MANGROVE_TRAPDOOR = TropicraftBlocks.trapdoor("mangrove_trapdoor", MANGROVE_PLANKS).register();
        MANGROVE_BUTTON = TropicraftBlocks.woodButton("mangrove_button", MANGROVE_PLANKS, "mangrove_planks").register();
        MAHOGANY_BUTTON = TropicraftBlocks.woodButton("mahogany_button", MAHOGANY_PLANKS, "mahogany_planks").register();
        PALM_BUTTON = TropicraftBlocks.woodButton("palm_button", PALM_PLANKS, "palm_planks").register();
        BAMBOO_BUTTON = TropicraftBlocks.woodButton("bamboo_button", BAMBOO_BUNDLE, "bamboo_end").register();
        THATCH_BUTTON = TropicraftBlocks.woodButton("thatch_button", THATCH_BUNDLE, "thatch_end").register();
        MANGROVE_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("mangrove_pressure_plate", MANGROVE_PLANKS, "mangrove_planks").register();
        MAHOGANY_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("mahogany_pressure_plate", MAHOGANY_PLANKS, "mahogany_planks").register();
        PALM_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("palm_pressure_plate", PALM_PLANKS, "palm_planks").register();
        BAMBOO_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("bamboo_pressure_plate", BAMBOO_BUNDLE, "bamboo_end").register();
        THATCH_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("thatch_pressure_plate", THATCH_BUNDLE, "thatch_end").register();
        MAHOGANY_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.MAHOGANY, () -> (Item)TropicraftItems.MAHOGANY_SIGN.get(), "mahogany_planks").register();
        PALM_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.PALM, () -> (Item)TropicraftItems.PALM_SIGN.get(), "palm_planks").register();
        BAMBOO_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.BAMBOO, () -> (Item)TropicraftItems.BAMBOO_SIGN.get(), "bamboo_end").register();
        THATCH_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.THATCH, () -> (Item)TropicraftItems.THATCH_SIGN.get(), "thatch_end").register();
        MANGROVE_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.MANGROVE, () -> (Item)TropicraftItems.MANGROVE_SIGN.get(), "mangrove_planks").register();
        MAHOGANY_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.MAHOGANY, () -> (Item)TropicraftItems.MAHOGANY_SIGN.get(), "mahogany_planks").register();
        PALM_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.PALM, () -> (Item)TropicraftItems.PALM_SIGN.get(), "palm_planks").register();
        BAMBOO_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.BAMBOO, () -> (Item)TropicraftItems.BAMBOO_SIGN.get(), "bamboo_end").register();
        THATCH_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.THATCH, () -> (Item)TropicraftItems.THATCH_SIGN.get(), "thatch_end").register();
        MANGROVE_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.MANGROVE, () -> (Item)TropicraftItems.MANGROVE_SIGN.get(), "mangrove_planks").register();
        REEDS = ((BlockBuilder)REGISTRATE.block("reeds", ReedsBlock::new).initialProperties(() -> Blocks.f_50130_).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> {
            VariantBlockStateBuilder builder = prov.getVariantBuilder((Block)ctx.get());
            for (ReedsBlock.Type type : ReedsBlock.Type.values()) {
                VariantBlockStateBuilder.PartialBlockstate partialState = builder.partialState().with(ReedsBlock.TYPE, (Comparable)((Object)type));
                for (String texture : type.getTextures()) {
                    partialState.addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)prov.models().crop(texture, prov.modLoc("block/" + texture)))});
                }
            }
        }).item().model((ctx, prov) -> prov.blockSprite((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, prov.modLoc("block/" + ctx.getName() + "_top_tall"))).build()).register();
        PAPAYA = ((BlockBuilder)REGISTRATE.block("papaya", PapayaBlock::new).properties(p -> p.m_284180_(MapColor.f_283915_).m_60977_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278166_(PushReaction.DESTROY)).loot((loot, block) -> loot.m_247577_((Block)block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)loot.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)block.m_5456_()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PapayaBlock.AGE, 1))))))))).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> {
            ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("papaya_stage0", "cocoa_stage2")).texture("particle", prov.modLoc("block/papaya_stage0"))).texture("cocoa", prov.modLoc("block/papaya_stage0"));
            prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int age = (Integer)state.m_61143_((Property)PapayaBlock.AGE);
                Direction facing = (Direction)state.m_61143_((Property)PapayaBlock.f_54117_);
                ModelFile.ExistingModelFile modelFile = prov.models().getExistingFile(prov.modLoc("block/papaya_stage" + age));
                return new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelFile, 0, facing.m_122416_() * 90, false)};
            });
        }).item().defaultModel().build()).register();
        BAMBOO_FENCE = ((BlockBuilder)TropicraftBlocks.woodenFence("bamboo_fence", BAMBOO_BUNDLE).blockstate((ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.get(), prov.modLoc("block/bamboo_side"))).item().tag(new TagKey[]{ItemTags.f_13176_}).model((ctx, prov) -> prov.fenceInventory(ctx.getName(), prov.modLoc("block/bamboo_side"))).build()).register();
        THATCH_FENCE = ((BlockBuilder)TropicraftBlocks.woodenFence("thatch_fence", THATCH_BUNDLE).blockstate((ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.get(), prov.modLoc("block/thatch_side"))).item().tag(new TagKey[]{ItemTags.f_13176_}).model((ctx, prov) -> prov.fenceInventory(ctx.getName(), prov.modLoc("block/thatch_side"))).build()).register();
        CHUNK_FENCE = TropicraftBlocks.woodenFence("chunk_fence", CHUNK).register();
        PALM_FENCE = TropicraftBlocks.woodenFence("palm_fence", PALM_PLANKS).register();
        MAHOGANY_FENCE = TropicraftBlocks.woodenFence("mahogany_fence", MAHOGANY_PLANKS).register();
        BAMBOO_FENCE_GATE = TropicraftBlocks.fenceGate("bamboo_fence_gate", BAMBOO_BUNDLE).blockstate((ctx, prov) -> prov.fenceGateBlock((FenceGateBlock)ctx.get(), prov.modLoc("block/bamboo_side"))).register();
        THATCH_FENCE_GATE = TropicraftBlocks.fenceGate("thatch_fence_gate", THATCH_BUNDLE).blockstate((ctx, prov) -> prov.fenceGateBlock((FenceGateBlock)ctx.get(), prov.modLoc("block/thatch_side"))).register();
        CHUNK_FENCE_GATE = TropicraftBlocks.fenceGate("chunk_fence_gate", CHUNK).register();
        PALM_FENCE_GATE = TropicraftBlocks.fenceGate("palm_fence_gate", PALM_PLANKS).register();
        MAHOGANY_FENCE_GATE = TropicraftBlocks.fenceGate("mahogany_fence_gate", MAHOGANY_PLANKS).register();
        CHUNK_WALL = ((BlockBuilder)REGISTRATE.block("chunk_wall", WallBlock::new).initialProperties(CHUNK).tag(new TagKey[]{BlockTags.f_13032_}).blockstate((ctx, prov) -> prov.wallBlock((WallBlock)ctx.get(), prov.blockTexture((Block)CHUNK.get()))).recipe((ctx, prov) -> prov.wall(DataIngredient.items((ItemLike)((Block)CHUNK.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx)).item().tag(new TagKey[]{ItemTags.f_13140_}).model((ctx, prov) -> prov.wallInventory(ctx.getName(), prov.modLoc("block/" + CHUNK.getId().m_135815_()))).build()).register();
        BAMBOO_DOOR = TropicraftBlocks.woodenDoor("bamboo_door", BAMBOO_BUNDLE).register();
        PALM_DOOR = TropicraftBlocks.woodenDoor("palm_door", PALM_PLANKS).register();
        MAHOGANY_DOOR = TropicraftBlocks.woodenDoor("mahogany_door", MAHOGANY_PLANKS).register();
        THATCH_DOOR = TropicraftBlocks.woodenDoor("thatch_door", THATCH_BUNDLE).register();
        BAMBOO_TRAPDOOR = TropicraftBlocks.trapdoor("bamboo_trapdoor", BAMBOO_BUNDLE).register();
        PALM_TRAPDOOR = TropicraftBlocks.trapdoor("palm_trapdoor", PALM_PLANKS).register();
        MAHOGANY_TRAPDOOR = TropicraftBlocks.trapdoor("mahogany_trapdoor", MAHOGANY_PLANKS).register();
        THATCH_TRAPDOOR = TropicraftBlocks.trapdoor("thatch_trapdoor", THATCH_BUNDLE).register();
        IRIS = ((BlockBuilder)REGISTRATE.block("iris", TallFlowerBlock::new).properties(p -> p.m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_280170_().m_278183_().m_278166_(PushReaction.DESTROY)).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, (Block)block, DoublePlantBlock.f_52858_, DoubleBlockHalf.LOWER))).addLayer(() -> RenderType::m_110463_).blockstate(TropicraftBlocks::doublePlant).recipe((ctx, prov) -> prov.singleItemUnfinished(DataIngredient.items((ItemLike)((TallFlowerBlock)ctx.get()), (ItemLike[])new TallFlowerBlock[0]), RecipeCategory.MISC, () -> Items.f_42493_, 1, 4).m_126140_((Consumer)prov, new ResourceLocation("tropicraft", TropicraftBlocks.name((ItemLike)Items.f_42493_)))).item().model((ctx, prov) -> prov.blockSprite((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, prov.modLoc("block/iris_top"))).build()).register();
        PINEAPPLE = ((BlockBuilder)REGISTRATE.block("pineapple", PineappleBlock::new).properties(p -> p.m_284180_(MapColor.f_283915_).m_60977_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_280170_().m_278183_().m_278166_(PushReaction.DESTROY)).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.droppingChunks(loot, (Block)block, TropicraftItems.PINEAPPLE_CUBES, (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))))).addLayer(() -> RenderType::m_110463_).blockstate(TropicraftBlocks::doublePlant).item().model((ctx, prov) -> prov.blockSprite((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, prov.modLoc("block/pineapple_top"))).build()).register();
        SMALL_BONGO_DRUM = TropicraftBlocks.bongoDrum("small_bongo_drum", BongoDrumBlock.Size.SMALL).register();
        MEDIUM_BONGO_DRUM = TropicraftBlocks.bongoDrum("medium_bongo_drum", BongoDrumBlock.Size.MEDIUM).register();
        LARGE_BONGO_DRUM = TropicraftBlocks.bongoDrum("large_bongo_drum", BongoDrumBlock.Size.LARGE).register();
        BAMBOO_LADDER = ((BlockBuilder)REGISTRATE.block("bamboo_ladder", LadderBlock::new).initialProperties(() -> Blocks.f_50571_).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13082_, BlockTags.f_144280_}).blockstate((ctx, prov) -> {
            ResourceLocation texture = prov.blockTexture((Block)ctx.get());
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), "ladder")).texture("particle", texture)).texture("texture", texture);
            prov.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(arg_0 -> TropicraftBlocks.lambda$static$148((ModelFile)model, arg_0), new Property[]{LadderBlock.f_54338_});
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).m_126130_("S S").m_126130_("BSB").m_126130_("S S").m_126127_(Character.valueOf('S'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_41911_).m_126132_("has_bamboo", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov)).item().model(TropicraftBlocks::blockSprite).build()).register();
        BAMBOO_BOARDWALK = TropicraftBlocks.boardwalk("bamboo_boardwalk", BAMBOO_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.right((Object)new ResourceLocation("tropicraft", "block/bamboo_side"))).register();
        PALM_BOARDWALK = TropicraftBlocks.boardwalk("palm_boardwalk", PALM_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(PALM_PLANKS)).register();
        MAHOGANY_BOARDWALK = TropicraftBlocks.boardwalk("mahogany_boardwalk", MAHOGANY_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(MAHOGANY_PLANKS)).register();
        MANGROVE_BOARDWALK = TropicraftBlocks.boardwalk("mangrove_boardwalk", MANGROVE_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(MANGROVE_PLANKS)).register();
        BAMBOO_CHEST = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("bamboo_chest", p -> new BambooChestBlock((BlockBehaviour.Properties)p, () -> (BlockEntityType)BAMBOO_CHEST_ENTITY.get())).initialProperties(BAMBOO_BUNDLE).properties(p -> p.m_60978_(1.0f)).blockstate((ctx, prov) -> TropicraftBlocks.noModelBlock((DataGenContext<Block, ? extends Block>)ctx, prov, prov.modLoc("block/bamboo_side"))).blockEntity(BambooChestBlockEntity::new).renderer(() -> BambooChestRenderer::new).build()).item(TropicraftBlocks.itemWithRenderer(TropicraftItemRenderers::bambooChest)).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), "item/chest")).texture("particle", prov.modLoc("block/bamboo_side"))).build()).addMiscData(ProviderType.LANG, prov -> {
            prov.add("tropicraft.container.bambooChest", "Bamboo Chest");
            prov.add("tropicraft.container.bambooChestDouble", "Large Bamboo Chest");
        })).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_("BBB").m_126130_("B B").m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)Items.f_41911_).m_126132_("has_bamboo", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov)).register();
        BAMBOO_CHEST_ENTITY = BlockEntityEntry.cast((RegistryEntry)BAMBOO_CHEST.getSibling(ForgeRegistries.BLOCK_ENTITY_TYPES));
        SIFTER = ((BlockBuilder)REGISTRATE.block("sifter", SifterBlock::new).initialProperties(() -> Blocks.f_50705_).properties(BlockBehaviour.Properties::m_60955_).addLayer(() -> RenderType::m_110463_).simpleBlockEntity(SifterBlockEntity::new).setData(ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, "Place any type of tropics or regular sand in the sifter. What treasures are hidden inside?"))).recipe((ctx, prov) -> {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_("XXX").m_126130_("XIX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_206416_(Character.valueOf('I'), Tags.Items.GLASS).m_126145_("tropicraft:sifter").m_126132_("has_glass", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS)).m_176498_((Consumer)prov);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_("XXX").m_126130_("XIX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_206416_(Character.valueOf('I'), Tags.Items.GLASS_PANES).m_126145_("tropicraft:sifter").m_126132_("has_glass_pane", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS_PANES)).m_126140_((Consumer)prov, new ResourceLocation("tropicraft", "sifter_with_glass_pane"));
        }).simpleItem().register();
        SIFTER_ENTITY = BlockEntityEntry.cast((RegistryEntry)SIFTER.getSibling(ForgeRegistries.BLOCK_ENTITY_TYPES));
        DRINK_MIXER = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("drink_mixer", DrinkMixerBlock::new).properties(p -> p.m_284180_(MapColor.f_283947_).m_60913_(2.0f, 30.0f).m_60955_().m_280658_(NoteBlockInstrument.BASEDRUM)).blockstate((ctx, prov) -> TropicraftBlocks.noModelBlock((DataGenContext<Block, ? extends Block>)ctx, prov, prov.modLoc("block/chunk"))).blockEntity(DrinkMixerBlockEntity::new).renderer(() -> DrinkMixerRenderer::new).build()).item(TropicraftBlocks.itemWithRenderer(TropicraftItemRenderers::drinkMixer)).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.modLoc("item/tall_machine"))).texture("particle", prov.modLoc("block/chunk"))).build()).addLayer(() -> RenderType::m_110463_).setData(ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, "Place two drink ingredients on the mixer, then place an empty mug on the base, then ???, then enjoy!"))).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)CHUNK.get()).m_126127_(Character.valueOf('Y'), (ItemLike)TropicraftItems.BAMBOO_MUG.get()).m_126132_("has_bamboo_mug", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_MUG.get()))).m_176498_((Consumer)prov)).register();
        DRINK_MIXER_ENTITY = BlockEntityEntry.cast((RegistryEntry)DRINK_MIXER.getSibling(ForgeRegistries.BLOCK_ENTITY_TYPES));
        AIR_COMPRESSOR = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("air_compressor", AirCompressorBlock::new).properties(p -> p.m_284180_(MapColor.f_283947_).m_60913_(2.0f, 30.0f).m_60955_().m_280658_(NoteBlockInstrument.BASEDRUM)).blockstate((ctx, prov) -> TropicraftBlocks.noModelBlock((DataGenContext<Block, ? extends Block>)ctx, prov, prov.modLoc("block/chunk"))).blockEntity(AirCompressorBlockEntity::new).renderer(() -> AirCompressorRenderer::new).build()).item(TropicraftBlocks.itemWithRenderer(TropicraftItemRenderers::airCompressor)).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.modLoc("item/tall_machine"))).texture("particle", prov.modLoc("block/chunk"))).build()).addLayer(() -> RenderType::m_110463_).setData(ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, "Place an empty scuba harness in the compressor to fill it with air!"))).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)1).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)CHUNK.get()).m_126127_(Character.valueOf('Y'), (ItemLike)TropicraftItems.AZURITE.get()).m_126132_("has_" + prov.safeName((ItemLike)CHUNK.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)CHUNK.get()))).m_126132_("has_" + prov.safeName((ItemLike)TropicraftItems.AZURITE.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.AZURITE.get()))).m_176498_((Consumer)prov)).register();
        AIR_COMPRESSOR_ENTITY = BlockEntityEntry.cast((RegistryEntry)AIR_COMPRESSOR.getSibling(ForgeRegistries.BLOCK_ENTITY_TYPES));
        VOLCANO = REGISTRATE.block("volcano", VolcanoBlock::new).initialProperties(() -> Blocks.f_50752_).properties(BlockBehaviour.Properties::m_222994_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(prov.mcLoc("block/bedrock")))).simpleBlockEntity(VolcanoBlockEntity::new).register();
        VOLCANO_ENTITY = BlockEntityEntry.cast((RegistryEntry)VOLCANO.getSibling(ForgeRegistries.BLOCK_ENTITY_TYPES));
        TIKI_TORCH = ((BlockBuilder)REGISTRATE.block("tiki_torch", TikiTorchBlock::new).initialProperties(() -> Blocks.f_50081_).properties(p -> p.m_60918_(SoundType.f_56736_).m_60953_(state -> state.m_61143_(TikiTorchBlock.SECTION) == TikiTorchBlock.TorchSection.UPPER ? 15 : 0)).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, block, TikiTorchBlock.SECTION, TikiTorchBlock.TorchSection.UPPER))).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> {
            ModelBuilder tikiLower = prov.models().torch("tiki_torch_lower", prov.modLoc("block/tiki_torch_lower"));
            ModelBuilder tikiUpper = prov.models().torch("tiki_torch_upper", prov.modLoc("block/tiki_torch_upper"));
            prov.getVariantBuilder((Block)ctx.get()).forAllStates(arg_0 -> TropicraftBlocks.lambda$static$184((ModelFile)tikiUpper, (ModelFile)tikiLower, arg_0));
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_("Y").m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_206416_(Character.valueOf('Y'), ItemTags.f_13160_).m_126132_("has_bamboo_stick", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_STICK.get()))).m_176498_((Consumer)prov)).item().defaultModel().build()).register();
        BAMBOO_FLOWER_POT = ((BlockBuilder)REGISTRATE.block("bamboo_flower_pot", p -> new FlowerPotBlock(null, () -> Blocks.f_50016_, p)).properties(p -> p.m_60913_(0.2f, 5.0f).m_60918_(SoundType.f_56754_).m_278166_(PushReaction.DESTROY)).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> TropicraftBlocks.flowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, (Supplier<? extends Block>)ctx, prov.modLoc("block/bamboo_side"))).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_("# #").m_126130_(" # ").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_41911_).m_126132_("has_bamboo", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov)).item().defaultModel().build()).register();
        COFFEE_BUSH = REGISTRATE.block("coffee_bush", CoffeeBushBlock::new).properties(p -> p.m_284180_(MapColor.f_283824_).m_60978_(0.15f).m_60918_(SoundType.f_56740_).m_60955_().m_278166_(PushReaction.DESTROY)).loot((loot, block) -> loot.m_247577_((Block)block, TropicraftBlocks.dropNumberOfItems(loot, (Block)COFFEE_BUSH.get(), TropicraftItems.RAW_COFFEE_BEAN, 1, 3))).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)CoffeeBushBlock.AGE);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_stage_" + age, prov.modLoc("coffee_bush"))).texture("bush", prov.modLoc("block/" + ctx.getName() + "_stage" + age));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        })).register();
        GOLDEN_LEATHER_FERN = ((BlockBuilder)REGISTRATE.block("small_golden_leather_fern", p -> new GrowableSinglePlantBlock((BlockBehaviour.Properties)p, () -> TALL_GOLDEN_LEATHER_FERN)).initialProperties(() -> Blocks.f_50035_).properties(p -> p.m_222979_(BlockBehaviour.OffsetType.XZ)).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross(ctx.getName(), prov.modLoc("block/small_golden_leather_fern")))).lang("Golden Leather Fern").item().model((ctx, prov) -> prov.generated((com.tterrag.registrate.util.nullness.NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/golden_leather_fern")})).build()).register();
        TALL_GOLDEN_LEATHER_FERN = REGISTRATE.block("tall_golden_leather_fern", p -> new GrowableDoublePlantBlock((BlockBehaviour.Properties)p, () -> LARGE_GOLDEN_LEATHER_FERN).setPickItem(() -> GOLDEN_LEATHER_FERN)).initialProperties(() -> Blocks.f_50360_).loot((loot, block) -> loot.m_246125_((Block)block, (ItemLike)GOLDEN_LEATHER_FERN.get())).addLayer(() -> RenderType::m_110463_).blockstate(TropicraftBlocks::doublePlant).register();
        LARGE_GOLDEN_LEATHER_FERN = REGISTRATE.block("golden_leather_fern", p -> new HugePlantBlock((BlockBehaviour.Properties)p).setPickItem(() -> GOLDEN_LEATHER_FERN)).properties(p -> p.m_284180_(MapColor.f_283915_).m_60955_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY)).loot((loot, block) -> loot.m_246125_((Block)block, (ItemLike)GOLDEN_LEATHER_FERN.get())).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> {
            BlockModelBuilder cross = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/huge_cross"))).texture("cross", prov.modLoc("block/large_golden_leather_fern"))).texture("particle", prov.blockTexture((Block)GOLDEN_LEATHER_FERN.get()));
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)cross).addModel()).condition(HugePlantBlock.TYPE, (Comparable[])new HugePlantBlock.Type[]{HugePlantBlock.Type.CENTER});
        }).lang("Large Golden Leather Fern").register();
        EEL_GRASS = TropicraftBlocks.seagrass("eel_grass", "Enhalus acoroides", () -> TALL_EEL_GRASS).register();
        TALL_EEL_GRASS = TropicraftBlocks.tallSeagrass("tall_eel_grass", "Enhalus acoroides", EEL_GRASS).register();
        FLOWERING_EEL_GRASS = TropicraftBlocks.seagrass("flowering_eel_grass", "Enhalus acoroides", () -> FLOWERING_TALL_EEL_GRASS).register();
        FLOWERING_TALL_EEL_GRASS = TropicraftBlocks.tallSeagrass("flowering_tall_eel_grass", "Enhalus acoroides", FLOWERING_EEL_GRASS).register();
        MATTED_EEL_GRASS = TropicraftBlocks.mattedSeagrassBlock("matted_eel_grass", "Enhalus acoroides").register();
        EEL_GRASS_BLOCK = TropicraftBlocks.seagrassBlock("eel_grass", "Enhalus acoroides").register();
        FERN_SEAGRASS = TropicraftBlocks.seagrass("fern_seagrass", "Halophila spinulosa", () -> TALL_FERN_SEAGRASS).register();
        TALL_FERN_SEAGRASS = TropicraftBlocks.tallSeagrass("tall_fern_seagrass", "Halophila spinulosa", FERN_SEAGRASS).register();
        MATTED_FERN_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_fern_seagrass", "Halophila spinulosa").register();
        FERN_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("fern_seagrass", "Halophila spinulosa").register();
        SICKLE_SEAGRASS = TropicraftBlocks.seagrass("sickle_seagrass", "Thalassodendron ciliatum", () -> TALL_SICKLE_SEAGRASS).register();
        TALL_SICKLE_SEAGRASS = TropicraftBlocks.tallSeagrass("tall_sickle_seagrass", "Thalassodendron ciliatum", SICKLE_SEAGRASS).register();
        MATTED_SICKLE_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_sickle_seagrass", "Thalassodendron ciliatum").register();
        SICKLE_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("sickle_seagrass", "Thalassodendron ciliatum").register();
        NOODLE_SEAGRASS = TropicraftBlocks.seagrass("noodle_seagrass", "Syringodium isoetifolium", null).register();
        MATTED_NOODLE_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_noodle_seagrass", "Syringodium isoetifolium").register();
        NOODLE_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("noodle_seagrass", "Syringodium isoetifolium").register();
        POTTABLE_PLANTS = ImmutableSet.builder().add((Object[])new BlockEntry[]{PALM_SAPLING, MAHOGANY_SAPLING, GRAPEFRUIT_SAPLING, LEMON_SAPLING, LIME_SAPLING, ORANGE_SAPLING}).add(IRIS).addAll(FLOWERS.values()).build();
        BAMBOO_POTTED_TROPICS_PLANTS = POTTABLE_PLANTS.stream().map(plant -> TropicraftBlocks.bambooPot("bamboo_potted_" + plant.getId().m_135815_(), (Supplier<? extends Block>)plant)).toList();
        VANILLA_POTTED_TROPICS_PLANTS = POTTABLE_PLANTS.stream().map(plant -> TropicraftBlocks.vanillaPot("potted_" + plant.getId().m_135815_(), (Supplier<? extends Block>)plant)).toList();
        BAMBOO_POTTED_VANILLA_PLANTS = Stream.of(Blocks.f_50746_, Blocks.f_50747_, Blocks.f_50748_, Blocks.f_50749_, Blocks.f_50750_, Blocks.f_50751_, Blocks.f_50035_, Blocks.f_50111_, Blocks.f_50112_, Blocks.f_50113_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50116_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50119_, Blocks.f_50120_, Blocks.f_50121_, Blocks.f_50071_, Blocks.f_50070_, Blocks.f_50073_, Blocks.f_50072_, Blocks.f_50036_, Blocks.f_50128_).map(plant -> TropicraftBlocks.bambooPot("bamboo_potted_" + TropicraftBlocks.name((ItemLike)plant), () -> plant)).toList();
        ALL_POTTED_PLANTS = ImmutableList.builder().addAll(BAMBOO_POTTED_TROPICS_PLANTS).addAll(VANILLA_POTTED_TROPICS_PLANTS).addAll(BAMBOO_POTTED_VANILLA_PLANTS).build();
        JIGARBOV_WALL_TORCHES = (Map)Arrays.stream(JigarbovTorchType.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), type -> REGISTRATE.block("jigarbov_" + type.getName() + "_wall_torch", p -> new RedstoneWallTorchBlock((BlockBehaviour.Properties)p){

            public String m_7705_() {
                return Util.m_137492_((String)"block", (ResourceLocation)BuiltInRegistries.f_256975_.m_7981_((Object)this));
            }

            public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
                return new ItemStack((ItemLike)Items.f_41978_);
            }
        }).initialProperties(() -> Blocks.f_50123_).addLayer(() -> RenderType::m_110457_).blockstate((ctx, prov) -> {
            ResourceLocation parent = prov.modLoc("block/jigarbov_wall_torch");
            ResourceLocation etchTexture = prov.modLoc("block/jigarbov/" + type.getName());
            BlockModelBuilder modelLit = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), parent)).texture("torch", prov.mcLoc("block/redstone_torch"))).texture("jigarbov", etchTexture);
            BlockModelBuilder modelOff = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_off", parent)).texture("torch", prov.mcLoc("block/redstone_torch_off"))).texture("jigarbov", etchTexture);
            prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                boolean lit = (Boolean)state.m_61143_((Property)RedstoneTorchBlock.f_55674_);
                Direction facing = (Direction)state.m_61143_((Property)RedstoneWallTorchBlock.f_55740_);
                int angle = ((int)facing.m_122435_() + 90) % 360;
                return ConfiguredModel.builder().modelFile((ModelFile)(lit ? modelLit : modelOff)).rotationY(angle).build();
            });
        }).loot((loot, block) -> loot.m_246125_((Block)block, (ItemLike)Items.f_41978_)).register()));
    }
}

