/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;

public enum TropicraftFlower implements Supplier<Block>
{
    ACAI_VINE(MobEffects.f_19605_, 0, 7, 16, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS),
    ANEMONE(MobEffects.f_19605_, 0, 9, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    BROMELIAD(MobEffects.f_19605_, 0, 9, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    CANNA(MobEffects.f_19605_, 0, Items.f_42539_, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    COMMELINA_DIFFUSA(MobEffects.f_19605_, 0, Items.f_42538_, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    CROCOSMIA(MobEffects.f_19605_, 0, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    CROTON(MobEffects.f_19605_, 0, 13, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS),
    DRACAENA(MobEffects.f_19605_, 0, 13, Items.f_42496_, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    TROPICAL_FERN(MobEffects.f_19605_, 0, 13, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS),
    FOLIAGE(MobEffects.f_19605_, 0, 13, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS),
    MAGIC_MUSHROOM(MobEffects.f_19605_, 0, 11, null, BlockTags.f_13037_, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    ORANGE_ANTHURIUM(MobEffects.f_19605_, 0, 11, Items.f_42536_, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    ORCHID(MobEffects.f_19605_, 0, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    PATHOS(MobEffects.f_19605_, 0, 15, 12, null, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    RED_ANTHURIUM(MobEffects.f_19605_, 0, 11, Items.f_42497_, BlockTags.f_13037_, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS);

    private final MobEffect effect;
    private final int effectDuration;
    private final VoxelShape shape;
    private final TagKey<Block>[] tags;
    @Nullable
    private final Item dye;

    @SafeVarargs
    private TropicraftFlower(MobEffect effect, int effectDuration, Item dye, TagKey<Block> ... tags) {
        this(effect, effectDuration, 7, dye, tags);
    }

    @SafeVarargs
    private TropicraftFlower(MobEffect effect, int effectDuration, int w, Item dye, TagKey<Block> ... tags) {
        this(effect, effectDuration, w, 15, dye, tags);
    }

    @SafeVarargs
    private TropicraftFlower(MobEffect effect, int effectDuration, int w, int h, Item dye, TagKey<Block> ... tags) {
        this(null, effect, effectDuration, w, h, dye, tags);
    }

    @SafeVarargs
    private TropicraftFlower(String name, MobEffect effect, int effectDuration, @Nullable int w, int h, Item dye, TagKey<Block> ... tags) {
        this.effect = effect;
        this.effectDuration = effectDuration;
        this.dye = dye;
        this.tags = tags;
        float halfW = (float)w / 2.0f;
        this.shape = Block.m_49796_((double)(8.0f - halfW), (double)0.0, (double)(8.0f - halfW), (double)(8.0f + halfW), (double)h, (double)(8.0f + halfW));
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Block get() {
        return (Block)TropicraftBlocks.FLOWERS.get(this).get();
    }

    public TagKey<Block>[] getTags() {
        return this.tags;
    }

    @Nullable
    public Item getDye() {
        return this.dye;
    }
}

