/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.huge_plant;

import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.client.ParticleEffects;

public final class HugePlantBlock
extends BushBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    private Supplier<RegistryEntry<? extends ItemLike>> pickItem;

    public HugePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)Type.SEED)));
    }

    public HugePlantBlock setPickItem(Supplier<RegistryEntry<? extends ItemLike>> item) {
        this.pickItem = item;
        return this;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (BlockPos plantPos : Shape.fromSeed((Block)this, pos)) {
            if (plantPos.equals((Object)pos) || world.m_8055_(plantPos).m_60629_(context)) continue;
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)Type.SEED));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Shape shape = Shape.fromSeed((Block)this, pos);
        for (BlockPos plantPos : shape) {
            if (plantPos.equals((Object)pos)) continue;
            BlockState plantState = shape.blockAt(plantPos);
            world.m_7731_(plantPos, plantState, 3);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        Shape shape = Shape.match((Block)this, (BlockGetter)world, pos);
        if (shape == null) {
            return Blocks.f_50016_.m_49966_();
        }
        if (this.isValidPosition(world, shape)) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    private boolean isValidPosition(LevelAccessor world, Shape shape) {
        BlockPos seedPos = shape.seed();
        BlockState seedState = world.m_8055_(seedPos);
        return super.m_7898_(seedState, (LevelReader)world, seedPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (HugePlantBlock.isSeedBlock((Block)this, state)) {
            BlockState worldState = world.m_8055_(pos);
            if (worldState != state && !this.isValidPositionToPlace(world, pos)) {
                return false;
            }
            return super.m_7898_(state, world, pos);
        }
        return Shape.match((Block)this, (BlockGetter)world, pos) != null;
    }

    private boolean isValidPositionToPlace(LevelReader world, BlockPos pos) {
        for (BlockPos plantPos : Shape.fromSeed((Block)this, pos)) {
            if (world.m_8055_(plantPos).m_247087_()) continue;
            return false;
        }
        return true;
    }

    public void placeAt(LevelAccessor world, BlockPos pos, int flags) {
        Shape shape = Shape.fromSeed((Block)this, pos);
        for (BlockPos plantPos : shape) {
            BlockState plantState = shape.blockAt(plantPos);
            world.m_7731_(plantPos, plantState, flags);
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        Shape shape = Shape.match((Block)this, (BlockGetter)world, pos);
        if (shape == null) {
            return;
        }
        if (!world.f_46443_) {
            if (!player.m_7500_()) {
                HugePlantBlock.m_49881_((BlockState)state, (Level)world, (BlockPos)shape.seed(), null, (Entity)player, (ItemStack)player.m_21205_());
            }
            int flags = 50;
            SoundType soundtype = state.getSoundType((LevelReader)world, pos, null);
            world.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            for (BlockPos plantPos : shape) {
                world.m_7731_(plantPos, Blocks.f_50016_.m_49966_(), flags);
            }
        } else {
            for (BlockPos plantPos : shape) {
                ParticleEffects.breakBlockWithFewerParticles(world, state, plantPos);
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        if (state.m_61143_(TYPE) == Type.SEED) {
            return super.m_49635_(state, params);
        }
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (this.pickItem != null) {
            return new ItemStack((ItemLike)this.pickItem.get().get());
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE});
    }

    private static boolean isSeedBlock(Block block, BlockState state) {
        return state.m_60713_(block) && state.m_61143_(TYPE) == Type.SEED;
    }

    public static enum Type implements StringRepresentable
    {
        SEED("seed"),
        CENTER("center"),
        OUTER("outer");

        private final String key;

        private Type(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }
    }

    public static final class Shape
    implements Iterable<BlockPos> {
        public static final int RADIUS = 1;
        private final Block block;
        private final BlockPos seed;

        private Shape(Block block, BlockPos seed) {
            this.block = block;
            this.seed = seed;
        }

        public static Shape fromSeed(Block block, BlockPos seed) {
            return new Shape(block, seed);
        }

        @Nullable
        public static Shape match(Block block, BlockGetter world, BlockPos pos) {
            for (BlockPos plantPos : Shape.matchPositions(pos)) {
                Shape shape;
                if (!HugePlantBlock.isSeedBlock(block, world.m_8055_(plantPos)) || !(shape = Shape.fromSeed(block, plantPos)).validate(world)) continue;
                return shape;
            }
            return null;
        }

        @Nullable
        public static Shape matchIncomplete(Block block, BlockGetter world, BlockPos pos) {
            for (BlockPos plantPos : Shape.matchPositions(pos)) {
                if (!HugePlantBlock.isSeedBlock(block, world.m_8055_(plantPos))) continue;
                return Shape.fromSeed(block, plantPos);
            }
            return null;
        }

        private static Iterable<BlockPos> matchPositions(BlockPos pos) {
            BlockPos minPos = pos.m_7918_(-1, -2, -1);
            BlockPos maxPos = pos.m_7918_(1, 0, 1);
            return BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos);
        }

        public boolean validate(BlockGetter world) {
            for (BlockPos pos : this) {
                if (world.m_8055_(pos).m_60713_(this.block)) continue;
                return false;
            }
            return true;
        }

        public BlockState blockAt(BlockPos pos) {
            Type type = Type.OUTER;
            if (pos.equals((Object)this.seed())) {
                type = Type.SEED;
            } else if (pos.equals((Object)this.center())) {
                type = Type.CENTER;
            }
            return (BlockState)this.block.m_49966_().m_61124_(TYPE, (Comparable)((Object)type));
        }

        public BlockPos seed() {
            return this.seed;
        }

        public BlockPos center() {
            return this.seed.m_7918_(0, 1, 0);
        }

        public AABB asAabb() {
            BlockPos seed = this.seed;
            return new AABB((double)(seed.m_123341_() - 1), (double)seed.m_123342_(), (double)(seed.m_123343_() - 1), (double)(seed.m_123341_() + 1) + 1.0, (double)(seed.m_123342_() + 2) + 1.0, (double)(seed.m_123343_() + 1) + 1.0);
        }

        @Override
        public Iterator<BlockPos> iterator() {
            BlockPos center = this.center();
            return BlockPos.m_121940_((BlockPos)center.m_7918_(-1, -1, -1), (BlockPos)center.m_7918_(1, 1, 1)).iterator();
        }
    }
}

