/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.tileentity.IMachineBlock;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.network.message.MessageAirCompressorInventory;

public class AirCompressorBlockEntity
extends BlockEntity
implements IMachineBlock {
    private boolean compressing;
    private int ticks;
    private static final int fillRate = 5;
    @Nonnull
    private ItemStack stack = ItemStack.f_41583_;
    private ScubaArmorItem tank;

    public AirCompressorBlockEntity(BlockEntityType<AirCompressorBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.compressing = nbt.m_128471_("Compressing");
        if (nbt.m_128441_("Tank")) {
            this.setTank(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Tank")));
        } else {
            this.setTank(ItemStack.f_41583_);
        }
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Compressing", this.compressing);
        CompoundTag var4 = new CompoundTag();
        this.stack.m_41739_(var4);
        nbt.m_128365_("Tank", (Tag)var4);
    }

    public void setTank(@Nonnull ItemStack tankItemStack) {
        this.stack = tankItemStack;
        this.tank = !(this.stack.m_41720_() instanceof ScubaArmorItem) ? null : (ScubaArmorItem)this.stack.m_41720_();
    }

    @Nonnull
    public ItemStack getTankStack() {
        return this.stack;
    }

    @Nullable
    public ScubaArmorItem getTank() {
        return this.tank;
    }

    public static void compressTick(Level level, BlockPos pos, BlockState state, AirCompressorBlockEntity te) {
        te.tick();
    }

    private void tick() {
        if (this.tank == null) {
            return;
        }
        int airContained = this.tank.getRemainingAir(this.getTankStack());
        int maxAir = this.tank.getMaxAir(this.getTankStack());
        if (this.compressing) {
            int overflow = this.tank.addAir(5, this.getTankStack());
            ++this.ticks;
            if (overflow > 0) {
                this.finishCompressing();
            }
        }
    }

    public boolean addTank(ItemStack stack) {
        if (this.tank == null && stack.m_41720_() instanceof ScubaArmorItem && ((ScubaArmorItem)stack.m_41720_()).providesAir()) {
            this.setTank(stack);
            this.compressing = true;
            this.syncInventory();
            return true;
        }
        return false;
    }

    public void ejectTank() {
        if (!this.stack.m_41619_() && !this.f_58857_.f_46443_) {
            ItemEntity tankItem = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), this.stack);
            this.f_58857_.m_7967_((Entity)tankItem);
        }
        this.setTank(ItemStack.f_41583_);
        this.syncInventory();
        this.ticks = 0;
        this.compressing = false;
    }

    public boolean isDoneCompressing() {
        return this.ticks > 0 && !this.compressing;
    }

    public float getTickRatio(float partialTicks) {
        if (this.tank != null) {
            return ((float)this.ticks + partialTicks) / (float)(this.tank.getMaxAir(this.getTankStack()) * 5);
        }
        return 0.0f;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void startCompressing() {
        this.compressing = true;
        this.syncInventory();
    }

    public void finishCompressing() {
        this.compressing = false;
        this.ticks = 0;
        this.syncInventory();
    }

    public float getBreatheProgress(float partialTicks) {
        if (this.isDoneCompressing()) {
            return 0.0f;
        }
        return (float)(((double)(((float)this.ticks + partialTicks) / 20.0f) * Math.PI + Math.PI) % (Math.PI * 2));
    }

    @Override
    public boolean isActive() {
        return !this.getTankStack().m_41619_();
    }

    @Override
    public float getProgress(float partialTicks) {
        return this.getTickRatio(partialTicks);
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_(AirCompressorBlock.FACING);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected void syncInventory() {
        if (!this.f_58857_.f_46443_) {
            TropicraftPackets.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.m_58899_())), (Object)new MessageAirCompressorInventory(this));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }
}

