/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.command.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public class MapBiomesCommand {
    private static final int SIZE = 4096;
    private static final int SIZE2 = 2048;
    private static final int SIZE8 = 512;
    private static final Object2IntOpenHashMap<ResourceLocation> COLORS = new Object2IntOpenHashMap();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mapbiomes").requires(s -> s.m_6761_(2))).executes(c -> MapBiomesCommand.execute((CommandSourceStack)c.getSource())));
    }

    private static int execute(CommandSourceStack source) {
        if (!source.m_81372_().m_46472_().equals(TropicraftDimension.WORLD)) {
            source.m_81352_((Component)Component.m_237113_((String)"Can't execute this in non-tropicraft world!"));
        }
        BufferedImage img = new BufferedImage(4096, 4096, 1);
        Optional biomes = source.m_81372_().m_9598_().m_6632_(Registries.f_256952_);
        if (biomes.isPresent()) {
            for (int x = -2048; x < 2048; ++x) {
                if (x % 512 == 0) {
                    double progress = (double)(x + 2048) / 4096.0;
                    source.m_288197_(() -> Component.m_237113_((String)(progress * 100.0 + "%")), false);
                }
                for (int z = -2048; z < 2048; ++z) {
                    Biome biome = (Biome)source.m_81372_().m_203675_(x, 0, z).m_203334_();
                    ResourceLocation name = ((Registry)biomes.get()).m_7981_((Object)biome);
                    img.setRGB(x + 2048, z + 2048, COLORS.getOrDefault((Object)name, 0xFFFFFF));
                }
            }
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Biomes Registry was null!"));
        }
        Path p = Paths.get("biome_colors.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
            source.m_288197_(() -> Component.m_237113_((String)"Mapped biome colors!"), false);
        }
        catch (IOException e) {
            source.m_81352_((Component)Component.m_237113_((String)"Something went wrong, check the log!"));
            e.printStackTrace();
        }
        return 0;
    }

    static {
        COLORS.put((Object)TropicraftBiomes.TROPICS.m_135782_(), 8183411);
        COLORS.put((Object)TropicraftBiomes.RAINFOREST.m_135782_(), 4175157);
        COLORS.put((Object)TropicraftBiomes.OSA_RAINFOREST.m_135782_(), 5820749);
        COLORS.put((Object)TropicraftBiomes.BAMBOO_RAINFOREST.m_135782_(), 5751356);
        COLORS.put((Object)TropicraftBiomes.MANGROVES.m_135782_(), 4491059);
        COLORS.put((Object)TropicraftBiomes.OVERGROWN_MANGROVES.m_135782_(), 6129459);
        COLORS.put((Object)TropicraftBiomes.OCEAN.m_135782_(), 5226953);
        COLORS.put((Object)TropicraftBiomes.RIVER.m_135782_(), 5226953);
        COLORS.put((Object)TropicraftBiomes.KELP_FOREST.m_135782_(), 5228975);
        COLORS.put((Object)TropicraftBiomes.BEACH.m_135782_(), 15262615);
    }
}

